/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.ArrayList;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.Params;
import redis.clients.jedis.util.SafeEncoder;

public class SetParams
extends Params {
    private static final String XX = "xx";
    private static final String NX = "nx";
    private static final String PX = "px";
    private static final String EX = "ex";

    public static SetParams setParams() {
        return new SetParams();
    }

    public SetParams ex(int secondsToExpire) {
        this.addParam(EX, secondsToExpire);
        return this;
    }

    public SetParams px(long millisecondsToExpire) {
        this.addParam(PX, millisecondsToExpire);
        return this;
    }

    public SetParams nx() {
        this.addParam(NX);
        return this;
    }

    public SetParams xx() {
        this.addParam(XX);
        return this;
    }

    public byte[][] getByteParams(byte[] ... args) {
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (byte[] arg : args) {
            byteParams.add(arg);
        }
        if (this.contains(NX)) {
            byteParams.add(SafeEncoder.encode(NX));
        }
        if (this.contains(XX)) {
            byteParams.add(SafeEncoder.encode(XX));
        }
        if (this.contains(EX)) {
            byteParams.add(SafeEncoder.encode(EX));
            byteParams.add(Protocol.toByteArray((Integer)this.getParam(EX)));
        }
        if (this.contains(PX)) {
            byteParams.add(SafeEncoder.encode(PX));
            byteParams.add(Protocol.toByteArray((Long)this.getParam(PX)));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }
}

