/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Set;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisPool;

public class JedisSlotBasedConnectionHandler
extends JedisClusterConnectionHandler {
    private Jedis currentConnection;

    public JedisSlotBasedConnectionHandler(Set<HostAndPort> nodes) {
        super(nodes);
    }

    @Override
    public Jedis getConnection() {
        return this.currentConnection != null ? this.currentConnection : (Jedis)this.getRandomConnection().getResource();
    }

    private void returnCurrentConnection() {
        if (this.currentConnection != null) {
            ((JedisPool)this.nodes.get(this.currentConnection.getClient().getHost() + this.currentConnection.getClient().getPort())).returnResource(this.currentConnection);
        }
    }

    @Override
    public void assignSlotToNode(int slot, HostAndPort targetNode) {
        super.assignSlotToNode(slot, targetNode);
        this.getConnectionFromSlot(slot);
    }

    @Override
    public Jedis getConnectionFromSlot(int slot) {
        this.returnCurrentConnection();
        JedisPool connectionPool = (JedisPool)this.slots.get(slot);
        if (connectionPool == null) {
            connectionPool = this.getRandomConnection();
        }
        this.currentConnection = (Jedis)connectionPool.getResource();
        return this.currentConnection;
    }
}

