/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BasicCommands;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSlotBasedConnectionHandler;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;

public class JedisCluster
implements JedisCommands,
BasicCommands {
    public static final short HASHSLOTS = 16384;
    private static final int DEFAULT_TIMEOUT = 1;
    private static final int DEFAULT_MAX_REDIRECTIONS = 5;
    private int timeout;
    private int maxRedirections;
    private JedisClusterConnectionHandler connectionHandler;

    public JedisCluster(Set<HostAndPort> nodes, int timeout) {
        this(nodes, timeout, 5);
    }

    public JedisCluster(Set<HostAndPort> nodes) {
        this(nodes, 1);
    }

    public JedisCluster(Set<HostAndPort> jedisClusterNode, int timeout, int maxRedirections) {
        this.connectionHandler = new JedisSlotBasedConnectionHandler(jedisClusterNode);
        this.timeout = timeout;
        this.maxRedirections = maxRedirections;
    }

    @Override
    public String set(final String key, final String value) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().set(key, value);
            }
        }.run(key);
    }

    @Override
    public String get(final String key) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().get(key);
            }
        }.run(key);
    }

    @Override
    public Boolean exists(final String key) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Boolean execute() {
                return JedisCluster.this.connectionHandler.getConnection().exists(key);
            }
        }.run(key);
    }

    @Override
    public Long persist(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().persist(key);
            }
        }.run(key);
    }

    @Override
    public String type(final String key) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().type(key);
            }
        }.run(key);
    }

    @Override
    public Long expire(final String key, final int seconds) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().expire(key, seconds);
            }
        }.run(key);
    }

    @Override
    public Long expireAt(final String key, final long unixTime) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().expireAt(key, unixTime);
            }
        }.run(key);
    }

    @Override
    public Long ttl(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().ttl(key);
            }
        }.run(key);
    }

    @Override
    public Boolean setbit(final String key, final long offset, final boolean value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Boolean execute() {
                return JedisCluster.this.connectionHandler.getConnection().setbit(key, offset, value);
            }
        }.run(key);
    }

    @Override
    public Boolean setbit(final String key, final long offset, final String value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Boolean execute() {
                return JedisCluster.this.connectionHandler.getConnection().setbit(key, offset, value);
            }
        }.run(key);
    }

    @Override
    public Boolean getbit(final String key, final long offset) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Boolean execute() {
                return JedisCluster.this.connectionHandler.getConnection().getbit(key, offset);
            }
        }.run(key);
    }

    @Override
    public Long setrange(final String key, final long offset, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().setrange(key, offset, value);
            }
        }.run(key);
    }

    @Override
    public String getrange(final String key, final long startOffset, final long endOffset) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().getrange(key, startOffset, endOffset);
            }
        }.run(key);
    }

    @Override
    public String getSet(final String key, final String value) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().getSet(key, value);
            }
        }.run(key);
    }

    @Override
    public Long setnx(final String key, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().setnx(key, value);
            }
        }.run(key);
    }

    @Override
    public String setex(final String key, final int seconds, final String value) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().setex(key, seconds, value);
            }
        }.run(key);
    }

    @Override
    public Long decrBy(final String key, final long integer) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().decrBy(key, integer);
            }
        }.run(key);
    }

    @Override
    public Long decr(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().decr(key);
            }
        }.run(key);
    }

    @Override
    public Long incrBy(final String key, final long integer) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().incrBy(key, integer);
            }
        }.run(key);
    }

    @Override
    public Long incr(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().incr(key);
            }
        }.run(key);
    }

    @Override
    public Long append(final String key, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().append(key, value);
            }
        }.run(key);
    }

    @Override
    public String substr(final String key, final int start, final int end) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().substr(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Long hset(final String key, final String field, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().hset(key, field, value);
            }
        }.run(key);
    }

    @Override
    public String hget(final String key, final String field) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().hget(key, field);
            }
        }.run(key);
    }

    @Override
    public Long hsetnx(final String key, final String field, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().hsetnx(key, field, value);
            }
        }.run(key);
    }

    @Override
    public String hmset(final String key, final Map<String, String> hash) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().hmset(key, hash);
            }
        }.run(key);
    }

    @Override
    public List<String> hmget(final String key, final String ... fields) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().hmget(key, fields);
            }
        }.run(key);
    }

    @Override
    public Long hincrBy(final String key, final String field, final long value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().hincrBy(key, field, value);
            }
        }.run(key);
    }

    @Override
    public Boolean hexists(final String key, final String field) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Boolean execute() {
                return JedisCluster.this.connectionHandler.getConnection().hexists(key, field);
            }
        }.run(key);
    }

    @Override
    public Long hdel(final String key, final String ... field) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().hdel(key, field);
            }
        }.run(key);
    }

    @Override
    public Long hlen(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().hdel(key, new String[0]);
            }
        }.run(key);
    }

    @Override
    public Set<String> hkeys(final String key) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().hkeys(key);
            }
        }.run(key);
    }

    @Override
    public List<String> hvals(final String key) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().hvals(key);
            }
        }.run(key);
    }

    @Override
    public Map<String, String> hgetAll(final String key) {
        return (Map)new JedisClusterCommand<Map<String, String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Map<String, String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().hgetAll(key);
            }
        }.run(key);
    }

    @Override
    public Long rpush(final String key, final String ... string) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().rpush(key, string);
            }
        }.run(key);
    }

    @Override
    public Long lpush(final String key, final String ... string) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().lpush(key, string);
            }
        }.run(key);
    }

    @Override
    public Long llen(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().llen(key);
            }
        }.run(key);
    }

    @Override
    public List<String> lrange(final String key, final long start, final long end) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().lrange(key, start, end);
            }
        }.run(key);
    }

    @Override
    public String ltrim(final String key, final long start, final long end) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().ltrim(key, start, end);
            }
        }.run(key);
    }

    @Override
    public String lindex(final String key, final long index) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().lindex(key, index);
            }
        }.run(key);
    }

    @Override
    public String lset(final String key, final long index, final String value) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().lset(key, index, value);
            }
        }.run(key);
    }

    @Override
    public Long lrem(final String key, final long count, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().lrem(key, count, value);
            }
        }.run(key);
    }

    @Override
    public String lpop(final String key) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().lpop(key);
            }
        }.run(key);
    }

    @Override
    public String rpop(final String key) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().rpop(key);
            }
        }.run(key);
    }

    @Override
    public Long sadd(final String key, final String ... member) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().sadd(key, member);
            }
        }.run(key);
    }

    @Override
    public Set<String> smembers(final String key) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().smembers(key);
            }
        }.run(key);
    }

    @Override
    public Long srem(final String key, final String ... member) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().srem(key, member);
            }
        }.run(key);
    }

    @Override
    public String spop(final String key) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().spop(key);
            }
        }.run(key);
    }

    @Override
    public Long scard(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().scard(key);
            }
        }.run(key);
    }

    @Override
    public Boolean sismember(final String key, final String member) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Boolean execute() {
                return JedisCluster.this.connectionHandler.getConnection().sismember(key, member);
            }
        }.run(key);
    }

    @Override
    public String srandmember(final String key) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().srandmember(key);
            }
        }.run(key);
    }

    @Override
    public Long strlen(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().strlen(key);
            }
        }.run(key);
    }

    @Override
    public Long zadd(final String key, final double score, final String member) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zadd(key, score, member);
            }
        }.run(key);
    }

    @Override
    public Long zadd(final String key, final Map<String, Double> scoreMembers) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zadd(key, scoreMembers);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrange(final String key, final long start, final long end) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrange(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Long zrem(final String key, final String ... member) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrem(key, member);
            }
        }.run(key);
    }

    @Override
    public Double zincrby(final String key, final double score, final String member) {
        return (Double)new JedisClusterCommand<Double>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Double execute() {
                return JedisCluster.this.connectionHandler.getConnection().zincrby(key, score, member);
            }
        }.run(key);
    }

    @Override
    public Long zrank(final String key, final String member) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrank(key, member);
            }
        }.run(key);
    }

    @Override
    public Long zrevrank(final String key, final String member) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrank(key, member);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrevrange(final String key, final long start, final long end) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrange(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrangeWithScores(final String key, final long start, final long end) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeWithScores(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(final String key, final long start, final long end) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeWithScores(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Long zcard(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zcard(key);
            }
        }.run(key);
    }

    @Override
    public Double zscore(final String key, final String member) {
        return (Double)new JedisClusterCommand<Double>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Double execute() {
                return JedisCluster.this.connectionHandler.getConnection().zscore(key, member);
            }
        }.run(key);
    }

    @Override
    public List<String> sort(final String key) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().sort(key);
            }
        }.run(key);
    }

    @Override
    public List<String> sort(final String key, final SortingParams sortingParameters) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().sort(key, sortingParameters);
            }
        }.run(key);
    }

    @Override
    public Long zcount(final String key, final double min, final double max) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zcount(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Long zcount(final String key, final String min, final String max) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zcount(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrangeByScore(final String key, final double min, final double max) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScore(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrangeByScore(final String key, final String min, final String max) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScore(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrevrangeByScore(final String key, final double max, final double min) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScore(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrangeByScore(final String key, final double min, final double max, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScore(key, min, max, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrevrangeByScore(final String key, final String max, final String min) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScore(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrangeByScore(final String key, final String min, final String max, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScore(key, min, max, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrevrangeByScore(final String key, final double max, final double min, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScore(key, min, max, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(final String key, final double min, final double max) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScoreWithScores(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(final String key, final double max, final double min) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScoreWithScores(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(final String key, final double min, final double max, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScoreWithScores(key, min, max, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<String> zrevrangeByScore(final String key, final String max, final String min, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScore(key, min, max, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(final String key, final String min, final String max) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScoreWithScores(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(final String key, final String max, final String min) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScoreWithScores(key, min, max);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(final String key, final String min, final String max, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrangeByScoreWithScores(key, min, max, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(final String key, final double max, final double min, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScoreWithScores(key, max, min, offset, count);
            }
        }.run(key);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(final String key, final String max, final String min, final int offset, final int count) {
        return (Set)new JedisClusterCommand<Set<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Set<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zrevrangeByScoreWithScores(key, max, min, offset, count);
            }
        }.run(key);
    }

    @Override
    public Long zremrangeByRank(final String key, final long start, final long end) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zremrangeByRank(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Long zremrangeByScore(final String key, final double start, final double end) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zremrangeByScore(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Long zremrangeByScore(final String key, final String start, final String end) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().zremrangeByScore(key, start, end);
            }
        }.run(key);
    }

    @Override
    public Long linsert(final String key, final BinaryClient.LIST_POSITION where, final String pivot, final String value) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().linsert(key, where, pivot, value);
            }
        }.run(key);
    }

    @Override
    public Long lpushx(final String key, final String ... string) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().lpushx(key, string);
            }
        }.run(key);
    }

    @Override
    public Long rpushx(final String key, final String ... string) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().rpushx(key, string);
            }
        }.run(key);
    }

    @Override
    public List<String> blpop(final String arg) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().blpop(arg);
            }
        }.run(null);
    }

    @Override
    public List<String> brpop(final String arg) {
        return (List)new JedisClusterCommand<List<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public List<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().brpop(arg);
            }
        }.run(null);
    }

    @Override
    public Long del(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().del(key);
            }
        }.run(null);
    }

    @Override
    public String echo(final String string) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().echo(string);
            }
        }.run(null);
    }

    @Override
    public Long move(final String key, final int dbIndex) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().move(key, dbIndex);
            }
        }.run(key);
    }

    @Override
    public Long bitcount(final String key) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().bitcount(key);
            }
        }.run(key);
    }

    @Override
    public Long bitcount(final String key, final long start, final long end) {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().bitcount(key, start, end);
            }
        }.run(key);
    }

    @Override
    public String ping() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().ping();
            }
        }.run(null);
    }

    @Override
    public String quit() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().quit();
            }
        }.run(null);
    }

    @Override
    public String flushDB() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().flushDB();
            }
        }.run(null);
    }

    @Override
    public Long dbSize() {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().dbSize();
            }
        }.run(null);
    }

    @Override
    public String select(final int index) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().select(index);
            }
        }.run(null);
    }

    @Override
    public String flushAll() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().flushAll();
            }
        }.run(null);
    }

    @Override
    public String auth(final String password) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().auth(password);
            }
        }.run(null);
    }

    @Override
    public String save() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().save();
            }
        }.run(null);
    }

    @Override
    public String bgsave() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().bgsave();
            }
        }.run(null);
    }

    @Override
    public String bgrewriteaof() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().bgrewriteaof();
            }
        }.run(null);
    }

    @Override
    public Long lastsave() {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().lastsave();
            }
        }.run(null);
    }

    @Override
    public String shutdown() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().shutdown();
            }
        }.run(null);
    }

    @Override
    public String info() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().info();
            }
        }.run(null);
    }

    @Override
    public String info(final String section) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().info(section);
            }
        }.run(null);
    }

    @Override
    public String slaveof(final String host, final int port) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().slaveof(host, port);
            }
        }.run(null);
    }

    @Override
    public String slaveofNoOne() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().slaveofNoOne();
            }
        }.run(null);
    }

    @Override
    public Long getDB() {
        return (Long)new JedisClusterCommand<Long>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public Long execute() {
                return JedisCluster.this.connectionHandler.getConnection().getDB();
            }
        }.run(null);
    }

    @Override
    public String debug(final DebugParams params) {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().debug(params);
            }
        }.run(null);
    }

    @Override
    public String configResetStat() {
        return (String)new JedisClusterCommand<String>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public String execute() {
                return JedisCluster.this.connectionHandler.getConnection().configResetStat();
            }
        }.run(null);
    }

    public Map<String, JedisPool> getClusterNodes() {
        return this.connectionHandler.getNodes();
    }

    @Override
    public Long waitReplicas(int replicas, long timeout) {
        return null;
    }

    @Override
    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(final String key, final int cursor) {
        return (ScanResult)new JedisClusterCommand<ScanResult<Map.Entry<String, String>>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public ScanResult<Map.Entry<String, String>> execute() {
                return JedisCluster.this.connectionHandler.getConnection().hscan(key, cursor);
            }
        }.run(null);
    }

    @Override
    @Deprecated
    public ScanResult<String> sscan(final String key, final int cursor) {
        return (ScanResult)new JedisClusterCommand<ScanResult<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public ScanResult<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().sscan(key, cursor);
            }
        }.run(null);
    }

    @Override
    @Deprecated
    public ScanResult<Tuple> zscan(final String key, final int cursor) {
        return (ScanResult)new JedisClusterCommand<ScanResult<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public ScanResult<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zscan(key, cursor);
            }
        }.run(null);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(final String key, final String cursor) {
        return (ScanResult)new JedisClusterCommand<ScanResult<Map.Entry<String, String>>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public ScanResult<Map.Entry<String, String>> execute() {
                return JedisCluster.this.connectionHandler.getConnection().hscan(key, cursor);
            }
        }.run(null);
    }

    @Override
    public ScanResult<String> sscan(final String key, final String cursor) {
        return (ScanResult)new JedisClusterCommand<ScanResult<String>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public ScanResult<String> execute() {
                return JedisCluster.this.connectionHandler.getConnection().sscan(key, cursor);
            }
        }.run(null);
    }

    @Override
    public ScanResult<Tuple> zscan(final String key, final String cursor) {
        return (ScanResult)new JedisClusterCommand<ScanResult<Tuple>>(this.connectionHandler, this.timeout, this.maxRedirections){

            @Override
            public ScanResult<Tuple> execute() {
                return JedisCluster.this.connectionHandler.getConnection().zscan(key, cursor);
            }
        }.run(null);
    }
}

