/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.util.Hashing;
import redis.clients.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShardedJedisPool
extends Pool<ShardedJedis> {
    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards) {
        this(poolConfig, shards, Hashing.MD5);
    }

    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards, Hashing algo) {
        this(poolConfig, shards, algo, null);
    }

    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards, Pattern keyTagPattern) {
        this(poolConfig, shards, Hashing.MD5, keyTagPattern);
    }

    public ShardedJedisPool(GenericObjectPool.Config poolConfig, List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(poolConfig, (PoolableObjectFactory)new ShardedJedisFactory(shards, algo, keyTagPattern));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShardedJedisFactory
    extends BasePoolableObjectFactory {
        private List<JedisShardInfo> shards;
        private Hashing algo;
        private Pattern keyTagPattern;

        public ShardedJedisFactory(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
            this.shards = shards;
            this.algo = algo;
            this.keyTagPattern = keyTagPattern;
        }

        public Object makeObject() throws Exception {
            ShardedJedis jedis = new ShardedJedis(this.shards, this.algo, this.keyTagPattern);
            boolean done = false;
            while (!done) {
                try {
                    for (Jedis shard : jedis.getAllShards()) {
                        if (shard.isConnected()) continue;
                        shard.connect();
                    }
                    done = true;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {}
                }
            }
            return jedis;
        }

        public void destroyObject(Object obj) throws Exception {
            if (obj != null) {
                try {
                    ((ShardedJedis)obj).disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean validateObject(Object obj) {
            try {
                ShardedJedis jedis = (ShardedJedis)obj;
                for (Jedis shard : jedis.getAllShards()) {
                    if (shard.isConnected() && shard.ping().equals("PONG")) continue;
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

