/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.Client;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.SafeEncoder;

public abstract class JedisPubSub {
    private int subscribedChannels = 0;
    private Client client;

    public abstract void onMessage(String var1, String var2);

    public abstract void onPMessage(String var1, String var2, String var3);

    public abstract void onSubscribe(String var1, int var2);

    public abstract void onUnsubscribe(String var1, int var2);

    public abstract void onPUnsubscribe(String var1, int var2);

    public abstract void onPSubscribe(String var1, int var2);

    public void unsubscribe() {
        this.client.unsubscribe();
    }

    public void unsubscribe(String ... channels) {
        this.client.unsubscribe(channels);
    }

    public void subscribe(String ... channels) {
        this.client.subscribe(channels);
    }

    public void psubscribe(String ... patterns) {
        this.client.psubscribe(patterns);
    }

    public void punsubscribe() {
        this.client.punsubscribe();
    }

    public void punsubscribe(String ... patterns) {
        this.client.punsubscribe(patterns);
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Client client, String ... patterns) {
        this.client = client;
        client.psubscribe(patterns);
        this.process(client);
    }

    public void proceed(Client client, String ... channels) {
        this.client = client;
        client.subscribe(channels);
        this.process(client);
    }

    private void process(Client client) {
        do {
            String strpattern;
            byte[] bpattern;
            String strchannel;
            byte[] bchannel;
            List<Object> reply;
            Object firstObj;
            if (!((firstObj = (reply = client.getObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + firstObj);
            }
            byte[] resp = (byte[])firstObj;
            if (Arrays.equals(Protocol.Keyword.SUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                strchannel = bchannel == null ? null : SafeEncoder.encode(bchannel);
                this.onSubscribe(strchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.UNSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                strchannel = bchannel == null ? null : SafeEncoder.encode(bchannel);
                this.onUnsubscribe(strchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.MESSAGE.raw, resp)) {
                bchannel = (byte[])reply.get(1);
                byte[] bmesg = (byte[])reply.get(2);
                String strchannel2 = bchannel == null ? null : SafeEncoder.encode(bchannel);
                String strmesg = bmesg == null ? null : SafeEncoder.encode(bmesg);
                this.onMessage(strchannel2, strmesg);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PMESSAGE.raw, resp)) {
                bpattern = (byte[])reply.get(1);
                byte[] bchannel2 = (byte[])reply.get(2);
                byte[] bmesg = (byte[])reply.get(3);
                String strpattern2 = bpattern == null ? null : SafeEncoder.encode(bpattern);
                String strchannel3 = bchannel2 == null ? null : SafeEncoder.encode(bchannel2);
                String strmesg = bmesg == null ? null : SafeEncoder.encode(bmesg);
                this.onPMessage(strpattern2, strchannel3, strmesg);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPSubscribe(strpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PUNSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                strpattern = bpattern == null ? null : SafeEncoder.encode(bpattern);
                this.onPUnsubscribe(strpattern, this.subscribedChannels);
                continue;
            }
            throw new JedisException("Unknown message type: " + firstObj);
        } while (this.isSubscribed());
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

