/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;
import redis.clients.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connection {
    private String host;
    private int port = 6379;
    private Socket socket;
    private Protocol protocol = new Protocol();
    private RedisOutputStream outputStream;
    private RedisInputStream inputStream;
    private int pipelinedCommands = 0;
    private int timeout = 2000;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTimeoutInfinite() {
        try {
            this.socket.setSoTimeout(0);
        }
        catch (SocketException ex) {
            throw new JedisException(ex);
        }
    }

    public void rollbackTimeout() {
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException ex) {
            throw new JedisException(ex);
        }
    }

    public Connection(String host) {
        this.host = host;
    }

    protected Connection sendCommand(Protocol.Command cmd, String ... args) {
        byte[][] bargs = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            bargs[i] = SafeEncoder.encode(args[i]);
        }
        return this.sendCommand(cmd, bargs);
    }

    protected Connection sendCommand(Protocol.Command cmd, byte[] ... args) {
        this.connect();
        this.protocol.sendCommand(this.outputStream, cmd, args);
        ++this.pipelinedCommands;
        return this;
    }

    protected Connection sendCommand(Protocol.Command cmd) {
        this.connect();
        this.protocol.sendCommand(this.outputStream, cmd, (byte[][])new byte[0][]);
        ++this.pipelinedCommands;
        return this;
    }

    public Connection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Connection() {
    }

    public void connect() {
        if (!this.isConnected()) {
            try {
                this.socket = new Socket(this.host, this.port);
                this.socket.setSoTimeout(this.timeout);
                this.outputStream = new RedisOutputStream(this.socket.getOutputStream());
                this.inputStream = new RedisInputStream(this.socket.getInputStream());
            }
            catch (IOException ex) {
                throw new JedisConnectionException(ex);
            }
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException ex) {
                throw new JedisConnectionException(ex);
            }
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isBound() && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    protected String getStatusCodeReply() {
        --this.pipelinedCommands;
        byte[] resp = (byte[])this.protocol.read(this.inputStream);
        if (null == resp) {
            return null;
        }
        return SafeEncoder.encode(resp);
    }

    public String getBulkReply() {
        byte[] result = this.getBinaryBulkReply();
        if (null != result) {
            return SafeEncoder.encode(result);
        }
        return null;
    }

    public byte[] getBinaryBulkReply() {
        --this.pipelinedCommands;
        return (byte[])this.protocol.read(this.inputStream);
    }

    public Long getIntegerReply() {
        --this.pipelinedCommands;
        return (Long)this.protocol.read(this.inputStream);
    }

    public List<String> getMultiBulkReply() {
        List<byte[]> bresult = this.getBinaryMultiBulkReply();
        if (null == bresult) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(bresult.size());
        for (byte[] barray : bresult) {
            if (barray == null) {
                result.add(null);
                continue;
            }
            result.add(SafeEncoder.encode(barray));
        }
        return result;
    }

    public List<byte[]> getBinaryMultiBulkReply() {
        --this.pipelinedCommands;
        return (List)this.protocol.read(this.inputStream);
    }

    public List<Object> getObjectMultiBulkReply() {
        --this.pipelinedCommands;
        return (List)this.protocol.read(this.inputStream);
    }

    public List<Object> getAll() {
        ArrayList<Object> all = new ArrayList<Object>();
        while (this.pipelinedCommands > 0) {
            all.add(this.protocol.read(this.inputStream));
            --this.pipelinedCommands;
        }
        return all;
    }

    public Object getOne() {
        --this.pipelinedCommands;
        return this.protocol.read(this.inputStream);
    }
}

