/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZParams {
    private List<byte[]> params = new ArrayList<byte[]>();

    public ZParams weights(int ... weights) {
        this.params.add(Protocol.Keyword.WEIGHTS.raw);
        for (int weight : weights) {
            this.params.add(Protocol.toByteArray(weight));
        }
        return this;
    }

    public Collection<byte[]> getParams() {
        return Collections.unmodifiableCollection(this.params);
    }

    public ZParams aggregate(Aggregate aggregate) {
        this.params.add(Protocol.Keyword.AGGREGATE.raw);
        this.params.add(aggregate.raw);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Aggregate {
        SUM,
        MIN,
        MAX;

        public final byte[] raw = SafeEncoder.encode(this.name());
    }
}

