/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import redis.clients.jedis.Protocol;

public class Tuple {
    private byte[] element;
    private Double score;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (null != this.element) {
            for (byte b : this.element) {
                result = 31 * result + b;
            }
        }
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        if (this.element == null ? other.element != null : !Arrays.equals(this.element, other.element)) {
            return false;
        }
        return Double.doubleToLongBits(this.score) == Double.doubleToLongBits(other.score);
    }

    public Tuple(String element, Double score) {
        this.element = element.getBytes(Protocol.UTF8);
        this.score = score;
    }

    public Tuple(byte[] element, Double score) {
        this.element = element;
        this.score = score;
    }

    public String getElement() {
        if (null != this.element) {
            return new String(this.element, Protocol.UTF8);
        }
        return null;
    }

    public byte[] getBinaryElement() {
        return this.element;
    }

    public double getScore() {
        return this.score;
    }

    public String toString() {
        return '[' + Arrays.toString(this.element) + ',' + this.score + ']';
    }
}

