/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisException;
import redis.clients.util.RedisInputStream;
import redis.clients.util.RedisOutputStream;

public final class Protocol {
    public static final int DEFAULT_PORT = 6379;
    public static final byte DOLLAR_BYTE = 36;
    public static final byte ASTERISK_BYTE = 42;
    public static final byte PLUS_BYTE = 43;
    public static final byte MINUS_BYTE = 45;
    public static final byte COLON_BYTE = 58;

    public void sendCommand(RedisOutputStream os, String name, String ... args) {
        try {
            os.write(42);
            os.writeIntCrLf(args.length + 1);
            os.write(36);
            os.writeIntCrLf(name.length());
            os.writeAsciiCrLf(name);
            for (String str : args) {
                os.write(36);
                int size = RedisOutputStream.utf8Length(str);
                os.writeIntCrLf(size);
                if (size == str.length()) {
                    os.writeAsciiCrLf(str);
                    continue;
                }
                os.writeUtf8CrLf(str);
            }
            os.flush();
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
    }

    private void processError(RedisInputStream is) {
        String message = is.readLine();
        throw new JedisException(message);
    }

    private Object process(RedisInputStream is) {
        try {
            byte b = is.readByte();
            if (b != 45) {
                if (b == 42) {
                    return this.processMultiBulkReply(is);
                }
                if (b == 58) {
                    return this.processInteger(is);
                }
                if (b == 36) {
                    return this.processBulkReply(is);
                }
                if (b == 43) {
                    return this.processStatusCodeReply(is);
                }
                throw new JedisException("Unknown reply: " + (char)b);
            }
            this.processError(is);
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
        return null;
    }

    private String processStatusCodeReply(RedisInputStream is) {
        return is.readLine();
    }

    private String processBulkReply(RedisInputStream is) {
        int len = Integer.parseInt(is.readLine());
        if (len == -1) {
            return null;
        }
        byte[] read = new byte[len];
        try {
            for (int offset = 0; offset < len; offset += is.read(read, offset, len - offset)) {
            }
            is.readByte();
            is.readByte();
        }
        catch (IOException e) {
            throw new JedisException(e);
        }
        return new String(read, RedisOutputStream.CHARSET);
    }

    private Integer processInteger(RedisInputStream is) {
        String num = is.readLine();
        return Integer.valueOf(num);
    }

    private List<Object> processMultiBulkReply(RedisInputStream is) {
        int num = Integer.parseInt(is.readLine());
        if (num == -1) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            ret.add(this.process(is));
        }
        return ret;
    }

    public Object read(RedisInputStream is) {
        return this.process(is);
    }
}

