/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Client;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.JedisException;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPipeline;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;

public class Jedis {
    private Client client = null;

    public Jedis(String host) {
        this.client = new Client(host);
    }

    public Jedis(String host, int port) {
        this.client = new Client(host, port);
    }

    public Jedis(String host, int port, int timeout) {
        this.client = new Client(host, port);
        this.client.setTimeout(timeout);
    }

    public Jedis(JedisShardInfo shardInfo) {
        this.client = new Client(shardInfo.getHost(), shardInfo.getPort());
        this.client.setTimeout(shardInfo.getTimeout());
        if (shardInfo.getPassword() != null) {
            this.auth(shardInfo.getPassword());
        }
    }

    public String ping() {
        this.checkIsInMulti();
        this.client.ping();
        return this.client.getStatusCodeReply();
    }

    public String set(String key, String value) {
        this.checkIsInMulti();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    public String get(String key) {
        this.checkIsInMulti();
        this.client.sendCommand("GET", key);
        return this.client.getBulkReply();
    }

    public void quit() {
        this.checkIsInMulti();
        this.client.quit();
    }

    public Integer exists(String key) {
        this.checkIsInMulti();
        this.client.exists(key);
        return this.client.getIntegerReply();
    }

    public Integer del(String ... keys) {
        this.checkIsInMulti();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    public String type(String key) {
        this.checkIsInMulti();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    public String flushDB() {
        this.checkIsInMulti();
        this.client.flushDB();
        return this.client.getStatusCodeReply();
    }

    public List<String> keys(String pattern) {
        this.checkIsInMulti();
        this.client.keys(pattern);
        return this.client.getMultiBulkReply();
    }

    public String randomKey() {
        this.checkIsInMulti();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    public String rename(String oldkey, String newkey) {
        this.checkIsInMulti();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    public Integer renamenx(String oldkey, String newkey) {
        this.checkIsInMulti();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    public Integer dbSize() {
        this.checkIsInMulti();
        this.client.dbSize();
        return this.client.getIntegerReply();
    }

    public Integer expire(String key, int seconds) {
        this.checkIsInMulti();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    public Integer expireAt(String key, long unixTime) {
        this.checkIsInMulti();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    public Integer ttl(String key) {
        this.checkIsInMulti();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    public String select(int index) {
        this.checkIsInMulti();
        this.client.select(index);
        return this.client.getStatusCodeReply();
    }

    public Integer move(String key, int dbIndex) {
        this.checkIsInMulti();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    public String flushAll() {
        this.checkIsInMulti();
        this.client.flushAll();
        return this.client.getStatusCodeReply();
    }

    public String getSet(String key, String value) {
        this.checkIsInMulti();
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    public List<String> mget(String ... keys) {
        this.checkIsInMulti();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    public Integer setnx(String key, String value) {
        this.checkIsInMulti();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    public String setex(String key, int seconds, String value) {
        this.checkIsInMulti();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    public String mset(String ... keysvalues) {
        this.checkIsInMulti();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    public Integer msetnx(String ... keysvalues) {
        this.checkIsInMulti();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    public Integer decrBy(String key, int integer) {
        this.checkIsInMulti();
        this.client.decrBy(key, integer);
        return this.client.getIntegerReply();
    }

    public Integer decr(String key) {
        this.checkIsInMulti();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    public Integer incrBy(String key, int integer) {
        this.checkIsInMulti();
        this.client.incrBy(key, integer);
        return this.client.getIntegerReply();
    }

    public Integer incr(String key) {
        this.checkIsInMulti();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    public Integer append(String key, String value) {
        this.checkIsInMulti();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    public String substr(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.substr(key, start, end);
        return this.client.getBulkReply();
    }

    public Integer hset(String key, String field, String value) {
        this.checkIsInMulti();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    public String hget(String key, String field) {
        this.checkIsInMulti();
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    public Integer hsetnx(String key, String field, String value) {
        this.checkIsInMulti();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    public String hmset(String key, Map<String, String> hash) {
        this.checkIsInMulti();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    public List<String> hmget(String key, String ... fields) {
        this.checkIsInMulti();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    public Integer hincrBy(String key, String field, int value) {
        this.checkIsInMulti();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    public Integer hexists(String key, String field) {
        this.checkIsInMulti();
        this.client.hexists(key, field);
        return this.client.getIntegerReply();
    }

    public Integer hdel(String key, String field) {
        this.checkIsInMulti();
        this.client.hdel(key, field);
        return this.client.getIntegerReply();
    }

    public Integer hlen(String key) {
        this.checkIsInMulti();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    public List<String> hkeys(String key) {
        this.checkIsInMulti();
        this.client.hkeys(key);
        return this.client.getMultiBulkReply();
    }

    public List<String> hvals(String key) {
        this.checkIsInMulti();
        this.client.hvals(key);
        return this.client.getMultiBulkReply();
    }

    public Map<String, String> hgetAll(String key) {
        this.checkIsInMulti();
        this.client.hgetAll(key);
        List<String> flatHash = this.client.getMultiBulkReply();
        HashMap<String, String> hash = new HashMap<String, String>();
        Iterator<String> iterator = flatHash.iterator();
        while (iterator.hasNext()) {
            hash.put(iterator.next(), iterator.next());
        }
        return hash;
    }

    public Integer rpush(String key, String string) {
        this.checkIsInMulti();
        this.client.rpush(key, string);
        return this.client.getIntegerReply();
    }

    public Integer lpush(String key, String string) {
        this.checkIsInMulti();
        this.client.lpush(key, string);
        return this.client.getIntegerReply();
    }

    public Integer llen(String key) {
        this.checkIsInMulti();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    public List<String> lrange(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.lrange(key, start, end);
        return this.client.getMultiBulkReply();
    }

    public String ltrim(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.ltrim(key, start, end);
        return this.client.getStatusCodeReply();
    }

    public String lindex(String key, int index) {
        this.checkIsInMulti();
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    public String lset(String key, int index, String value) {
        this.checkIsInMulti();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    public Integer lrem(String key, int count, String value) {
        this.checkIsInMulti();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    public String lpop(String key) {
        this.checkIsInMulti();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    public String rpop(String key) {
        this.checkIsInMulti();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMulti();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    public Integer sadd(String key, String member) {
        this.checkIsInMulti();
        this.client.sadd(key, member);
        return this.client.getIntegerReply();
    }

    public Set<String> smembers(String key) {
        this.checkIsInMulti();
        this.client.smembers(key);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Integer srem(String key, String member) {
        this.checkIsInMulti();
        this.client.srem(key, member);
        return this.client.getIntegerReply();
    }

    public String spop(String key) {
        this.checkIsInMulti();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    public Integer smove(String srckey, String dstkey, String member) {
        this.checkIsInMulti();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    public Integer scard(String key) {
        this.checkIsInMulti();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    public Integer sismember(String key, String member) {
        this.checkIsInMulti();
        this.client.sismember(key, member);
        return this.client.getIntegerReply();
    }

    public Set<String> sinter(String ... keys) {
        this.checkIsInMulti();
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Integer sinterstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<String> sunion(String ... keys) {
        this.checkIsInMulti();
        this.client.sunion(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Integer sunionstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public Set<String> sdiff(String ... keys) {
        this.checkIsInMulti();
        this.client.sdiff(keys);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Integer sdiffstore(String dstkey, String ... keys) {
        this.checkIsInMulti();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    public String srandmember(String key) {
        this.checkIsInMulti();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    public Integer zadd(String key, double score, String member) {
        this.checkIsInMulti();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    public Set<String> zrange(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Integer zrem(String key, String member) {
        this.checkIsInMulti();
        this.client.zrem(key, member);
        return this.client.getIntegerReply();
    }

    public Double zincrby(String key, double score, String member) {
        this.checkIsInMulti();
        this.client.zincrby(key, score, member);
        String newscore = this.client.getBulkReply();
        return Double.valueOf(newscore);
    }

    public Integer zrank(String key, String member) {
        this.checkIsInMulti();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    public Integer zrevrank(String key, String member) {
        this.checkIsInMulti();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    public Set<String> zrevrange(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrevrange(key, start, end);
        List<String> members = this.client.getMultiBulkReply();
        return new LinkedHashSet<String>(members);
    }

    public Set<Tuple> zrangeWithScores(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    public Set<Tuple> zrevrangeWithScores(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.zrevrangeWithScores(key, start, end);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    public Integer zcard(String key) {
        this.checkIsInMulti();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    public Double zscore(String key, String member) {
        this.checkIsInMulti();
        this.client.zscore(key, member);
        String score = this.client.getBulkReply();
        return score != null ? new Double(score) : null;
    }

    public Transaction multi() {
        this.client.multi();
        this.client.getStatusCodeReply();
        return new Transaction(this.client);
    }

    public List<Object> multi(TransactionBlock jedisTransaction) {
        List<Object> results = null;
        try {
            jedisTransaction.setClient(this.client);
            this.multi();
            jedisTransaction.execute();
            results = jedisTransaction.exec();
        }
        catch (Exception ex) {
            this.client.discard();
        }
        return results;
    }

    private void checkIsInMulti() {
        if (this.client.isInMulti()) {
            throw new JedisException("Cannot use Jedis when in Multi. Please use JedisTransaction instead.");
        }
    }

    public void connect() throws UnknownHostException, IOException {
        this.client.connect();
    }

    public void disconnect() throws IOException {
        this.client.disconnect();
    }

    public String watch(String key) {
        this.client.watch(key);
        return this.client.getStatusCodeReply();
    }

    public String unwatch() {
        this.client.unwatch();
        return this.client.getStatusCodeReply();
    }

    public List<String> sort(String key) {
        this.checkIsInMulti();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    public List<String> blpop(int timeout, String ... keys) {
        this.checkIsInMulti();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.client.blpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    public Integer sort(String key, SortingParams sortingParameters, String dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    public Integer sort(String key, String dstkey) {
        this.checkIsInMulti();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    public List<String> brpop(int timeout, String ... keys) {
        this.checkIsInMulti();
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : keys) {
            args.add(arg);
        }
        args.add(String.valueOf(timeout));
        this.client.brpop(args.toArray(new String[args.size()]));
        this.client.setTimeoutInfinite();
        List<String> multiBulkReply = this.client.getMultiBulkReply();
        this.client.rollbackTimeout();
        return multiBulkReply;
    }

    public String auth(String password) {
        this.checkIsInMulti();
        this.client.auth(password);
        return this.client.getStatusCodeReply();
    }

    public List<Object> pipelined(JedisPipeline jedisPipeline) {
        jedisPipeline.setClient(this.client);
        jedisPipeline.execute();
        return this.client.getAll();
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceed(this.client, channels);
        this.client.rollbackTimeout();
    }

    public Integer publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.client.setTimeoutInfinite();
        jedisPubSub.proceedWithPatterns(this.client, patterns);
        this.client.rollbackTimeout();
    }

    public Integer zcount(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScore(key, min, max, offset, count);
        return new LinkedHashSet<String>(this.client.getMultiBulkReply());
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.checkIsInMulti();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        Set<Tuple> set = this.getTupledSet();
        return set;
    }

    private Set<Tuple> getTupledSet() {
        this.checkIsInMulti();
        List<String> membersWithScores = this.client.getMultiBulkReply();
        LinkedHashSet<Tuple> set = new LinkedHashSet<Tuple>();
        Iterator<String> iterator = membersWithScores.iterator();
        while (iterator.hasNext()) {
            set.add(new Tuple(iterator.next(), Double.valueOf(iterator.next())));
        }
        return set;
    }

    public Integer zremrangeByRank(String key, int start, int end) {
        this.checkIsInMulti();
        this.client.zremrangeByRank(key, start, end);
        return this.client.getIntegerReply();
    }

    public Integer zremrangeByScore(String key, double start, double end) {
        this.checkIsInMulti();
        this.client.zremrangeByScore(key, start, end);
        return this.client.getIntegerReply();
    }

    public Integer zunionstore(String dstkey, String ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Integer zunionstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMulti();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public Integer zinterstore(String dstkey, String ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    public Integer zinterstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMulti();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    public String save() {
        this.client.save();
        return this.client.getStatusCodeReply();
    }

    public String bgsave() {
        this.client.bgsave();
        return this.client.getStatusCodeReply();
    }

    public String bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.client.getStatusCodeReply();
    }

    public Integer lastsave() {
        this.client.lastsave();
        return this.client.getIntegerReply();
    }

    public String shutdown() {
        this.client.shutdown();
        String status = null;
        try {
            status = this.client.getStatusCodeReply();
        }
        catch (JedisException ex) {
            status = null;
        }
        return status;
    }

    public String info() {
        this.client.info();
        return this.client.getBulkReply();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.client.monitor();
        jedisMonitor.proceed(this.client);
    }

    public String slaveof(String host, int port) {
        this.client.slaveof(host, port);
        return this.client.getStatusCodeReply();
    }

    public String slaveofNoOne() {
        this.client.slaveofNoOne();
        return this.client.getStatusCodeReply();
    }

    public List<String> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    public String configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public Integer strlen(String key) {
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    public void sync() {
        this.client.sync();
    }

    public Integer lpushx(String key, String string) {
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    public Integer persist(String key) {
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    public Integer rpushx(String key, String string) {
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    public String echo(String string) {
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    public Integer linsert(String key, Client.LIST_POSITION where, String pivot, String value) {
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    public String debug(DebugParams params) {
        this.client.debug(params);
        return this.client.getStatusCodeReply();
    }
}

