/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.microsoft.aad.msal4j.ManagedIdentityId;
import java.util.function.Function;

public class ManagedIdentityInfo {
    private IdentityType type;
    private UserManagedIdentityType userManagedIdentityType;
    private String id;

    public ManagedIdentityInfo() {
        this.type = IdentityType.SYSTEM_ASSIGNED;
    }

    public ManagedIdentityInfo(UserManagedIdentityType userManagedType, String id) {
        this.type = IdentityType.USER_ASSIGNED;
        this.userManagedIdentityType = userManagedType;
        this.id = id;
    }

    public ManagedIdentityId getId() {
        switch (this.type) {
            case SYSTEM_ASSIGNED: {
                return ManagedIdentityId.systemAssigned();
            }
            case USER_ASSIGNED: {
                return (ManagedIdentityId)this.userManagedIdentityType.func.apply(this.id);
            }
        }
        throw new UnsupportedOperationException("Operation not supported for the given identity type");
    }

    public static enum UserManagedIdentityType {
        CLIENT_ID(ManagedIdentityId::userAssignedClientId),
        OBJECT_ID(ManagedIdentityId::userAssignedObjectId),
        RESOURCE_ID(ManagedIdentityId::userAssignedResourceId);

        private final Function<String, ManagedIdentityId> func;

        private UserManagedIdentityType(Function<String, ManagedIdentityId> func) {
            this.func = func;
        }
    }

    public static enum IdentityType {
        SYSTEM_ASSIGNED,
        USER_ASSIGNED;

    }
}

