/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.azure.identity.DefaultAzureCredential;
import java.util.Collections;
import java.util.Set;
import redis.clients.authentication.core.IdentityProviderConfig;
import redis.clients.authentication.core.TokenAuthConfig;
import redis.clients.authentication.core.TokenManagerConfig;
import redis.clients.authentication.entraid.AzureIdentityProviderConfig;

public class AzureTokenAuthConfigBuilder
extends TokenAuthConfig.Builder<AzureTokenAuthConfigBuilder>
implements AutoCloseable {
    public static final float DEFAULT_EXPIRATION_REFRESH_RATIO = 0.75f;
    public static final int DEFAULT_LOWER_REFRESH_BOUND_MILLIS = 120000;
    public static final int DEFAULT_TOKEN_REQUEST_EXECUTION_TIMEOUT_IN_MS = 1000;
    public static final int DEFAULT_MAX_ATTEMPTS_TO_RETRY = 5;
    public static final int DEFAULT_DELAY_IN_MS_TO_RETRY = 100;
    public static final Set<String> DEFAULT_SCOPES = Collections.singleton("https://redis.azure.com/.default");
    private DefaultAzureCredential defaultAzureCredential;
    private Set<String> scopes = DEFAULT_SCOPES;
    private int tokenRequestExecTimeoutInMs = 1000;

    public AzureTokenAuthConfigBuilder() {
        ((AzureTokenAuthConfigBuilder)((AzureTokenAuthConfigBuilder)((AzureTokenAuthConfigBuilder)this.expirationRefreshRatio(0.75f)).lowerRefreshBoundMillis(120000)).tokenRequestExecTimeoutInMs(1000).maxAttemptsToRetry(5)).delayInMsToRetry(100);
    }

    public AzureTokenAuthConfigBuilder defaultAzureCredential(DefaultAzureCredential defaultAzureCredential) {
        this.defaultAzureCredential = defaultAzureCredential;
        return this;
    }

    public AzureTokenAuthConfigBuilder scopes(Set<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public AzureTokenAuthConfigBuilder tokenRequestExecTimeoutInMs(int tokenRequestExecTimeoutInMs) {
        super.tokenRequestExecTimeoutInMs(tokenRequestExecTimeoutInMs);
        this.tokenRequestExecTimeoutInMs = tokenRequestExecTimeoutInMs;
        return this;
    }

    public TokenAuthConfig build() {
        super.identityProviderConfig((IdentityProviderConfig)new AzureIdentityProviderConfig(this.defaultAzureCredential, this.scopes, this.tokenRequestExecTimeoutInMs));
        return super.build();
    }

    @Override
    public void close() throws Exception {
        this.defaultAzureCredential = null;
        this.scopes = null;
    }

    public static AzureTokenAuthConfigBuilder builder() {
        return new AzureTokenAuthConfigBuilder();
    }

    public static AzureTokenAuthConfigBuilder from(AzureTokenAuthConfigBuilder sample) {
        TokenAuthConfig tokenAuthConfig = TokenAuthConfig.Builder.from((TokenAuthConfig.Builder)sample).build();
        TokenManagerConfig tokenManagerConfig = tokenAuthConfig.getTokenManagerConfig();
        AzureTokenAuthConfigBuilder builder = (AzureTokenAuthConfigBuilder)((AzureTokenAuthConfigBuilder)((AzureTokenAuthConfigBuilder)((AzureTokenAuthConfigBuilder)((AzureTokenAuthConfigBuilder)new AzureTokenAuthConfigBuilder().expirationRefreshRatio(tokenManagerConfig.getExpirationRefreshRatio())).lowerRefreshBoundMillis(tokenManagerConfig.getLowerRefreshBoundMillis())).tokenRequestExecTimeoutInMs(tokenManagerConfig.getTokenRequestExecTimeoutInMs()).maxAttemptsToRetry(tokenManagerConfig.getRetryPolicy().getMaxAttempts())).delayInMsToRetry(tokenManagerConfig.getRetryPolicy().getdelayInMs())).identityProviderConfig(tokenAuthConfig.getIdentityProviderConfig());
        builder.defaultAzureCredential = sample.defaultAzureCredential;
        builder.scopes = sample.scopes;
        builder.tokenRequestExecTimeoutInMs = sample.tokenRequestExecTimeoutInMs;
        return builder;
    }
}

