/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.entraid;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.DefaultAzureCredential;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Supplier;
import redis.clients.authentication.core.IdentityProvider;
import redis.clients.authentication.core.Token;
import redis.clients.authentication.entraid.JWToken;

public final class AzureIdentityProvider
implements IdentityProvider {
    private Supplier<AccessToken> accessTokenSupplier;

    public AzureIdentityProvider(DefaultAzureCredential defaultAzureCredential, Set<String> scopes, int timeout) {
        TokenRequestContext ctx = new TokenRequestContext().setScopes(new ArrayList<String>(scopes));
        this.accessTokenSupplier = () -> (AccessToken)defaultAzureCredential.getToken(ctx).block(Duration.ofMillis(timeout));
    }

    public Token requestToken() {
        return new JWToken(this.accessTokenSupplier.get().getToken());
    }
}

