/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.core;

import java.util.Map;
import redis.clients.authentication.core.Token;

public class SimpleToken
implements Token {
    private String value;
    private long expiresAt;
    private long receivedAt;
    private Map<String, String> claims;

    public SimpleToken(String value, long expiresAt, long receivedAt, Map<String, String> claims) {
        this.value = value;
        this.expiresAt = expiresAt;
        this.receivedAt = receivedAt;
        this.claims = claims;
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    @Override
    public long ttl() {
        return this.expiresAt - System.currentTimeMillis();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public long getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public long getReceivedAt() {
        return this.receivedAt;
    }

    @Override
    public String tryGet(String key) {
        return this.claims.get(key);
    }
}

