/*
 * Decompiled with CFR 0.152.
 */
package rebus.permissionutils;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.legacy.app.FragmentCompat;
import java.util.ArrayList;
import java.util.Collections;
import rebus.permissionutils.AskAgainCallback;
import rebus.permissionutils.FullCallback;
import rebus.permissionutils.PermissionEnum;
import rebus.permissionutils.PermissionUtils;
import rebus.permissionutils.SimpleCallback;
import rebus.permissionutils.SmartCallback;

public class PermissionManager {
    private static PermissionManager instance;
    private FullCallback fullCallback;
    private SimpleCallback simpleCallback;
    private AskAgainCallback askAgainCallback;
    private SmartCallback smartCallback;
    private boolean askAgain = false;
    private ArrayList<PermissionEnum> permissions;
    private ArrayList<PermissionEnum> permissionsGranted;
    private ArrayList<PermissionEnum> permissionsDenied;
    private ArrayList<PermissionEnum> permissionsDeniedForever;
    private ArrayList<PermissionEnum> permissionToAsk;
    private int key = 100;

    public static PermissionManager Builder() {
        if (instance == null) {
            instance = new PermissionManager();
        }
        return instance;
    }

    public static void handleResult(@NonNull Activity activity, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        PermissionManager.handleResult(activity, null, null, requestCode, permissions, grantResults);
    }

    public static void handleResult(@NonNull androidx.fragment.app.Fragment fragmentX, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        PermissionManager.handleResult(null, fragmentX, null, requestCode, permissions, grantResults);
    }

    @Deprecated
    public static void handleResult(@NonNull Fragment fragment, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        PermissionManager.handleResult(null, null, fragment, requestCode, permissions, grantResults);
    }

    private static void handleResult(final Activity activity, final androidx.fragment.app.Fragment fragmentX, final Fragment fragment, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (instance == null) {
            return;
        }
        if (requestCode == PermissionManager.instance.key) {
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    PermissionManager.instance.permissionsGranted.add(PermissionEnum.fromManifestPermission(permissions[i]));
                    continue;
                }
                boolean permissionsDeniedForever = false;
                if (activity != null) {
                    permissionsDeniedForever = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permissions[i]);
                } else if (fragment != null) {
                    permissionsDeniedForever = FragmentCompat.shouldShowRequestPermissionRationale((Fragment)fragment, (String)permissions[i]);
                } else if (fragmentX != null) {
                    permissionsDeniedForever = fragmentX.shouldShowRequestPermissionRationale(permissions[i]);
                }
                if (!permissionsDeniedForever) {
                    PermissionManager.instance.permissionsDeniedForever.add(PermissionEnum.fromManifestPermission(permissions[i]));
                }
                PermissionManager.instance.permissionsDenied.add(PermissionEnum.fromManifestPermission(permissions[i]));
                PermissionManager.instance.permissionToAsk.add(PermissionEnum.fromManifestPermission(permissions[i]));
            }
            if (PermissionManager.instance.permissionToAsk.size() != 0 && PermissionManager.instance.askAgain) {
                PermissionManager.instance.askAgain = false;
                if (PermissionManager.instance.askAgainCallback != null && PermissionManager.instance.permissionsDeniedForever.size() != PermissionManager.instance.permissionsDenied.size()) {
                    PermissionManager.instance.askAgainCallback.showRequestPermission(new AskAgainCallback.UserResponse(){

                        @Override
                        public void result(boolean askAgain) {
                            if (askAgain) {
                                instance.ask(activity, fragmentX, fragment);
                            } else {
                                instance.showResult();
                            }
                        }
                    });
                } else {
                    instance.ask(activity, fragmentX, fragment);
                }
            } else {
                instance.showResult();
            }
        }
    }

    public PermissionManager permissions(ArrayList<PermissionEnum> permissions) {
        this.permissions = new ArrayList();
        this.permissions.addAll(permissions);
        return this;
    }

    public PermissionManager permission(PermissionEnum permission2) {
        this.permissions = new ArrayList();
        this.permissions.add(permission2);
        return this;
    }

    public PermissionManager permission(PermissionEnum ... permissions) {
        this.permissions = new ArrayList();
        Collections.addAll(this.permissions, permissions);
        return this;
    }

    public PermissionManager askAgain(boolean askAgain) {
        this.askAgain = askAgain;
        return this;
    }

    public PermissionManager callback(FullCallback fullCallback) {
        this.simpleCallback = null;
        this.smartCallback = null;
        this.fullCallback = fullCallback;
        return this;
    }

    public PermissionManager callback(SimpleCallback simpleCallback) {
        this.fullCallback = null;
        this.smartCallback = null;
        this.simpleCallback = simpleCallback;
        return this;
    }

    public PermissionManager callback(SmartCallback smartCallback) {
        this.fullCallback = null;
        this.simpleCallback = null;
        this.smartCallback = smartCallback;
        return this;
    }

    public PermissionManager askAgainCallback(AskAgainCallback askAgainCallback) {
        this.askAgainCallback = askAgainCallback;
        return this;
    }

    public PermissionManager key(int key) {
        this.key = key;
        return this;
    }

    public void ask(Activity activity) {
        this.ask(activity, null, null);
    }

    public void ask(androidx.fragment.app.Fragment fragmentX) {
        this.ask(null, fragmentX, null);
    }

    @Deprecated
    public void ask(Fragment fragment) {
        this.ask(null, null, fragment);
    }

    private void ask(Activity activity, androidx.fragment.app.Fragment fragmentX, Fragment fragment) {
        this.initArray();
        if (Build.VERSION.SDK_INT >= 23) {
            String[] permissionToAsk = this.permissionToAsk(activity, fragmentX, fragment);
            if (permissionToAsk.length == 0) {
                this.showResult();
            } else if (activity != null) {
                ActivityCompat.requestPermissions((Activity)activity, (String[])permissionToAsk, (int)this.key);
            } else if (fragment != null) {
                FragmentCompat.requestPermissions((Fragment)fragment, (String[])permissionToAsk, (int)this.key);
            } else if (fragmentX != null) {
                fragmentX.requestPermissions(permissionToAsk, this.key);
            }
        } else {
            this.permissionsGranted.addAll(this.permissions);
            this.showResult();
        }
    }

    @NonNull
    private String[] permissionToAsk(Activity activity, androidx.fragment.app.Fragment fragmentX, Fragment fragment) {
        ArrayList<String> permissionToAsk = new ArrayList<String>();
        for (PermissionEnum permission2 : this.permissions) {
            boolean isGranted = false;
            if (activity != null) {
                isGranted = PermissionUtils.isGranted((Context)activity, permission2);
            } else if (fragment != null) {
                isGranted = PermissionUtils.isGranted((Context)fragment.getActivity(), permission2);
            } else if (fragmentX != null) {
                isGranted = PermissionUtils.isGranted((Context)fragmentX.getActivity(), permission2);
            }
            if (!isGranted) {
                permissionToAsk.add(permission2.toString());
                continue;
            }
            this.permissionsGranted.add(permission2);
        }
        return permissionToAsk.toArray(new String[permissionToAsk.size()]);
    }

    private void initArray() {
        this.permissionsGranted = new ArrayList();
        this.permissionsDenied = new ArrayList();
        this.permissionsDeniedForever = new ArrayList();
        this.permissionToAsk = new ArrayList();
    }

    private void showResult() {
        if (this.simpleCallback != null) {
            this.simpleCallback.result(this.permissionToAsk.size() == 0 || this.permissionToAsk.size() == this.permissionsGranted.size());
        }
        if (this.fullCallback != null) {
            this.fullCallback.result(this.permissionsGranted, this.permissionsDenied, this.permissionsDeniedForever, this.permissions);
        }
        if (this.smartCallback != null) {
            this.smartCallback.result(this.permissionToAsk.size() == 0 || this.permissionToAsk.size() == this.permissionsGranted.size(), !this.permissionsDeniedForever.isEmpty());
        }
        instance = null;
    }
}

