/*
 * Decompiled with CFR 0.152.
 */
package rebus.permissionutils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentCompat;
import android.support.v4.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Collections;
import rebus.permissionutils.AskAgainCallback;
import rebus.permissionutils.FullCallback;
import rebus.permissionutils.PermissionEnum;
import rebus.permissionutils.PermissionUtils;
import rebus.permissionutils.SimpleCallback;
import rebus.permissionutils.SmartCallback;

public class PermissionManager {
    @SuppressLint(value={"StaticFieldLeak"})
    private static PermissionManager instance;
    private Activity activity;
    private Fragment fragment;
    private android.support.v4.app.Fragment v4fragment;
    private Context context;
    private FullCallback fullCallback;
    private SimpleCallback simpleCallback;
    private AskAgainCallback askAgainCallback;
    private SmartCallback smartCallback;
    private boolean askAgain = false;
    private ArrayList<PermissionEnum> permissions;
    private ArrayList<PermissionEnum> permissionsGranted;
    private ArrayList<PermissionEnum> permissionsDenied;
    private ArrayList<PermissionEnum> permissionsDeniedForever;
    private ArrayList<PermissionEnum> permissionToAsk;
    private int key = 100;

    public static PermissionManager with(@NonNull Activity activity) {
        if (instance == null) {
            instance = new PermissionManager();
        }
        instance.init(activity, null, null);
        return instance;
    }

    public static PermissionManager with(@NonNull android.support.v4.app.Fragment v4fragment) {
        if (instance == null) {
            instance = new PermissionManager();
        }
        instance.init(null, null, v4fragment);
        return instance;
    }

    public static PermissionManager with(@NonNull Fragment fragment) {
        if (instance == null) {
            instance = new PermissionManager();
        }
        instance.init(null, fragment, null);
        return instance;
    }

    public static void handleResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (instance == null) {
            return;
        }
        if (requestCode == PermissionManager.instance.key) {
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    PermissionManager.instance.permissionsGranted.add(PermissionEnum.fromManifestPermission(permissions[i]));
                    continue;
                }
                boolean permissionsDeniedForever = false;
                if (PermissionManager.instance.activity != null) {
                    permissionsDeniedForever = ActivityCompat.shouldShowRequestPermissionRationale((Activity)PermissionManager.instance.activity, (String)permissions[i]);
                } else if (PermissionManager.instance.fragment != null) {
                    permissionsDeniedForever = FragmentCompat.shouldShowRequestPermissionRationale((Fragment)PermissionManager.instance.fragment, (String)permissions[i]);
                } else if (PermissionManager.instance.v4fragment != null) {
                    permissionsDeniedForever = PermissionManager.instance.v4fragment.shouldShowRequestPermissionRationale(permissions[i]);
                }
                if (!permissionsDeniedForever) {
                    PermissionManager.instance.permissionsDeniedForever.add(PermissionEnum.fromManifestPermission(permissions[i]));
                }
                PermissionManager.instance.permissionsDenied.add(PermissionEnum.fromManifestPermission(permissions[i]));
                PermissionManager.instance.permissionToAsk.add(PermissionEnum.fromManifestPermission(permissions[i]));
            }
            if (PermissionManager.instance.permissionToAsk.size() != 0 && PermissionManager.instance.askAgain) {
                PermissionManager.instance.askAgain = false;
                if (PermissionManager.instance.askAgainCallback != null && PermissionManager.instance.permissionsDeniedForever.size() != PermissionManager.instance.permissionsDenied.size()) {
                    PermissionManager.instance.askAgainCallback.showRequestPermission(new AskAgainCallback.UserResponse(){

                        @Override
                        public void result(boolean askAgain) {
                            if (askAgain) {
                                instance.ask();
                            } else {
                                instance.showResult();
                            }
                        }
                    });
                } else {
                    instance.ask();
                }
            } else {
                instance.showResult();
            }
        }
    }

    private void init(Activity activity, Fragment fragment, android.support.v4.app.Fragment v4fragment) {
        this.activity = activity;
        this.fragment = fragment;
        this.v4fragment = v4fragment;
        if (activity != null) {
            this.context = activity;
        } else if (fragment != null) {
            this.context = fragment.getActivity();
        } else if (v4fragment != null) {
            this.context = v4fragment.getActivity();
        }
    }

    public PermissionManager permissions(ArrayList<PermissionEnum> permissions) {
        this.permissions = new ArrayList();
        this.permissions.addAll(permissions);
        return this;
    }

    public PermissionManager permission(PermissionEnum permission2) {
        this.permissions = new ArrayList();
        this.permissions.add(permission2);
        return this;
    }

    public PermissionManager permission(PermissionEnum ... permissions) {
        this.permissions = new ArrayList();
        Collections.addAll(this.permissions, permissions);
        return this;
    }

    public PermissionManager askAgain(boolean askAgain) {
        this.askAgain = askAgain;
        return this;
    }

    public PermissionManager callback(FullCallback fullCallback) {
        this.simpleCallback = null;
        this.smartCallback = null;
        this.fullCallback = fullCallback;
        return this;
    }

    public PermissionManager callback(SimpleCallback simpleCallback) {
        this.fullCallback = null;
        this.smartCallback = null;
        this.simpleCallback = simpleCallback;
        return this;
    }

    public PermissionManager callback(SmartCallback smartCallback) {
        this.fullCallback = null;
        this.simpleCallback = null;
        this.smartCallback = smartCallback;
        return this;
    }

    public PermissionManager askAgainCallback(AskAgainCallback askAgainCallback) {
        this.askAgainCallback = askAgainCallback;
        return this;
    }

    public PermissionManager key(int key) {
        this.key = key;
        return this;
    }

    public void ask() {
        this.initArray();
        if (Build.VERSION.SDK_INT >= 23) {
            String[] permissionToAsk = this.permissionToAsk();
            if (permissionToAsk.length == 0) {
                this.showResult();
            } else if (this.activity != null) {
                ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissionToAsk, (int)this.key);
            } else if (this.fragment != null) {
                FragmentCompat.requestPermissions((Fragment)this.fragment, (String[])permissionToAsk, (int)this.key);
            } else if (this.v4fragment != null) {
                this.v4fragment.requestPermissions(permissionToAsk, this.key);
            }
        } else {
            this.permissionsGranted.addAll(this.permissions);
            this.showResult();
        }
    }

    @NonNull
    private String[] permissionToAsk() {
        ArrayList<String> permissionToAsk = new ArrayList<String>();
        for (PermissionEnum permission2 : this.permissions) {
            if (!PermissionUtils.isGranted(this.context, permission2)) {
                permissionToAsk.add(permission2.toString());
                continue;
            }
            this.permissionsGranted.add(permission2);
        }
        return permissionToAsk.toArray(new String[permissionToAsk.size()]);
    }

    private void initArray() {
        this.permissionsGranted = new ArrayList();
        this.permissionsDenied = new ArrayList();
        this.permissionsDeniedForever = new ArrayList();
        this.permissionToAsk = new ArrayList();
    }

    private void showResult() {
        if (this.simpleCallback != null) {
            this.simpleCallback.result(this.permissionToAsk.size() == 0 || this.permissionToAsk.size() == this.permissionsGranted.size());
        }
        if (this.fullCallback != null) {
            this.fullCallback.result(this.permissionsGranted, this.permissionsDenied, this.permissionsDeniedForever, this.permissions);
        }
        if (this.smartCallback != null) {
            this.smartCallback.result(this.permissionToAsk.size() == 0 || this.permissionToAsk.size() == this.permissionsGranted.size(), !this.permissionsDeniedForever.isEmpty());
        }
    }
}

