/*
 * Decompiled with CFR 0.152.
 */
package rebus.permissionutils;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import rebus.permissionutils.PermissionEnum;

public class PermissionUtils {
    public static boolean isGranted(Context context, PermissionEnum permission2) {
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)context, (String)permission2.toString()) == 0;
    }

    public static boolean isGranted(Context context, PermissionEnum ... permission2) {
        for (PermissionEnum permissionEnum : permission2) {
            if (PermissionUtils.isGranted(context, permissionEnum)) continue;
            return false;
        }
        return true;
    }

    public static Intent openApplicationSettings(String packageName) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + packageName)));
        return intent;
    }

    public static void openApplicationSettings(Context context, String packageName) {
        Intent intent = PermissionUtils.openApplicationSettings(packageName);
        context.startActivity(intent);
    }
}

