/*
 * Decompiled with CFR 0.152.
 */
package rebus.permissionutils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import java.util.ArrayList;
import java.util.Collections;
import rebus.permissionutils.AskagainCallback;
import rebus.permissionutils.FullCallback;
import rebus.permissionutils.PermissionEnum;
import rebus.permissionutils.PermissionUtils;
import rebus.permissionutils.SimpleCallback;

public class PermissionManager {
    private static PermissionManager instance;
    private Context context;
    private FullCallback fullCallback;
    private SimpleCallback simpleCallback;
    private AskagainCallback askagainCallback;
    private boolean askagain = false;
    private ArrayList<PermissionEnum> permissions;
    private ArrayList<PermissionEnum> permissionsGranted;
    private ArrayList<PermissionEnum> permissionsDenied;
    private ArrayList<PermissionEnum> permissionsDeniedForever;
    private ArrayList<PermissionEnum> permissionToAsk;

    public static PermissionManager with(Context context) {
        if (instance == null) {
            instance = new PermissionManager();
        }
        instance.init(context);
        return instance;
    }

    public static void handleResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (instance == null) {
            return;
        }
        if (requestCode == 100) {
            for (int i = 0; i < permissions.length; ++i) {
                if (grantResults[i] == 0) {
                    PermissionManager.instance.permissionsGranted.add(PermissionEnum.fromManifestPermission(permissions[i]));
                    continue;
                }
                boolean permissionsDeniedForever = ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)PermissionManager.instance.context), (String)permissions[i]);
                if (!permissionsDeniedForever) {
                    PermissionManager.instance.permissionsDeniedForever.add(PermissionEnum.fromManifestPermission(permissions[i]));
                }
                PermissionManager.instance.permissionsDenied.add(PermissionEnum.fromManifestPermission(permissions[i]));
                PermissionManager.instance.permissionToAsk.add(PermissionEnum.fromManifestPermission(permissions[i]));
            }
            if (PermissionManager.instance.permissionToAsk.size() != 0 && PermissionManager.instance.askagain) {
                PermissionManager.instance.askagain = false;
                if (PermissionManager.instance.askagainCallback != null && PermissionManager.instance.permissionsDeniedForever.size() != PermissionManager.instance.permissionsDenied.size()) {
                    PermissionManager.instance.askagainCallback.showRequestPermission(new AskagainCallback.UserResponse(){

                        @Override
                        public void result(boolean askagain) {
                            if (askagain) {
                                instance.ask();
                            } else {
                                instance.showResult();
                            }
                        }
                    });
                } else {
                    instance.ask();
                }
            } else {
                instance.showResult();
            }
        }
    }

    private void init(Context context) {
        this.context = context;
    }

    public PermissionManager permissions(ArrayList<PermissionEnum> permissions) {
        this.permissions = new ArrayList();
        this.permissions.addAll(permissions);
        return this;
    }

    public PermissionManager permission(PermissionEnum permission2) {
        this.permissions = new ArrayList();
        this.permissions.add(permission2);
        return this;
    }

    public PermissionManager permission(PermissionEnum ... permissions) {
        this.permissions = new ArrayList();
        Collections.addAll(this.permissions, permissions);
        return this;
    }

    public PermissionManager askagain(boolean askagain) {
        this.askagain = askagain;
        return this;
    }

    public PermissionManager callback(FullCallback fullCallback) {
        this.simpleCallback = null;
        this.fullCallback = fullCallback;
        return this;
    }

    public PermissionManager callback(SimpleCallback simpleCallback) {
        this.fullCallback = null;
        this.simpleCallback = simpleCallback;
        return this;
    }

    public PermissionManager askagainCallback(AskagainCallback askagainCallback) {
        this.askagainCallback = askagainCallback;
        return this;
    }

    public void ask() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.initArray();
            String[] permissionToAsk = this.permissionToAsk();
            if (permissionToAsk.length == 0) {
                this.showResult();
            } else {
                ActivityCompat.requestPermissions((Activity)((Activity)this.context), (String[])permissionToAsk, (int)100);
            }
        } else {
            this.initArray();
            this.permissionsGranted.addAll(this.permissions);
            this.showResult();
        }
    }

    @NonNull
    private String[] permissionToAsk() {
        ArrayList<String> permissionToAsk = new ArrayList<String>();
        for (PermissionEnum permission2 : this.permissions) {
            if (!PermissionUtils.isGranted(this.context, permission2)) {
                permissionToAsk.add(permission2.toString());
                continue;
            }
            this.permissionsGranted.add(permission2);
        }
        return permissionToAsk.toArray(new String[permissionToAsk.size()]);
    }

    private void initArray() {
        this.permissionsGranted = new ArrayList();
        this.permissionsDenied = new ArrayList();
        this.permissionsDeniedForever = new ArrayList();
        this.permissionToAsk = new ArrayList();
    }

    private void showResult() {
        if (this.simpleCallback != null) {
            this.simpleCallback.result(this.permissionToAsk.size() == this.permissionsGranted.size());
        }
        if (this.fullCallback != null) {
            this.fullCallback.result(this.permissionsGranted, this.permissionsDenied, this.permissionsDeniedForever, this.permissions);
        }
    }
}

