/*
 *
 * Copyright 2019 RBKmoney
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package money.rbk.data.exception

import com.google.android.gms.common.api.Status

internal sealed class GpayException(message: String? = null, cause: Throwable? = null) :
    Exception(message, cause) {

    internal object GpayPaymentMethodTokenException :
        GpayException("Google pay can't receive paymentMethodToken")

    internal object GpayNotReadyException : GpayException("Google pay is not ready")

    internal class GpayCantPerformPaymentException(status: Status?) :
        GpayException("Google pay cant perform payment " +
            status?.run { "status:$statusCode message:$statusMessage" }.orEmpty())
}
