/*
 * Decompiled with CFR 0.152.
 */
package ray.dev.library.pretty_logger;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ray.dev.library.pretty_logger.PrettyLogger;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u0000 <2\u00020\u0001:\u0002;<B;\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010$\u001a\u00020\nH\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002J\u001b\u0010'\u001a\u00020\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002\u00a2\u0006\u0002\u0010+J'\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\n2\b\u00100\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b1J \u00102\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\nH\u0002J \u00105\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J \u00106\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\u0018\u00107\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\nH\u0002J \u00108\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\u0018\u00109\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\nH\u0002J \u0010:\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010!\u001a\u00060\"j\u0002`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lray/dev/library/pretty_logger/Printer;", "", "showThreadInfo", "", "methodOffset", "", "methodCount", "context", "Landroid/content/Context;", "prefix", "", "logFileSize", "", "(ZIILandroid/content/Context;Ljava/lang/String;J)V", "BOTTOM_BORDER", "BOTTOM_LEFT_CORNER", "", "CHUNK_SIZE", "DOUBLE_DIVIDER", "HORIZONTAL_LINE", "JSON_INDENT", "LOG_PREFIX", "MAX_LINE_LENGTH", "MESSAGE_TITLE", "MIDDLE_BORDER", "MIDDLE_CORNER", "MIN_STACK_OFFSET", "NEW_LINE", "SINGLE_DIVIDER", "SPACE", "THREAD_TITLE", "TOP_BORDER", "TOP_LEFT_CORNER", "contentBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getContent", "getSimpleClassName", "name", "getStackOffset", "trace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)I", "log", "", "verbose", "tag", "message", "log$pretty_logger_release", "log2Chat", "log2File", "decorate", "logChunk", "logContent", "logHeader", "logMessage", "logMethod", "substringMessage", "Builder", "Companion", "pretty_logger_release"})
public final class Printer {
    private final String LOG_PREFIX = "/PrettyLogs";
    private final int CHUNK_SIZE = 4000;
    private final int MIN_STACK_OFFSET = 2;
    private final int JSON_INDENT = 2;
    private final char TOP_LEFT_CORNER = (char)9484;
    private final char BOTTOM_LEFT_CORNER = (char)9492;
    private final char MIDDLE_CORNER = (char)9500;
    private final char HORIZONTAL_LINE = (char)9474;
    private final char SPACE = (char)32;
    private final String DOUBLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private final String SINGLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private final String TOP_BORDER;
    private final String BOTTOM_BORDER;
    private final String MIDDLE_BORDER;
    private final String NEW_LINE = "\n";
    private final String THREAD_TITLE = "Thread: ";
    private final String MESSAGE_TITLE = "Message: ";
    private final int MAX_LINE_LENGTH;
    private final boolean showThreadInfo;
    private final int methodOffset;
    private final int methodCount;
    private final Context context;
    private final String prefix;
    private final long logFileSize;
    private final StringBuilder contentBuilder;
    private static final long DEFAULT_LOG_FILE_SIZE = 0x6400000L;
    public static final Companion Companion = new Companion(null);

    public final synchronized void log$pretty_logger_release(int verbose, @NotNull String tag, @Nullable String message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        String msg = message;
        if (msg == null) {
            msg = "NULL";
        }
        this.logHeader(verbose, tag);
        this.logMethod(verbose, tag);
        this.logMessage(verbose, tag, msg);
    }

    private final void logHeader(int verbose, String tag) {
        if (this.showThreadInfo) {
            this.contentBuilder.append(this.TOP_BORDER).append(this.NEW_LINE);
            this.logContent(verbose, tag, this.getContent());
            StringBuilder stringBuilder = this.contentBuilder.append(this.HORIZONTAL_LINE).append(this.SPACE).append(this.THREAD_TITLE);
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"currentThread()");
            stringBuilder.append(thread.getName()).append(this.NEW_LINE);
            this.logContent(verbose, tag, this.getContent());
        } else {
            this.contentBuilder.append(this.TOP_BORDER).append(this.NEW_LINE);
            this.logContent(verbose, tag, this.getContent());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logMethod(int verbose, String tag) {
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        StackTraceElement[] trace = thread.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)trace, (String)"trace");
        int stackOffset = this.getStackOffset(trace) + this.methodOffset;
        int methodCount = this.methodCount;
        if (methodCount + stackOffset > trace.length) {
            methodCount = trace.length - stackOffset - 1;
        }
        if (methodCount > 0 && this.showThreadInfo) {
            this.contentBuilder.append(this.MIDDLE_BORDER).append(this.NEW_LINE);
            this.logContent(verbose, tag, this.getContent());
        }
        int space = 1;
        int n = methodCount;
        int n2 = 1;
        while (n >= n2) {
            void i;
            void stackIndex = i + stackOffset;
            if (stackIndex < trace.length) {
                this.contentBuilder.append(this.HORIZONTAL_LINE);
                int n3 = 0;
                int n4 = space;
                while (n3 < n4) {
                    void s;
                    this.contentBuilder.append(this.SPACE);
                    ++s;
                }
                StackTraceElement stackTraceElement = trace[stackIndex];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"trace[stackIndex]");
                String string = stackTraceElement.getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trace[stackIndex].className");
                StringBuilder stringBuilder = this.contentBuilder.append(this.getSimpleClassName(string)).append('.');
                StackTraceElement stackTraceElement2 = trace[stackIndex];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement2, (String)"trace[stackIndex]");
                StringBuilder stringBuilder2 = stringBuilder.append(stackTraceElement2.getMethodName()).append(this.SPACE).append('(');
                StackTraceElement stackTraceElement3 = trace[stackIndex];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement3, (String)"trace[stackIndex]");
                StringBuilder stringBuilder3 = stringBuilder2.append(stackTraceElement3.getFileName()).append(':');
                StackTraceElement stackTraceElement4 = trace[stackIndex];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement4, (String)"trace[stackIndex]");
                stringBuilder3.append(stackTraceElement4.getLineNumber()).append(')').append(this.NEW_LINE);
                this.logContent(verbose, tag, this.getContent());
                space += 2;
            }
            --i;
        }
        if (methodCount > 0) {
            this.contentBuilder.append(this.MIDDLE_BORDER).append(this.NEW_LINE);
            this.logContent(verbose, tag, this.getContent());
        }
    }

    private final void logMessage(int verbose, String tag, String message) {
        String[] messages;
        List list;
        Collection $receiver$iv;
        CharSequence charSequence;
        Object transformer;
        Object result;
        String msg = message;
        this.contentBuilder.append(this.HORIZONTAL_LINE).append(this.SPACE).append(this.MESSAGE_TITLE).append(this.NEW_LINE);
        this.logContent(verbose, tag, this.getContent());
        if (StringsKt.startsWith$default((String)msg, (String)"{", (boolean)false, (int)2, null)) {
            try {
                JSONObject jsonObject = new JSONObject(msg);
                String string = jsonObject.toString(this.JSON_INDENT);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonObject.toString(JSON_INDENT)");
                msg = string;
            }
            catch (JSONException jsonObject) {}
        } else if (StringsKt.startsWith$default((String)msg, (String)"[", (boolean)false, (int)2, null)) {
            try {
                JSONArray jsonArray = new JSONArray(msg);
                String string = jsonArray.toString(this.JSON_INDENT);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonArray.toString(JSON_INDENT)");
                msg = string;
            }
            catch (JSONException jsonArray) {
                // empty catch block
            }
        }
        try {
            StreamSource source = new StreamSource(new StringReader(msg));
            result = new StreamResult(new StringWriter());
            transformer = TransformerFactory.newInstance().newTransformer();
            ((Transformer)transformer).setOutputProperty("indent", "yes");
            ((Transformer)transformer).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ((Transformer)transformer).transform(source, (Result)result);
            CharSequence charSequence2 = ((StreamResult)result).getWriter().toString();
            charSequence = ">";
            charSequence = new Regex((String)charSequence);
            String string = ">\n";
            msg = charSequence.replaceFirst(charSequence2, string);
        }
        catch (TransformerException source) {
            // empty catch block
        }
        result = msg;
        transformer = this.NEW_LINE;
        transformer = new Regex((String)transformer);
        int n = 0;
        result = transformer.split((CharSequence)result, n);
        if (!$receiver$iv.isEmpty()) {
            ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                charSequence = it;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $receiver$iv = list;
        Collection collection = $receiver$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String msg2 : messages = stringArray) {
            this.substringMessage(verbose, tag, msg2);
        }
        this.contentBuilder.append(this.BOTTOM_BORDER).append(this.NEW_LINE);
        this.logContent(verbose, tag, this.getContent());
    }

    private final void substringMessage(int verbose, String tag, String message) {
        int messageLength = message.length();
        if (messageLength > this.MAX_LINE_LENGTH) {
            int startIndex = 0;
            int endIndex = this.MAX_LINE_LENGTH;
            while (endIndex <= messageLength) {
                String string;
                String string2 = message;
                String string3 = tag;
                int n = verbose;
                Printer printer = this;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(startIndex, endIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                printer.logChunk(n, string3, string);
                if (endIndex != messageLength) {
                    startIndex = endIndex;
                    endIndex = endIndex + this.MAX_LINE_LENGTH < messageLength ? endIndex + this.MAX_LINE_LENGTH : messageLength;
                    continue;
                }
                break;
            }
        } else {
            this.logChunk(verbose, tag, message);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logChunk(int verbose, String tag, String message) {
        this.contentBuilder.append(this.HORIZONTAL_LINE);
        int subSpace = this.MESSAGE_TITLE.length();
        int n = 0;
        int n2 = subSpace;
        if (n <= n2) {
            while (true) {
                void s;
                this.contentBuilder.append(this.SPACE);
                if (s == n2) break;
                ++s;
            }
        }
        this.contentBuilder.append(message).append(this.NEW_LINE);
        this.logContent(verbose, tag, this.getContent());
    }

    private final int getStackOffset(StackTraceElement[] trace) {
        for (int i = this.MIN_STACK_OFFSET; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (!(Intrinsics.areEqual((Object)name, (Object)Printer.class.getName()) ^ true) || !(Intrinsics.areEqual((Object)name, (Object)PrettyLogger.class.getName()) ^ true)) continue;
            return --i;
        }
        return -1;
    }

    private final String getSimpleClassName(String name) {
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)name, (String)"", (int)0, (boolean)false, (int)6, null);
        String string = name;
        int n = lastIndex + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return string3;
    }

    private final String getContent() {
        String string = this.contentBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contentBuilder.toString()");
        String content = string;
        this.contentBuilder.setLength(0);
        return content;
    }

    private final void logContent(int verbose, String tag, String message) {
        this.log2Chat(verbose, tag, message);
        this.log2File(message);
    }

    private final void log2Chat(int verbose, String tag, String message) {
        int n = verbose;
        if (n == PrettyLogger.Companion.getVERBOSE()) {
            Log.v((String)tag, (String)message);
        } else if (n == PrettyLogger.Companion.getDEBUG()) {
            Log.d((String)tag, (String)message);
        } else if (n == PrettyLogger.Companion.getINFO()) {
            Log.i((String)tag, (String)message);
        } else if (n == PrettyLogger.Companion.getWARN()) {
            Log.w((String)tag, (String)message);
        } else if (n == PrettyLogger.Companion.getERROR()) {
            Log.e((String)tag, (String)message);
        } else if (n == PrettyLogger.Companion.getWTF()) {
            Log.w((String)tag, (String)message);
        }
    }

    private final void log2File(String decorate) {
        if (this.context == null) {
            return;
        }
        try {
            File direct = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).toString() + this.LOG_PREFIX);
            if (!direct.exists()) {
                direct.mkdir();
            }
            String fileNameTimeStamp = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault()).format(new Date());
            String logTimeStamp = new SimpleDateFormat("E MMM dd yyyy 'at' HH:mm:ss:sss", Locale.getDefault()).format(new Date());
            String fileName = this.prefix + fileNameTimeStamp + ".txt";
            File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).toString() + this.LOG_PREFIX + File.separator + fileName);
            file.createNewFile();
            if (file.exists()) {
                Object object;
                OutputStream fileOutputStream = new FileOutputStream(file, file.length() < this.logFileSize);
                String string = logTimeStamp + ": " + decorate;
                Object object2 = "UTF-8";
                OutputStream outputStream = fileOutputStream;
                Charset charset = Charset.forName((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object2 = object = charset;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes((Charset)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray;
                outputStream.write((byte[])object);
                fileOutputStream.close();
                MediaScannerConnection.scanFile((Context)this.context, (String[])new String[]{file.toString()}, null, null);
            }
        }
        catch (Exception e) {
            Log.e((String)"ContentValues", (String)("Error while logging into file : " + e));
        }
    }

    public Printer(boolean showThreadInfo, int methodOffset, int methodCount, @Nullable Context context, @Nullable String prefix, long logFileSize) {
        char c = this.TOP_LEFT_CORNER;
        String string = this.DOUBLE_DIVIDER;
        StringBuilder stringBuilder = new StringBuilder();
        Printer printer = this;
        String string2 = String.valueOf(c) + string;
        printer.TOP_BORDER = stringBuilder.append(string2).append(this.DOUBLE_DIVIDER).toString();
        c = this.BOTTOM_LEFT_CORNER;
        string = this.DOUBLE_DIVIDER;
        stringBuilder = new StringBuilder();
        printer = this;
        string2 = String.valueOf(c) + string;
        printer.BOTTOM_BORDER = stringBuilder.append(string2).append(this.DOUBLE_DIVIDER).toString();
        c = this.MIDDLE_CORNER;
        string = this.SINGLE_DIVIDER;
        stringBuilder = new StringBuilder();
        printer = this;
        string2 = String.valueOf(c) + string;
        printer.MIDDLE_BORDER = stringBuilder.append(string2).append(this.SINGLE_DIVIDER).toString();
        this.NEW_LINE = "\n";
        this.THREAD_TITLE = "Thread: ";
        this.MESSAGE_TITLE = "Message: ";
        this.MAX_LINE_LENGTH = this.MIDDLE_BORDER.length() - 11;
        this.contentBuilder = new StringBuilder();
        this.showThreadInfo = showThreadInfo;
        this.methodOffset = methodOffset;
        this.methodCount = methodCount;
        WeakReference<Context> weakReference = new WeakReference<Context>(context);
        this.context = (Context)weakReference.get();
        this.prefix = prefix;
        this.logFileSize = logFileSize;
    }

    static {
        DEFAULT_LOG_FILE_SIZE = 0x6400000L;
    }

    public static final /* synthetic */ long access$getDEFAULT_LOG_FILE_SIZE$cp() {
        return DEFAULT_LOG_FILE_SIZE;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lray/dev/library/pretty_logger/Printer$Builder;", "", "()V", "context", "Landroid/content/Context;", "logFileSize", "", "methodCount", "", "methodOffset", "prefix", "", "showThreadInfo", "", "build", "Lray/dev/library/pretty_logger/Printer;", "log2File", "setMethodCount", "setMethodOffset", "pretty_logger_release"})
    public static final class Builder {
        private boolean showThreadInfo = true;
        private int methodOffset = 0;
        private int methodCount = 2;
        private Context context = null;
        private String prefix = "";
        private long logFileSize = Printer.access$getDEFAULT_LOG_FILE_SIZE$cp();

        @NotNull
        public final Builder showThreadInfo(boolean showThreadInfo) {
            this.showThreadInfo = showThreadInfo;
            return this;
        }

        @NotNull
        public final Builder setMethodOffset(int methodOffset) {
            this.methodOffset = methodOffset;
            return this;
        }

        @NotNull
        public final Builder setMethodCount(int methodCount) {
            this.methodCount = methodCount;
            return this;
        }

        @NotNull
        public final Builder log2File(@NotNull Context context, @NotNull String prefix) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            this.context = context;
            this.prefix = prefix;
            return this;
        }

        @NotNull
        public final Builder log2File(@NotNull Context context, @NotNull String prefix, long logFileSize) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
            this.context = context;
            this.prefix = prefix;
            this.logFileSize = logFileSize;
            return this;
        }

        @NotNull
        public final Printer build() {
            return new Printer(this.showThreadInfo, this.methodOffset, this.methodCount, this.context, this.prefix, this.logFileSize);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lray/dev/library/pretty_logger/Printer$Companion;", "", "()V", "DEFAULT_LOG_FILE_SIZE", "", "pretty_logger_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

