/*
 * Decompiled with CFR 0.152.
 */
package ray.dev.library.pretty_logger;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ray.dev.library.pretty_logger.Printer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lray/dev/library/pretty_logger/PrettyLogger;", "", "()V", "Companion", "pretty_logger_release"})
public final class PrettyLogger {
    private static final int NON_DEBUG_PRIORITY = 0;
    private static final int HIGH_PRIORITY = 1;
    private static final int NORMAL_PRIORITY = 2;
    private static final int LOW_PRIORITY = 3;
    private static final int VERBOSE = 2;
    private static final int DEBUG = 3;
    private static final int INFO = 4;
    private static final int WARN = 5;
    private static final int ERROR = 6;
    private static final int ASSERT = 7;
    private static final int WTF = 8;
    private static final ConcurrentHashMap<Integer, Printer> printers;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        HIGH_PRIORITY = 1;
        NORMAL_PRIORITY = 2;
        LOW_PRIORITY = 3;
        VERBOSE = 2;
        DEBUG = 3;
        INFO = 4;
        WARN = 5;
        ERROR = 6;
        ASSERT = 7;
        WTF = 8;
        printers = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final void add(int priority, @NotNull Printer printer) {
        Companion.add(priority, printer);
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @NotNull String message) {
        Companion.v(tag, message);
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @NotNull String message, int priority) {
        Companion.v(tag, message, priority);
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @NotNull String message) {
        Companion.d(tag, message);
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @NotNull String message, int priority) {
        Companion.d(tag, message, priority);
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @NotNull String message) {
        Companion.i(tag, message);
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @NotNull String message, int priority) {
        Companion.i(tag, message, priority);
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @NotNull String message) {
        Companion.w(tag, message);
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @NotNull String message, int priority) {
        Companion.w(tag, message, priority);
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @NotNull String message) {
        Companion.e(tag, message);
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @NotNull String message, int priority) {
        Companion.e(tag, message, priority);
    }

    @JvmStatic
    public static final void wtf(@NotNull String tag, @NotNull String message) {
        Companion.wtf(tag, message);
    }

    @JvmStatic
    public static final void wtf(@NotNull String tag, @NotNull String message, int priority) {
        Companion.wtf(tag, message, priority);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001dH\u0007J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0007J \u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0018\u0010&\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0007J \u0010&\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0007J \u0010'\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0004H\u0007J(\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0007J \u0010*\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0007J \u0010+\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0004H\u0007J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0007J \u0010,\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020\u0004H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lray/dev/library/pretty_logger/PrettyLogger$Companion;", "", "()V", "ASSERT", "", "getASSERT", "()I", "DEBUG", "getDEBUG", "ERROR", "getERROR", "HIGH_PRIORITY", "getHIGH_PRIORITY", "INFO", "getINFO", "LOW_PRIORITY", "getLOW_PRIORITY", "NON_DEBUG_PRIORITY", "getNON_DEBUG_PRIORITY", "NORMAL_PRIORITY", "getNORMAL_PRIORITY", "VERBOSE", "getVERBOSE", "WARN", "getWARN", "WTF", "getWTF", "printers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lray/dev/library/pretty_logger/Printer;", "add", "", "priority", "printer", "d", "tag", "", "message", "e", "i", "log", "verbose", "v", "w", "wtf", "pretty_logger_release"})
    public static final class Companion {
        public final int getNON_DEBUG_PRIORITY() {
            return NON_DEBUG_PRIORITY;
        }

        public final int getHIGH_PRIORITY() {
            return HIGH_PRIORITY;
        }

        public final int getNORMAL_PRIORITY() {
            return NORMAL_PRIORITY;
        }

        public final int getLOW_PRIORITY() {
            return LOW_PRIORITY;
        }

        public final int getVERBOSE() {
            return VERBOSE;
        }

        public final int getDEBUG() {
            return DEBUG;
        }

        public final int getINFO() {
            return INFO;
        }

        public final int getWARN() {
            return WARN;
        }

        public final int getERROR() {
            return ERROR;
        }

        public final int getASSERT() {
            return ASSERT;
        }

        public final int getWTF() {
            return WTF;
        }

        @JvmStatic
        public final void add(int priority, @NotNull Printer printer) {
            Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
            printers.put(priority, printer);
        }

        @JvmStatic
        public final void v(@NotNull String tag, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.v(tag, message, this.getHIGH_PRIORITY());
        }

        @JvmStatic
        public final void v(@NotNull String tag, @NotNull String message, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.log(priority, this.getVERBOSE(), tag, message);
        }

        @JvmStatic
        public final void d(@NotNull String tag, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.d(tag, message, this.getHIGH_PRIORITY());
        }

        @JvmStatic
        public final void d(@NotNull String tag, @NotNull String message, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.log(priority, this.getDEBUG(), tag, message);
        }

        @JvmStatic
        public final void i(@NotNull String tag, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.i(tag, message, this.getHIGH_PRIORITY());
        }

        @JvmStatic
        public final void i(@NotNull String tag, @NotNull String message, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.log(priority, this.getINFO(), tag, message);
        }

        @JvmStatic
        public final void w(@NotNull String tag, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.w(tag, message, this.getHIGH_PRIORITY());
        }

        @JvmStatic
        public final void w(@NotNull String tag, @NotNull String message, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.log(priority, this.getWARN(), tag, message);
        }

        @JvmStatic
        public final void e(@NotNull String tag, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.e(tag, message, this.getHIGH_PRIORITY());
        }

        @JvmStatic
        public final void e(@NotNull String tag, @NotNull String message, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.log(priority, this.getERROR(), tag, message);
        }

        @JvmStatic
        public final void wtf(@NotNull String tag, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.wtf(tag, message, this.getHIGH_PRIORITY());
        }

        @JvmStatic
        public final void wtf(@NotNull String tag, @NotNull String message, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.log(priority, this.getWTF(), tag, message);
        }

        private final void log(int priority, int verbose, String tag, String message) {
            Iterator iterator = printers.keySet().iterator();
            while (iterator.hasNext()) {
                Integer key;
                Integer n = key = (Integer)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"key");
                if (Intrinsics.compare((int)priority, (int)n) > 0) continue;
                Object v = printers.get(key);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ((Printer)v).log$pretty_logger_release(verbose, tag, message);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

