/*
 * Decompiled with CFR 0.152.
 */
package pub.dsb.framework.boot.cloud.beans.gateway;

import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import pub.dsb.framework.boot.common.functions.ApplyValue;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DecryptGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String KEY_REWRITE_FUNCTION = "rewriteFunction";
    private final ApplyValue<Mono<String>, String> defaultRewriteFunction;
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();

    public DecryptGatewayFilterFactory(ApplyValue<Mono<String>, String> defaultRewriteFunction) {
        super(Config.class);
        this.defaultRewriteFunction = defaultRewriteFunction;
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            boolean isJsonPost;
            HttpHeaders headers = exchange.getRequest().getHeaders();
            boolean bl = isJsonPost = MediaType.APPLICATION_JSON.isCompatibleWith(headers.getContentType()) && HttpMethod.POST.equals((Object)exchange.getRequest().getMethod());
            if (!isJsonPost) {
                return chain.filter(exchange);
            }
            return this.processOnEncryptBody(exchange, chain, config);
        };
    }

    private Mono<Void> processOnEncryptBody(ServerWebExchange exchange, GatewayFilterChain chain, Config config) {
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
        Mono modifiedBody = serverRequest.bodyToMono(String.class).flatMap(o -> (Mono)this.getOrDefault((ApplyValue<Mono<String>, String>)config.rewriteFunction).apply(o));
        BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, String.class);
        HttpHeaders headers = new HttpHeaders();
        headers.addAll((MultiValueMap)exchange.getRequest().getHeaders());
        headers.remove((Object)"Content-Length");
        CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
        return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
            ServerHttpRequestDecorator decorator = this.decorate(exchange, headers, outputMessage);
            return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
        }));
    }

    private ApplyValue<Mono<String>, String> getOrDefault(ApplyValue<Mono<String>, String> rewriteFunction) {
        return Optional.ofNullable(rewriteFunction).orElse(this.defaultRewriteFunction);
    }

    ServerHttpRequestDecorator decorate(ServerWebExchange exchange, final HttpHeaders headers, final CachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(exchange.getRequest()){

            public HttpHeaders getHeaders() {
                long contentLength = headers.getContentLength();
                HttpHeaders httpHeaders = new HttpHeaders();
                httpHeaders.addAll((MultiValueMap)super.getHeaders());
                if (contentLength > 0L) {
                    httpHeaders.setContentLength(contentLength);
                } else {
                    httpHeaders.set("Transfer-Encoding", "chunked");
                }
                return httpHeaders;
            }

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }
        };
    }

    public static class Config {
        private ApplyValue<Mono<String>, String> rewriteFunction;

        public ApplyValue<Mono<String>, String> getRewriteFunction() {
            return this.rewriteFunction;
        }

        public void setRewriteFunction(ApplyValue<Mono<String>, String> rewriteFunction) {
            this.rewriteFunction = rewriteFunction;
        }
    }
}

