/*
 * @ProjectName: 编程学习
 * @Copyright:   2020 HangZhou Yiyuery Dev, Ltd. All Right Reserved.
 * @address:     微信搜索公众号「架构探险之道」获取更多资源。
 * @date:        2020/8/16 10:18 上午
 * @description: 本内容仅限于编程技术学习使用，转发请注明出处.
 */
package pub.dsb.framework.boot.security.configuration;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import pub.dsb.framework.boot.security.annotation.EnableSecurity;
import pub.dsb.framework.boot.security.constants.DecryptModeEnum;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

/**
 * <p>
 * 信息安全动态装配
 * </p>
 *
 * @author Yiyuery
 * @date 2020/8/16 10:18 上午
 */
@Configuration
@Import({SingleDecryptConfiguration.class,GatewayDecryptConfiguration.class})
@ConditionalOnProperty(prefix = "dsb.security", value = "enabled", matchIfMissing = true)
public class SecurityAutoConfiguration {

}
