package pub.dsb.framework.boot.cloud.configuration.gateway;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pub.dsb.framework.boot.cloud.beans.gateway.DecryptGatewayFilterFactory;
import pub.dsb.framework.boot.common.functions.ApplyValue;
import pub.dsb.framework.boot.security.annotation.EnableSecurity;
import pub.dsb.framework.boot.security.beans.IDecryptStrategy;
import pub.dsb.framework.boot.security.beans.strategy.DesDecryptStrategy;
import pub.dsb.framework.boot.security.beans.strategy.RsaDecryptStrategy;
import reactor.core.publisher.Mono;

/**
 * <p>
 *
 * </p>
 *
 * @author Yiyuery
 * @date 2020/8/28
 * @since 0.0.1
 */
@EnableSecurity
@Configuration
public class GatewayDecryptConfiguration {

    /**
     * <p>
     * 网关敏感信息解密
     * </p>
     */
    @Bean
    public DecryptGatewayFilterFactory decryptGatewayFilterFactory(ApplyValue<Mono<String>, String> desDecryptRewriteFunction) {
        return new DecryptGatewayFilterFactory(desDecryptRewriteFunction);
    }

    /**
     * <p>
     * DES 解密
     * </p>
     */
    @Bean
    public ApplyValue<Mono<String>, String> desDecryptRewriteFunction(DesDecryptStrategy desDecryptStrategy) {
        return doDecrypt(desDecryptStrategy);
    }

    /**
     * <p>
     * RSA 加解密
     * </p>
     */
    @Bean
    public ApplyValue<Mono<String>, String> rsaDecryptRewriteFunction(RsaDecryptStrategy rsaDecryptStrategy) {
        return doDecrypt(rsaDecryptStrategy);
    }

    /**
     * <p>
     * 敏感信息处理
     * </p>
     */
    private ApplyValue<Mono<String>, String> doDecrypt(IDecryptStrategy decryptStrategy) {
        return value -> {
            try {
                if (StringUtils.isNotEmpty(value) && !value.startsWith("{")) {
                    return Mono.just(decryptStrategy.decrypt(value));
                } else {
                    return Mono.just(value);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            return Mono.empty();
        };
    }
}
