/*
 * Decompiled with CFR 0.152.
 */
package pub.dsb.framework.boot.cloud.configuration.gateway;

import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gateway.filter.ratelimit.KeyResolver;
import org.springframework.cloud.gateway.filter.ratelimit.RedisRateLimiter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.validation.Validator;
import pub.dsb.framework.boot.cloud.properties.GatewayLimitProperties;
import pub.dsb.framework.boot.redis.properties.RedisClusterProperties;
import reactor.core.publisher.Mono;

@Configuration
@ConditionalOnClass(value={KeyResolver.class})
@Import(value={RedisClusterProperties.class, GatewayLimitProperties.class})
public class GatewayLimiterConfiguration {
    @Bean
    @ConditionalOnProperty(name={"dsb.cloud.gateway.limit.type"}, havingValue="ipKeyResolver", matchIfMissing=true)
    public KeyResolver ipKeyResolver() {
        return serverWebExchange -> Mono.just((Object)serverWebExchange.getRequest().getRemoteAddress().getHostString());
    }

    @Bean
    @ConditionalOnProperty(name={"dsb.cloud.gateway.limit.type"}, havingValue="pathKeyResolver")
    public KeyResolver pathKeyResolver() {
        return serverWebExchange -> Mono.just((Object)serverWebExchange.getRequest().getPath().value());
    }

    @Bean
    @ConditionalOnMissingBean(name={"reactiveRedisTemplate"})
    public ReactiveRedisTemplate<Object, Object> reactiveRedisTemplate(LettuceConnectionFactory reactiveRedisConnectionFactory) {
        JdkSerializationRedisSerializer jdkSerializer = new JdkSerializationRedisSerializer(GatewayLimiterConfiguration.class.getClassLoader());
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key((RedisSerializer)jdkSerializer).value((RedisSerializer)jdkSerializer).hashKey((RedisSerializer)jdkSerializer).hashValue((RedisSerializer)jdkSerializer).build();
        return new ReactiveRedisTemplate((ReactiveRedisConnectionFactory)reactiveRedisConnectionFactory, serializationContext);
    }

    @Bean
    public RedisRateLimiter redisRateLimiter(ReactiveRedisTemplate<String, String> redisTemplate, @Qualifier(value="redisRequestRateLimiterScript") RedisScript<List<Long>> redisScript, Validator validator) {
        return new RedisRateLimiter(redisTemplate, redisScript, validator);
    }

    @Bean
    public LettuceConnectionFactory reactiveRedisConnectionFactory(RedisClusterProperties redisClusterProperties) {
        return null;
    }
}

