/*
 * Decompiled with CFR 0.152.
 */
package pub.dsb.framework.boot.cloud.configuration.gateway;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pub.dsb.framework.boot.cloud.beans.gateway.DecryptGatewayFilterFactory;
import pub.dsb.framework.boot.common.functions.ApplyValue;
import pub.dsb.framework.boot.security.annotation.EnableSecurity;
import pub.dsb.framework.boot.security.beans.IDecryptStrategy;
import pub.dsb.framework.boot.security.beans.strategy.DesDecryptStrategy;
import pub.dsb.framework.boot.security.beans.strategy.RsaDecryptStrategy;
import reactor.core.publisher.Mono;

@EnableSecurity
@Configuration
public class GatewayDecryptConfiguration {
    @Bean
    public DecryptGatewayFilterFactory decryptGatewayFilterFactory(ApplyValue<Mono<String>, String> desDecryptRewriteFunction) {
        return new DecryptGatewayFilterFactory(desDecryptRewriteFunction);
    }

    @Bean
    public ApplyValue<Mono<String>, String> desDecryptRewriteFunction(DesDecryptStrategy desDecryptStrategy) {
        return this.doDecrypt((IDecryptStrategy)desDecryptStrategy);
    }

    @Bean
    public ApplyValue<Mono<String>, String> rsaDecryptRewriteFunction(RsaDecryptStrategy rsaDecryptStrategy) {
        return this.doDecrypt((IDecryptStrategy)rsaDecryptStrategy);
    }

    private ApplyValue<Mono<String>, String> doDecrypt(IDecryptStrategy decryptStrategy) {
        return value -> {
            try {
                if (StringUtils.isNotEmpty((CharSequence)value) && !value.startsWith("{")) {
                    return Mono.just((Object)decryptStrategy.decrypt(value));
                }
                return Mono.just((Object)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return Mono.empty();
            }
        };
    }
}

