/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityRecord;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import android.widget.ScrollView;
import androidx.annotation.RestrictTo;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.ScrollingView;
import androidx.core.view.VelocityTrackerCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.core.view.accessibility.AccessibilityRecordCompat;
import androidx.core.widget.EdgeEffectCompat;
import java.util.ArrayList;

public class HVScrollView
extends FrameLayout
implements NestedScrollingParent,
NestedScrollingChild,
ScrollingView {
    static final int ANIMATED_SCROLL_GAP = 250;
    static final float MAX_SCROLL_FACTOR = 0.5f;
    private static final String TAG = "NestedScrollView";
    private long mLastScroll;
    private final Rect mTempRect = new Rect();
    private OverScroller mScroller;
    private EdgeEffectCompat mEdgeGlowTop;
    private EdgeEffectCompat mEdgeGlowBottom;
    private EdgeEffectCompat mEdgeGlowLeft;
    private EdgeEffectCompat mEdgeGlowRight;
    private int scrollModeFlag = 0;
    public static final int DISABLE_VERTICAL_SCROLL = 1;
    public static final int DISABLE_HORIZONTAL_SCROLL = 2;
    private int mInitialTouchX;
    private int mInitialTouchY;
    private int mLastMotionX;
    private int mLastMotionY;
    private boolean mIsLayoutDirty = true;
    private boolean mIsLaidOut = false;
    private View mChildToScrollTo = null;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mScrollState = 0;
    private VelocityTracker mVelocityTracker;
    private boolean mSmoothScrollingEnabled = true;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mActivePointerId = -1;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private int mNestedXOffset;
    private int mNestedYOffset;
    private int mLastScrollerX;
    private int mLastScrollerY;
    private static final int INVALID_POINTER = -1;
    private SavedState mSavedState;
    private static final AccessibilityDelegate ACCESSIBILITY_DELEGATE = new AccessibilityDelegate();
    private static final int[] SCROLLVIEW_STYLEABLE = new int[]{16843130};
    private final NestedScrollingParentHelper mParentHelper;
    private final NestedScrollingChildHelper mChildHelper;
    private float mVerticalScrollFactor;
    private OnScrollChangeListener mOnScrollChangeListener;
    private boolean mInTouch = false;

    public HVScrollView(Context context) {
        this(context, null);
    }

    public HVScrollView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HVScrollView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initScrollView();
        TypedArray a = context.obtainStyledAttributes(attrs, SCROLLVIEW_STYLEABLE, defStyleAttr, 0);
        a.recycle();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)ACCESSIBILITY_DELEGATE);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0 || (nestedScrollAxes & 1) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(nestedScrollAxes);
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int oldScrollX = this.getScrollX();
        int oldScrollY = this.getScrollY();
        this.scrollBy(dxUnconsumed, dyUnconsumed);
        int myConsumedX = this.getScrollX() - oldScrollX;
        int myUnconsumedX = dxUnconsumed - myConsumedX;
        int myConsumedY = this.getScrollY() - oldScrollY;
        int myUnconsumedY = dyUnconsumed - myConsumedY;
        this.dispatchNestedScroll(myConsumedX, myConsumedY, myUnconsumedX, myUnconsumedY, null);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.dispatchNestedPreScroll(dx, dy, consumed, null);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.flingWithNestedDispatch((int)velocityX, (int)velocityY);
            return true;
        }
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public boolean shouldDelayChildPressedState() {
        return true;
    }

    protected float getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        int scrollY = this.getScrollY();
        if (scrollY < length) {
            return (float)scrollY / (float)length;
        }
        return 1.0f;
    }

    protected float getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getVerticalFadingEdgeLength();
        int bottomEdge = this.getHeight() - this.getPaddingBottom();
        int span = this.getChildAt(0).getBottom() - this.getScrollY() - bottomEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    protected float getLeftFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getHorizontalFadingEdgeLength();
        int scrollX = this.getScrollX();
        if (scrollX < length) {
            return (float)scrollX / (float)length;
        }
        return 1.0f;
    }

    protected float getRightFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getHorizontalFadingEdgeLength();
        int rightEdge = this.getWidth() - this.getPaddingRight();
        int span = this.getChildAt(0).getRight() - this.getScrollY() - rightEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    public int getMaxScrollAmountY() {
        return (int)(0.5f * (float)this.getHeight());
    }

    public int getMaxScrollAmountX() {
        return (int)(0.5f * (float)this.getWidth());
    }

    private void initScrollView() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child);
    }

    public void addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    public void setOnScrollChangeListener(OnScrollChangeListener l) {
        this.mOnScrollChangeListener = l;
    }

    private boolean canScroll() {
        return this.canScrollHorizontally() || this.canScrollVertically();
    }

    private boolean canScrollVertically() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childHeight = child.getHeight();
            return this.getHeight() < childHeight + this.getPaddingTop() + this.getPaddingBottom();
        }
        return false;
    }

    private boolean canScrollHorizontally() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childWidth = child.getWidth();
            return this.getWidth() < childWidth + this.getPaddingLeft() + this.getPaddingRight();
        }
        return false;
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    public void setSmoothScrollingEnabled(boolean smoothScrollingEnabled) {
        this.mSmoothScrollingEnabled = smoothScrollingEnabled;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mOnScrollChangeListener != null) {
            this.mOnScrollChangeListener.onScrollChange(this, l, t, oldl, oldt);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0 && widthMode == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            int childHeightMeasureSpec;
            int childWidthMeasureSpec;
            View child = this.getChildAt(0);
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            width -= this.getPaddingLeft();
            width -= this.getPaddingRight();
            height -= this.getPaddingTop();
            height -= this.getPaddingBottom();
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            if (lp.width != -1 && lp.height != -1) {
                return;
            }
            if (child.getMeasuredWidth() < width && lp.width == -1) {
                childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
            } else {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                childWidthMeasureSpec = HVScrollView.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight()), (int)lp.width);
            }
            if (child.getMeasuredHeight() < height && lp.height == -1) {
                childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            } else {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                childHeightMeasureSpec = HVScrollView.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)lp.height);
            }
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            if (this.isFocused() && event.getKeyCode() != 4) {
                View nextFocused;
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                return (nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, 130)) != null && nextFocused != this && nextFocused.requestFocus(130);
            }
            return false;
        }
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 19: {
                    if (!this.canScrollVertically()) break;
                    if (!event.isAltPressed()) {
                        handled = this.arrowScrollVertically(33);
                        break;
                    }
                    handled = this.fullScrollVertically(33);
                    break;
                }
                case 20: {
                    if (!this.canScrollVertically()) break;
                    if (!event.isAltPressed()) {
                        handled = this.arrowScrollVertically(130);
                        break;
                    }
                    handled = this.fullScrollVertically(130);
                    break;
                }
                case 21: {
                    if (!this.canScrollHorizontally()) break;
                    if (!event.isAltPressed()) {
                        handled = this.arrowScrollHorizontally(17);
                        break;
                    }
                    handled = this.fullScrollHorizontally(17);
                    break;
                }
                case 22: {
                    if (!this.canScrollHorizontally()) break;
                    if (!event.isAltPressed()) {
                        handled = this.arrowScrollHorizontally(130);
                        break;
                    }
                    handled = this.fullScrollHorizontally(130);
                    break;
                }
                case 62: {
                    if (this.canScrollHorizontally()) {
                        this.pageScrollHorizontally(event.isShiftPressed() ? 33 : 130);
                        break;
                    }
                    if (!this.canScrollVertically()) break;
                    this.pageScrollVertically(event.isShiftPressed() ? 33 : 130);
                }
            }
        }
        return handled;
    }

    private boolean inChild(int x, int y) {
        if (this.getChildCount() > 0) {
            int scrollY = this.getScrollY();
            int scrollX = this.getScrollX();
            View child = this.getChildAt(0);
            return y >= child.getTop() - scrollY && y < child.getBottom() - scrollY && x >= child.getLeft() - scrollX && x < child.getRight() - scrollX;
        }
        return false;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    private void setScrollState(int state) {
        if (state == this.mScrollState) {
            return;
        }
        this.mScrollState = state;
    }

    private void cancelTouch() {
        this.resetTouch();
        this.setScrollState(0);
    }

    private void resetTouch() {
        this.recycleVelocityTracker();
        this.stopNestedScroll();
        this.releaseGlows();
    }

    private void releaseGlows() {
        boolean needsInvalidate = false;
        if (this.mEdgeGlowLeft != null) {
            needsInvalidate = this.mEdgeGlowLeft.onRelease();
        }
        if (this.mEdgeGlowTop != null) {
            needsInvalidate |= this.mEdgeGlowTop.onRelease();
        }
        if (this.mEdgeGlowRight != null) {
            needsInvalidate |= this.mEdgeGlowRight.onRelease();
        }
        if (this.mEdgeGlowBottom != null) {
            needsInvalidate |= this.mEdgeGlowBottom.onRelease();
        }
        if (needsInvalidate) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mScrollState == 1) {
            return true;
        }
        this.setScrollState(0);
        boolean canScrollHorizontally = this.canScrollHorizontally();
        boolean canScrollVertically = this.canScrollVertically();
        switch (action & 0xFF) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent"));
                    break;
                }
                int y = (int)ev.getY(pointerIndex);
                int x = (int)ev.getX(pointerIndex);
                if (this.mScrollState == 1) break;
                int dx = x - this.mInitialTouchX;
                int dy = y - this.mInitialTouchY;
                boolean startScroll = false;
                if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                    this.mLastMotionX = this.mInitialTouchX + this.mTouchSlop * (dx < 0 ? -1 : 1);
                    startScroll = true;
                }
                if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                    this.mLastMotionY = this.mInitialTouchY + this.mTouchSlop * (dy < 0 ? -1 : 1);
                    startScroll = true;
                }
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                if (!startScroll) break;
                this.setScrollState(1);
                break;
            }
            case 0: {
                int y = (int)ev.getY();
                int x = (int)ev.getX();
                if (!this.inChild(x, y)) {
                    this.setScrollState(0);
                    this.recycleVelocityTracker();
                    break;
                }
                this.mLastMotionY = y;
                this.mLastMotionX = x;
                this.mInitialTouchY = this.mLastMotionY;
                this.mInitialTouchX = this.mLastMotionX;
                this.mActivePointerId = ev.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                }
                int nestedScrollAxis = 0;
                if (canScrollHorizontally) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertically) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis);
                break;
            }
            case 3: {
                this.cancelTouch();
                break;
            }
            case 1: {
                this.recycleVelocityTracker();
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)ev);
        boolean canScrollHorizontally = this.canScrollHorizontally();
        boolean canScrollVertically = this.canScrollVertically();
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
            this.mNestedXOffset = 0;
        }
        vtev.offsetLocation((float)this.mNestedXOffset, (float)this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                this.mInTouch = true;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mInitialTouchX = this.mLastMotionY = (int)ev.getY();
                this.mInitialTouchY = this.mLastMotionX = (int)ev.getX();
                this.mActivePointerId = ev.getPointerId(0);
                int nestedScrollAxis = 0;
                if (canScrollHorizontally) {
                    nestedScrollAxis |= 1;
                }
                if (canScrollVertically) {
                    nestedScrollAxis |= 2;
                }
                this.startNestedScroll(nestedScrollAxis);
                break;
            }
            case 2: {
                int unconsumedY;
                int unconsumedX;
                boolean canOverscroll;
                int dy;
                this.mInTouch = true;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent"));
                    return false;
                }
                int y = (int)ev.getY(activePointerIndex);
                int x = (int)ev.getX(activePointerIndex);
                int dx = this.mLastMotionX - x;
                if (this.dispatchNestedPreScroll(dx, dy = this.mLastMotionY - y, this.mScrollConsumed, this.mScrollOffset)) {
                    dy -= this.mScrollConsumed[1];
                    dx -= this.mScrollConsumed[0];
                    vtev.offsetLocation((float)this.mScrollOffset[0], (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                    this.mNestedXOffset += this.mScrollOffset[0];
                }
                if (this.mScrollState != 1) {
                    boolean startScroll = false;
                    if (canScrollHorizontally && Math.abs(dx) > this.mTouchSlop) {
                        dx = dx > 0 ? (dx -= this.mTouchSlop) : (dx += this.mTouchSlop);
                        startScroll = true;
                    }
                    if (canScrollVertically && Math.abs(dy) > this.mTouchSlop) {
                        dy = dy > 0 ? (dy -= this.mTouchSlop) : (dy += this.mTouchSlop);
                        startScroll = true;
                    }
                    if (startScroll) {
                        this.setScrollState(1);
                    }
                }
                if (this.mScrollState != 1) break;
                this.mLastMotionY = y - this.mScrollOffset[1];
                this.mLastMotionX = x - this.mScrollOffset[0];
                int oldY = this.getScrollY();
                int oldX = this.getScrollX();
                int rangeY = this.getScrollRangeY();
                int rangeX = this.getScrollRangeX();
                int overscrollMode = ViewCompat.getOverScrollMode((View)this);
                boolean canOverscrollY = overscrollMode == 0 || overscrollMode == 1 && rangeY > 0;
                boolean canOverscrollX = overscrollMode == 0 || overscrollMode == 1 && rangeX > 0;
                boolean bl = canOverscroll = canOverscrollY && this.canScrollVertically() || canOverscrollX && this.canScrollHorizontally();
                if (this.overScrollByCompat(dx, dy, this.getScrollX(), this.getScrollY(), rangeX, rangeY, 0, 0, true) && this.mChildHelper.hasNestedScrollingParent()) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                int scrolledDeltaY = this.getScrollY() - oldY;
                int scrolledDeltaX = this.getScrollX() - oldX;
                if (this.dispatchNestedScroll(scrolledDeltaX, scrolledDeltaY, unconsumedX = dx - scrolledDeltaX, unconsumedY = dy - scrolledDeltaY, this.mScrollOffset)) {
                    this.mLastMotionY -= this.mScrollOffset[1];
                    this.mLastMotionX -= this.mScrollOffset[0];
                    vtev.offsetLocation((float)this.mScrollOffset[0], (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                    this.mNestedXOffset += this.mScrollOffset[0];
                    break;
                }
                if (!canOverscroll) break;
                this.ensureGlows();
                int pulledToY = oldY + dy;
                int pulledToX = oldX + dx;
                if (this.canScrollVertically()) {
                    if (pulledToY < 0) {
                        this.mEdgeGlowTop.onPull((float)dy / (float)this.getHeight(), ev.getX(activePointerIndex) / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                    } else if (pulledToY > rangeY) {
                        this.mEdgeGlowBottom.onPull((float)dy / (float)this.getHeight(), 1.0f - ev.getX(activePointerIndex) / (float)this.getWidth());
                        if (!this.mEdgeGlowTop.isFinished()) {
                            this.mEdgeGlowTop.onRelease();
                        }
                    }
                }
                if (this.canScrollHorizontally()) {
                    if (pulledToX < 0) {
                        this.mEdgeGlowLeft.onPull((float)dx / (float)this.getWidth(), ev.getX(activePointerIndex) / (float)this.getHeight());
                        if (!this.mEdgeGlowLeft.isFinished()) {
                            this.mEdgeGlowLeft.onRelease();
                        }
                    } else if (pulledToX > rangeX) {
                        this.mEdgeGlowRight.onPull((float)dx / (float)this.getWidth(), 1.0f - ev.getX(activePointerIndex) / (float)this.getHeight());
                        if (!this.mEdgeGlowRight.isFinished()) {
                            this.mEdgeGlowRight.onRelease();
                        }
                    }
                }
                if (this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished() && this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished()) break;
                ViewCompat.postInvalidateOnAnimation((View)this);
                break;
            }
            case 1: {
                float yvel;
                this.mInTouch = false;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                float xvel = canScrollHorizontally ? -VelocityTrackerCompat.getXVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId) : 0.0f;
                float f = yvel = canScrollVertically ? -VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId) : 0.0f;
                if (this.fling((int)xvel, (int)yvel)) {
                    this.setScrollState(0);
                } else if (this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, this.getScrollRangeX(), 0, this.getScrollRangeY())) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                this.mActivePointerId = -1;
                this.resetTouch();
                break;
            }
            case 3: {
                this.mInTouch = false;
                if (this.mScrollState == 1 && this.mScroller.springBack(this.getScrollX(), this.getScrollY(), 0, this.getScrollRangeX(), 0, this.getScrollRangeY())) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                this.mActivePointerId = -1;
                this.cancelTouch();
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                this.mInitialTouchX = this.mLastMotionY = (int)ev.getY(index);
                this.mInitialTouchX = this.mLastMotionX = (int)ev.getX(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = (int)ev.getY(newPointerIndex);
            this.mLastMotionX = (int)ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    int newScrollX;
                    int newScrollY;
                    float vscroll = event.getAxisValue(9);
                    float hscroll = event.getAxisValue(10);
                    if (vscroll == 0.0f) break;
                    int oldScrollY = newScrollY = this.getScrollY();
                    int oldScrollX = newScrollX = this.getScrollX();
                    if (this.canScrollHorizontally()) {
                        int rangeX = this.getScrollRangeX();
                        int deltaX = (int)(hscroll * this.getHorizontalScrollFactorCompat());
                        newScrollX = oldScrollX - deltaX;
                        if (newScrollX < 0) {
                            newScrollX = 0;
                        } else if (newScrollX > rangeX) {
                            newScrollX = rangeX;
                        }
                    }
                    if (this.canScrollVertically()) {
                        int deltaY = (int)(vscroll * this.getVerticalScrollFactorCompat());
                        int rangeY = this.getScrollRangeY();
                        newScrollY = oldScrollY - deltaY;
                        if (newScrollY < 0) {
                            newScrollY = 0;
                        } else if (newScrollY > rangeY) {
                            newScrollY = rangeY;
                        }
                    }
                    if (newScrollY == oldScrollY && newScrollX == oldScrollX) break;
                    super.scrollTo(newScrollX, newScrollY);
                    return true;
                }
            }
        }
        return false;
    }

    private float getVerticalScrollFactorCompat() {
        if (this.mVerticalScrollFactor == 0.0f) {
            TypedValue outValue = new TypedValue();
            Context context = this.getContext();
            if (!context.getTheme().resolveAttribute(16842829, outValue, true)) {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
            this.mVerticalScrollFactor = outValue.getDimension(context.getResources().getDisplayMetrics());
        }
        return this.mVerticalScrollFactor;
    }

    private float getHorizontalScrollFactorCompat() {
        if (this.mVerticalScrollFactor == 0.0f) {
            TypedValue outValue = new TypedValue();
            Context context = this.getContext();
            if (!context.getTheme().resolveAttribute(16842829, outValue, true)) {
                throw new IllegalStateException("Expected theme to define listPreferredItemHeight.");
            }
            this.mVerticalScrollFactor = outValue.getDimension(context.getResources().getDisplayMetrics());
        }
        return this.mVerticalScrollFactor;
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        super.scrollTo(scrollX, scrollY);
    }

    boolean overScrollByCompat(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        int oldScrollX = this.getScrollX();
        int oldScrollY = this.getScrollY();
        int overScrollMode = ViewCompat.getOverScrollMode((View)this);
        boolean canScrollHorizontal = this.computeHorizontalScrollRange() > this.computeHorizontalScrollExtent() && this.canScrollHorizontally();
        boolean canScrollVertical = this.computeVerticalScrollRange() > this.computeVerticalScrollExtent() && this.canScrollVertically();
        boolean overScrollHorizontal = overScrollMode == 0 || overScrollMode == 1 && canScrollHorizontal;
        boolean overScrollVertical = overScrollMode == 0 || overScrollMode == 1 && canScrollVertical;
        int newScrollX = scrollX;
        if (this.canScrollHorizontally()) {
            newScrollX += deltaX;
        }
        int newScrollY = scrollY;
        if (this.canScrollVertically()) {
            newScrollY += deltaY;
        }
        int left = -maxOverScrollX;
        int right = maxOverScrollX + scrollRangeX;
        int top = -maxOverScrollY;
        int bottom = maxOverScrollY + scrollRangeY;
        boolean clampedX = false;
        if (newScrollX > right) {
            newScrollX = right;
            clampedX = true;
        } else if (newScrollX < left) {
            newScrollX = left;
            clampedX = true;
        }
        boolean clampedY = false;
        if (newScrollY > bottom) {
            newScrollY = bottom;
            clampedY = true;
        } else if (newScrollY < top) {
            newScrollY = top;
            clampedY = true;
        }
        if (clampedY && clampedX) {
            this.mScroller.springBack(newScrollX, newScrollY, 0, this.getScrollRangeX(), 0, this.getScrollRangeY());
        }
        this.onOverScrolled(newScrollX, newScrollY, clampedX, clampedY);
        return this.getScrollX() - oldScrollX == deltaX || this.getScrollY() - oldScrollY == deltaY;
    }

    int getScrollRangeX() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getWidth() - (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()));
        }
        return scrollRange;
    }

    int getScrollRangeY() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getHeight() - (this.getHeight() - this.getPaddingBottom() - this.getPaddingTop()));
        }
        return scrollRange;
    }

    private View findFocusableViewInBoundsVertically(boolean topFocus, int top, int bottom) {
        ArrayList focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        int count = focusables.size();
        for (int i = 0; i < count; ++i) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            View view = (View)focusables.get(i);
            int viewTop = view.getTop();
            int viewBottom = view.getBottom();
            if (top >= viewBottom || viewTop >= bottom) continue;
            boolean bl = viewIsFullyContained = top < viewTop && viewBottom < bottom;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = topFocus && viewTop < focusCandidate.getTop() || !topFocus && viewBottom > focusCandidate.getBottom();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    private View findFocusableViewInBoundsHorizontally(boolean topFocus, int left, int right) {
        ArrayList focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        int count = focusables.size();
        for (int i = 0; i < count; ++i) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            View view = (View)focusables.get(i);
            int viewLeft = view.getLeft();
            int viewRight = view.getRight();
            if (left >= viewRight || viewLeft >= viewRight) continue;
            boolean bl = viewIsFullyContained = left < viewLeft && viewRight < right;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = topFocus && viewLeft < focusCandidate.getTop() || !topFocus && viewRight > focusCandidate.getBottom();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    public boolean pageScrollHorizontally(int direction) {
        boolean down = direction == 130;
        int width = this.getWidth();
        if (down) {
            View view;
            this.mTempRect.left = this.getScrollX() + width;
            int count = this.getChildCount();
            if (count > 0 && this.mTempRect.left + width > (view = this.getChildAt(count - 1)).getRight()) {
                this.mTempRect.left = view.getRight() - width;
            }
        } else {
            this.mTempRect.left = this.getScrollY() - width;
            if (this.mTempRect.left < 0) {
                this.mTempRect.left = 0;
            }
        }
        this.mTempRect.right = this.mTempRect.left + width;
        return this.scrollAndFocusHorizontally(direction, this.mTempRect.left, this.mTempRect.right);
    }

    public boolean pageScrollVertically(int direction) {
        boolean down = direction == 130;
        int height = this.getHeight();
        if (down) {
            View view;
            this.mTempRect.top = this.getScrollY() + height;
            int count = this.getChildCount();
            if (count > 0 && this.mTempRect.top + height > (view = this.getChildAt(count - 1)).getBottom()) {
                this.mTempRect.top = view.getBottom() - height;
            }
        } else {
            this.mTempRect.top = this.getScrollY() - height;
            if (this.mTempRect.top < 0) {
                this.mTempRect.top = 0;
            }
        }
        this.mTempRect.bottom = this.mTempRect.top + height;
        return this.scrollAndFocusVertically(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    public boolean fullScrollVertically(int direction) {
        int count;
        boolean down = direction == 130;
        int height = this.getHeight();
        this.mTempRect.top = 0;
        this.mTempRect.bottom = height;
        if (down && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(count - 1);
            this.mTempRect.bottom = view.getBottom() + this.getPaddingBottom();
            this.mTempRect.top = this.mTempRect.bottom - height;
        }
        return this.scrollAndFocusVertically(direction, this.mTempRect.top, this.mTempRect.bottom);
    }

    public boolean fullScrollHorizontally(int direction) {
        int count;
        boolean down = direction == 66;
        int width = this.getWidth();
        this.mTempRect.left = 0;
        this.mTempRect.right = width;
        if (down && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(count - 1);
            this.mTempRect.right = view.getRight() + this.getPaddingLeft();
            this.mTempRect.left = this.mTempRect.right - width;
        }
        return this.scrollAndFocusHorizontally(direction, this.mTempRect.left, this.mTempRect.right);
    }

    private boolean scrollAndFocusHorizontally(int direction, int left, int right) {
        boolean handled = true;
        int width = this.getWidth();
        int containerLeft = this.getScrollX();
        int containerRight = containerLeft + width;
        boolean up = direction == 17;
        Object newFocused = this.findFocusableViewInBoundsHorizontally(up, left, right);
        if (newFocused == null) {
            newFocused = this;
        }
        if (left >= containerLeft && right <= containerRight) {
            handled = false;
        } else {
            int delta = up ? left - containerLeft : right - containerRight;
            this.doScrollX(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    private boolean scrollAndFocusVertically(int direction, int top, int bottom) {
        boolean handled = true;
        int height = this.getHeight();
        int containerTop = this.getScrollY();
        int containerBottom = containerTop + height;
        boolean up = direction == 33;
        Object newFocused = this.findFocusableViewInBoundsVertically(up, top, bottom);
        if (newFocused == null) {
            newFocused = this;
        }
        if (top >= containerTop && bottom <= containerBottom) {
            handled = false;
        } else {
            int delta = up ? top - containerTop : bottom - containerBottom;
            this.doScrollY(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    public boolean arrowScrollHorizontally(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
        int maxJump = this.getMaxScrollAmountX();
        if (nextFocused != null && this.isWithinDeltaOfScreenX(nextFocused, maxJump, this.getWidth())) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            int[] scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollX(scrollDelta[0]);
            nextFocused.requestFocus(direction);
        } else {
            int screenRight;
            int daRight;
            int scrollDelta = maxJump;
            if (direction == 33 && this.getScrollX() < scrollDelta) {
                scrollDelta = this.getScrollX();
            } else if (direction == 130 && this.getChildCount() > 0 && (daRight = this.getChildAt(0).getRight()) - (screenRight = this.getScrollX() + this.getWidth() - this.getPaddingRight()) < maxJump) {
                scrollDelta = daRight - screenRight;
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollX(direction == 130 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreenX(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    public boolean arrowScrollVertically(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
        int maxJump = this.getMaxScrollAmountY();
        if (nextFocused != null && this.isWithinDeltaOfScreenY(nextFocused, maxJump, this.getHeight())) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            int[] scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollY(scrollDelta[1]);
            nextFocused.requestFocus(direction);
        } else {
            int screenBottom;
            int daBottom;
            int scrollDelta = maxJump;
            if (direction == 33 && this.getScrollY() < scrollDelta) {
                scrollDelta = this.getScrollY();
            } else if (direction == 130 && this.getChildCount() > 0 && (daBottom = this.getChildAt(0).getBottom()) - (screenBottom = this.getScrollY() + this.getHeight() - this.getPaddingBottom()) < maxJump) {
                scrollDelta = daBottom - screenBottom;
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollY(direction == 130 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreenY(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    private boolean isOffScreenX(View descendant) {
        return !this.isWithinDeltaOfScreenX(descendant, 0, this.getWidth());
    }

    private boolean isOffScreenY(View descendant) {
        return !this.isWithinDeltaOfScreenY(descendant, 0, this.getHeight());
    }

    private boolean isWithinDeltaOfScreenX(View descendant, int delta, int width) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.right + delta >= this.getScrollX() && this.mTempRect.left - delta <= this.getScrollX() + width;
    }

    private boolean isWithinDeltaOfScreenY(View descendant, int delta, int height) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.bottom + delta >= this.getScrollY() && this.mTempRect.top - delta <= this.getScrollY() + height;
    }

    private void doScrollXY(int[] delta) {
        this.doScrollXY(delta[0], delta[1]);
    }

    private void doScrollXY(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(deltaX, deltaY);
            } else {
                this.scrollBy(deltaX, deltaY);
            }
        }
    }

    private void doScrollY(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(0, delta);
            } else {
                this.scrollBy(0, delta);
            }
        }
    }

    private void doScrollX(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(delta, 0);
            } else {
                this.scrollBy(delta, 0);
            }
        }
    }

    public final void smoothScrollBy(int dx, int dy) {
        if (this.getChildCount() == 0) {
            return;
        }
        long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
        if (duration > 250L) {
            int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            int right = this.getChildAt(0).getWidth();
            int bottom = this.getChildAt(0).getHeight();
            int maxX = Math.max(0, right - width);
            int maxY = Math.max(0, bottom - height);
            int scrollX = this.getScrollX();
            int scrollY = this.getScrollY();
            dx = Math.max(0, Math.min(scrollX + dx, maxX)) - scrollX;
            dy = Math.max(0, Math.min(scrollY + dy, maxY)) - scrollY;
            this.mScroller.startScroll(scrollX, scrollY, dx, dy);
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
            }
            this.scrollBy(dx, dy);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void smoothScrollTo(int x, int y) {
        this.smoothScrollBy(x - this.getScrollX(), y - this.getScrollY());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeVerticalScrollRange() {
        int count = this.getChildCount();
        int contentHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (count == 0) {
            return contentHeight;
        }
        int scrollRange = this.getChildAt(0).getBottom();
        int scrollY = this.getScrollY();
        int overscrollBottom = Math.max(0, scrollRange - contentHeight);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overscrollBottom) {
            scrollRange += scrollY - overscrollBottom;
        }
        return scrollRange;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeVerticalScrollExtent() {
        return super.computeVerticalScrollExtent();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeHorizontalScrollRange() {
        int count = this.getChildCount();
        int contentWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        if (count == 0) {
            return contentWidth;
        }
        int scrollRange = this.getChildAt(0).getRight();
        int scrollX = this.getScrollX();
        int overscrollRight = Math.max(0, scrollRange - contentWidth);
        if (scrollX < 0) {
            scrollRange -= scrollX;
        } else if (scrollX > overscrollRight) {
            scrollRange += scrollX - overscrollRight;
        }
        return scrollRange;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeHorizontalScrollOffset() {
        return super.computeHorizontalScrollOffset();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeHorizontalScrollExtent() {
        return super.computeHorizontalScrollExtent();
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(lp.leftMargin + lp.rightMargin), (int)0);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(lp.topMargin + lp.bottomMargin), (int)0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                int rangeY = this.getScrollRangeY();
                int rangeX = this.getScrollRangeX();
                int overscrollMode = ViewCompat.getOverScrollMode((View)this);
                boolean canOverscrollY = overscrollMode == 0 || overscrollMode == 1 && rangeY > 0;
                boolean canOverscrollX = overscrollMode == 0 || overscrollMode == 1 && rangeX > 0;
                boolean canOverscroll = canOverscrollY || canOverscrollX;
                this.overScrollByCompat(x - oldX, y - oldY, oldX, oldY, rangeX, rangeY, 0, 0, false);
                if (canOverscroll) {
                    this.ensureGlows();
                    if (y <= 0 && oldY > 0) {
                        this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (y >= rangeY && oldY < rangeY) {
                        this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                    if (x <= 0 && oldX > 0) {
                        this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (x >= rangeX && oldX < rangeX) {
                        this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                }
            }
            if (this.mScroller.isFinished()) {
                this.setScrollState(0);
            } else {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }
        if (this.mScroller.isFinished() && !this.mInTouch && this.mOnScrollChangeListener != null) {
            this.mOnScrollChangeListener.onScrollEnd(this, this.getScrollX(), this.getScrollY());
        }
    }

    private void scrollToChild(View child) {
        child.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        int[] scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (scrollDelta[0] != 0 || scrollDelta[1] != 0) {
            this.scrollBy(scrollDelta[0], scrollDelta[1]);
        }
    }

    private boolean scrollToChildRect(Rect rect, boolean immediate) {
        boolean scroll;
        int[] delta = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        boolean bl = scroll = delta[0] != 0 || delta[1] != 0;
        if (scroll) {
            if (immediate) {
                this.scrollBy(delta[0], delta[1]);
            } else {
                this.smoothScrollBy(delta[0], delta[1]);
            }
        }
        return scroll;
    }

    protected int[] computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        if (this.getChildCount() == 0) {
            return new int[]{0, 0};
        }
        int height = this.getHeight();
        int width = this.getWidth();
        int screenTop = this.getScrollY();
        int screenBottom = screenTop + height;
        int screenLeft = this.getScrollX();
        int screenRight = screenLeft + width;
        int fadingEdgeY = this.getVerticalFadingEdgeLength();
        int fadingEdgeX = this.getHorizontalFadingEdgeLength();
        if (rect.top > 0) {
            screenTop += fadingEdgeY;
        }
        if (rect.left > 0) {
            screenLeft += fadingEdgeX;
        }
        if (rect.bottom < this.getChildAt(0).getHeight()) {
            screenBottom -= fadingEdgeY;
        }
        if (rect.right < this.getChildAt(0).getWidth()) {
            screenRight -= fadingEdgeX;
        }
        int scrollYDelta = 0;
        int scrollXDelta = 0;
        if (rect.bottom > screenBottom && rect.top > screenTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - screenTop) : (scrollYDelta += rect.bottom - screenBottom);
            int bottom = this.getChildAt(0).getBottom();
            int distanceToBottom = bottom - screenBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < screenTop && rect.bottom < screenBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= screenBottom - rect.bottom) : (scrollYDelta -= screenTop - rect.top);
            scrollYDelta = Math.max(scrollYDelta, -this.getScrollY());
        }
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
            int right = this.getChildAt(0).getRight();
            int distanceToRight = right - screenRight;
            scrollXDelta = Math.min(scrollXDelta, distanceToRight);
        } else if (rect.left < screenLeft && rect.right < screenRight) {
            scrollXDelta = rect.width() > width ? (scrollXDelta -= screenRight - rect.right) : (scrollXDelta -= screenLeft - rect.left);
            scrollXDelta = Math.max(scrollXDelta, -this.getScrollX());
        }
        return new int[]{scrollXDelta, scrollYDelta};
    }

    public void requestChildFocus(View child, View focused) {
        if (!this.mIsLayoutDirty) {
            this.scrollToChild(focused);
        } else {
            this.mChildToScrollTo = focused;
        }
        super.requestChildFocus(child, focused);
    }

    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        View nextFocus;
        if (direction == 2) {
            direction = 130;
        } else if (direction == 1) {
            direction = 33;
        }
        View view = nextFocus = previouslyFocusedRect == null ? FocusFinder.getInstance().findNextFocus((ViewGroup)this, null, direction) : FocusFinder.getInstance().findNextFocusFromRect((ViewGroup)this, previouslyFocusedRect, direction);
        if (nextFocus == null) {
            return false;
        }
        if (this.canScrollHorizontally() ? this.isOffScreenX(nextFocus) : this.canScrollVertically() && this.isOffScreenY(nextFocus)) {
            return false;
        }
        return nextFocus.requestFocus(direction, previouslyFocusedRect);
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        return this.scrollToChildRect(rectangle, immediate);
    }

    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && HVScrollView.isViewDescendantOf(this.mChildToScrollTo, (View)this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.mIsLaidOut) {
            if (this.mSavedState != null) {
                this.scrollTo(this.mSavedState.scrollPositionX, this.mSavedState.scrollPositionY);
                this.mSavedState = null;
            }
            int childWidth = this.getChildCount() > 0 ? this.getChildAt(0).getMeasuredWidth() : 0;
            int childHeight = this.getChildCount() > 0 ? this.getChildAt(0).getMeasuredHeight() : 0;
            int scrollRangeX = Math.max(0, childWidth - (b - t - this.getPaddingLeft() - this.getPaddingRight()));
            int scrollRangeY = Math.max(0, childHeight - (b - t - this.getPaddingBottom() - this.getPaddingTop()));
            int scrollX = Math.max(0, Math.min(scrollRangeX, this.getScrollX()));
            int scrollY = Math.max(0, Math.min(scrollRangeY, this.getScrollY()));
            this.scrollTo(scrollX, scrollY);
        }
        this.scrollTo(this.getScrollX(), this.getScrollY());
        this.mIsLaidOut = true;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsLaidOut = false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        View currentFocused = this.findFocus();
        if (null == currentFocused || this == currentFocused) {
            return;
        }
        if (this.isWithinDeltaOfScreenX(currentFocused, 0, oldw) || this.isWithinDeltaOfScreenY(currentFocused, 0, oldh)) {
            currentFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
            int[] scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollXY(scrollDelta);
        }
    }

    private static boolean isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && HVScrollView.isViewDescendantOf((View)theParent, parent);
    }

    private boolean fling(int velocityX, int velocityY) {
        boolean canScrollHorizontal = this.canScrollHorizontally();
        boolean canScrollVertical = this.canScrollVertically();
        if (!canScrollHorizontal || Math.abs(velocityX) < this.mMinimumVelocity) {
            velocityX = 0;
        }
        if (!canScrollVertical || Math.abs(velocityY) < this.mMinimumVelocity) {
            velocityY = 0;
        }
        if (velocityX == 0 && velocityY == 0) {
            return false;
        }
        if (!this.dispatchNestedPreFling(velocityX, velocityY)) {
            int scrollY = this.getScrollY();
            int scrollX = this.getScrollX();
            boolean canFlingY = !(scrollY <= 0 && velocityY <= 0 || scrollY >= this.getScrollRangeY() && velocityY >= 0);
            boolean canFlingX = !(scrollX <= 0 && velocityX <= 0 || scrollX >= this.getScrollRangeX() && velocityX >= 0);
            boolean canFling = canFlingY || canFlingX;
            this.dispatchNestedFling(velocityX, velocityY, canFling);
            if (canFling) {
                this.setScrollState(2);
                velocityX = Math.max(-this.mMaximumVelocity, Math.min(velocityX, this.mMaximumVelocity));
                velocityY = Math.max(-this.mMaximumVelocity, Math.min(velocityY, this.mMaximumVelocity));
                int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
                int width = this.getWidth() - this.getPaddingRight() - this.getPaddingLeft();
                int bottom = this.getChildAt(0).getHeight();
                int right = this.getChildAt(0).getWidth();
                this.mScroller.fling(this.getScrollX(), this.getScrollY(), velocityX, velocityY, 0, Math.max(0, right - width), 0, Math.max(0, bottom - height), width / 2, height / 2);
                return true;
            }
        }
        return false;
    }

    private void flingWithNestedDispatch(int velocityX, int velocityY) {
        boolean canFling;
        int scrollX = this.getScrollX();
        int scrollY = this.getScrollY();
        boolean bl = canFling = !((scrollY <= 0 && velocityY <= 0 || scrollY >= this.getScrollRangeY() && velocityY >= 0) && (scrollX <= 0 && velocityX <= 0 || scrollX >= this.getScrollRangeX() && velocityX >= 0));
        if (!this.dispatchNestedPreFling(velocityX, velocityY)) {
            this.dispatchNestedFling(velocityX, velocityY, canFling);
            this.fling(velocityX, velocityY);
        }
    }

    public void scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            x = HVScrollView.clamp(x, this.getWidth() - this.getPaddingRight() - this.getPaddingLeft(), child.getWidth());
            y = HVScrollView.clamp(y, this.getHeight() - this.getPaddingBottom() - this.getPaddingTop(), child.getHeight());
            if (x != this.getScrollX() || y != this.getScrollY()) {
                super.scrollTo(x, y);
            }
        }
    }

    private void ensureGlows() {
        if (this.getOverScrollMode() != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffectCompat(context);
                this.mEdgeGlowBottom = new EdgeEffectCompat(context);
                this.mEdgeGlowLeft = new EdgeEffectCompat(context);
                this.mEdgeGlowRight = new EdgeEffectCompat(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int height;
            int width;
            int restoreCount;
            int scrollX = this.getScrollX();
            int scrollY = this.getScrollY();
            if (!this.mEdgeGlowTop.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                canvas.translate((float)this.getPaddingLeft(), (float)Math.min(0, scrollY));
                this.mEdgeGlowTop.setSize(width, this.getHeight());
                if (this.mEdgeGlowTop.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowLeft.isFinished()) {
                restoreCount = canvas.save();
                int height2 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.translate((float)this.getPaddingTop(), (float)Math.min(0, scrollX));
                this.mEdgeGlowLeft.setSize(this.getWidth(), height2);
                if (this.mEdgeGlowLeft.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowRight.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth();
                height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.translate((float)(Math.max(this.getScrollRangeX(), scrollX) + width), (float)(-height + this.getPaddingTop()));
                canvas.rotate(180.0f, 0.0f, (float)height);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                restoreCount = canvas.save();
                width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                height = this.getHeight();
                canvas.translate((float)(-width + this.getPaddingLeft()), (float)(Math.max(this.getScrollRangeY(), scrollY) + height));
                canvas.rotate(180.0f, (float)width, 0.0f);
                this.mEdgeGlowBottom.setSize(width, height);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private static int clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSavedState = ss;
        this.requestLayout();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.scrollPositionX = this.getScrollX();
        ss.scrollPositionY = this.getScrollY();
        return ss;
    }

    static class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        AccessibilityDelegate() {
        }

        public boolean performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            HVScrollView nsvHost = (HVScrollView)host;
            if (!nsvHost.isEnabled()) {
                return false;
            }
            switch (action) {
                case 4096: {
                    int viewportHeight = nsvHost.getHeight() - nsvHost.getPaddingBottom() - nsvHost.getPaddingTop();
                    int targetScrollY = Math.min(nsvHost.getScrollY() + viewportHeight, nsvHost.getScrollRangeY());
                    if (targetScrollY != nsvHost.getScrollY()) {
                        nsvHost.smoothScrollTo(0, targetScrollY);
                        return true;
                    }
                    return false;
                }
                case 8192: {
                    int viewportHeight = nsvHost.getHeight() - nsvHost.getPaddingBottom() - nsvHost.getPaddingTop();
                    int targetScrollY = Math.max(nsvHost.getScrollY() - viewportHeight, 0);
                    if (targetScrollY != nsvHost.getScrollY()) {
                        nsvHost.smoothScrollTo(0, targetScrollY);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            int scrollRange;
            super.onInitializeAccessibilityNodeInfo(host, info);
            HVScrollView nsvHost = (HVScrollView)host;
            info.setClassName((CharSequence)ScrollView.class.getName());
            if (nsvHost.isEnabled() && (scrollRange = nsvHost.getScrollRangeY()) > 0) {
                info.setScrollable(true);
                if (nsvHost.getScrollY() > 0) {
                    info.addAction(8192);
                }
                if (nsvHost.getScrollY() < scrollRange) {
                    info.addAction(4096);
                }
            }
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            HVScrollView nsvHost = (HVScrollView)host;
            event.setClassName((CharSequence)ScrollView.class.getName());
            boolean scrollable = nsvHost.getScrollRangeY() > 0;
            event.setScrollable(scrollable);
            event.setScrollX(nsvHost.getScrollX());
            event.setScrollY(nsvHost.getScrollY());
            AccessibilityRecordCompat.setMaxScrollX((AccessibilityRecord)event, (int)nsvHost.getScrollX());
            AccessibilityRecordCompat.setMaxScrollY((AccessibilityRecord)event, (int)nsvHost.getScrollRangeY());
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public int scrollPositionX;
        public int scrollPositionY;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel source) {
            super(source);
            this.scrollPositionX = source.readInt();
            this.scrollPositionY = source.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.scrollPositionX);
            dest.writeInt(this.scrollPositionY);
        }

        public String toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " scrollPositionX=" + this.scrollPositionX + ", scrollPositionY=" + this.scrollPositionY + "}";
        }
    }

    public static interface OnScrollChangeListener {
        public void onScrollChange(HVScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrollEnd(HVScrollView var1, int var2, int var3);
    }
}

