/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.utils;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.json.JSONArray;
import org.json.JSONObject;
import pub.doric.Doric;

public class DoricUtils {
    private static int sScreenWidthPixels;
    private static int sScreenHeightPixels;
    private static final int NO_COLOR = 1;
    private static final int X_SIZE = 2;
    private static final int Y_SIZE = 2;
    private static final int COLOR_SIZE = 9;
    private static final int BUFFER_SIZE = 84;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAssetFile(String assetFile) {
        InputStream inputStream = null;
        try {
            AssetManager assetManager = Doric.application().getAssets();
            inputStream = assetManager.open(assetFile);
            int length = inputStream.available();
            byte[] buffer = new byte[length];
            inputStream.read(buffer);
            String string2 = new String(buffer);
            return string2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static JavaValue toJavaValue(Object arg) {
        if (arg == null) {
            return new JavaValue();
        }
        if (arg instanceof JSONBuilder) {
            return new JavaValue(((JSONBuilder)arg).toJSONObject());
        }
        if (arg instanceof JSONObject) {
            return new JavaValue((JSONObject)arg);
        }
        if (arg instanceof JSONArray) {
            return new JavaValue((JSONArray)arg);
        }
        if (arg instanceof String) {
            return new JavaValue((String)arg);
        }
        if (arg instanceof Integer) {
            return new JavaValue((double)((Integer)arg).intValue());
        }
        if (arg instanceof Long) {
            return new JavaValue((double)((Long)arg).longValue());
        }
        if (arg instanceof Float) {
            return new JavaValue((double)((Float)arg).floatValue());
        }
        if (arg instanceof Double) {
            return new JavaValue(((Double)arg).doubleValue());
        }
        if (arg instanceof Boolean) {
            return new JavaValue(((Boolean)arg).booleanValue());
        }
        if (arg instanceof JavaValue) {
            return (JavaValue)arg;
        }
        if (arg instanceof Object[]) {
            JSONArray jsonArray = new JSONArray();
            for (Object o : (Object[])arg) {
                jsonArray.put(o);
            }
            return new JavaValue(jsonArray);
        }
        return new JavaValue(String.valueOf(arg));
    }

    public static Object toJavaObject(@NonNull Class clz, JSDecoder decoder) throws Exception {
        if (clz == JSDecoder.class) {
            return decoder;
        }
        return DoricUtils.toJavaObject(clz, decoder.decode());
    }

    public static Object toJavaObject(@NonNull Class clz, JSValue jsValue) throws Exception {
        if (clz == JSValue.class || JSValue.class.isAssignableFrom(clz)) {
            return jsValue;
        }
        if (clz == String.class) {
            return jsValue.asString().value();
        }
        if (clz == Boolean.TYPE || clz == Boolean.class) {
            return jsValue.asBoolean().value();
        }
        if (clz == Integer.TYPE || clz == Integer.class) {
            return jsValue.asNumber().toInt();
        }
        if (clz == Long.TYPE || clz == Long.class) {
            return jsValue.asNumber().toLong();
        }
        if (clz == Float.TYPE || clz == Float.class) {
            return Float.valueOf(jsValue.asNumber().toFloat());
        }
        if (clz == Double.TYPE || clz == Double.class) {
            return jsValue.asNumber().toDouble();
        }
        if (clz.isArray()) {
            Object ret;
            Class<?> elementClass = clz.getComponentType();
            if (jsValue.isArray()) {
                JSArray jsArray = jsValue.asArray();
                ret = Array.newInstance(clz, jsArray.size());
                for (int i = 0; i < jsArray.size(); ++i) {
                    Array.set(ret, i, DoricUtils.toJavaObject(elementClass, jsArray.get(i)));
                }
            } else {
                ret = jsValue.isNull() ? Array.newInstance(clz, 0) : null;
            }
            return ret;
        }
        return null;
    }

    public static int getScreenWidth(Context context) {
        if (context == null) {
            context = Doric.application();
        }
        if (sScreenWidthPixels > 0) {
            return sScreenWidthPixels;
        }
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        if (display != null) {
            display.getMetrics(dm);
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 1) {
                sScreenWidthPixels = dm.widthPixels;
                sScreenHeightPixels = dm.heightPixels;
            } else if (orientation == 2) {
                sScreenWidthPixels = dm.heightPixels;
                sScreenHeightPixels = dm.widthPixels;
            }
        }
        return sScreenWidthPixels;
    }

    public static int getScreenWidth() {
        return DoricUtils.getScreenWidth(null);
    }

    public static int getScreenHeight(Context context) {
        if (context == null) {
            context = Doric.application();
        }
        if (sScreenHeightPixels > 0) {
            return sScreenHeightPixels;
        }
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager manager = (WindowManager)context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        if (display != null) {
            display.getMetrics(dm);
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 1) {
                sScreenWidthPixels = dm.widthPixels;
                sScreenHeightPixels = dm.heightPixels;
            } else if (orientation == 2) {
                sScreenWidthPixels = dm.heightPixels;
                sScreenHeightPixels = dm.widthPixels;
            }
        }
        return sScreenHeightPixels;
    }

    public static int getScreenHeight() {
        return DoricUtils.getScreenHeight(null);
    }

    public static float px2dp(float pxValue) {
        return DoricUtils.px2dp(null, pxValue);
    }

    public static float px2dp(Context context, float pxValue) {
        if (context == null) {
            context = Doric.application();
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return pxValue / scale;
    }

    public static int dp2px(float dpValue) {
        return DoricUtils.dp2px(null, dpValue);
    }

    public static int dp2px(Context context, float dipValue) {
        if (context == null) {
            context = Doric.application();
        }
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + (dipValue > 0.0f ? 0.5f : -0.5f));
    }

    public static int getStatusBarHeight() {
        int resourceId = Resources.getSystem().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return Resources.getSystem().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static float getScreenScale() {
        Resources resources = Resources.getSystem();
        if (resources.getDisplayMetrics() != null) {
            return resources.getDisplayMetrics().density;
        }
        return 1.0f;
    }

    public static byte[] getNinePatchChunk(Rect rect) {
        if (rect == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(84).order(ByteOrder.nativeOrder());
        byteBuffer.put((byte)1);
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)2);
        byteBuffer.put((byte)9);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        byteBuffer.putInt(rect.left);
        byteBuffer.putInt(rect.right);
        byteBuffer.putInt(rect.top);
        byteBuffer.putInt(rect.bottom);
        for (int i = 0; i < 9; ++i) {
            byteBuffer.putInt(1);
        }
        return byteBuffer.array();
    }

    public static Pair<String, String> translateBase64(String input) {
        String typePrefix = "data:image/";
        String dataPrefix = ";base64,";
        int typeIndex = input.indexOf(typePrefix);
        int dataIndex = input.indexOf(dataPrefix);
        if (typeIndex != -1 && dataIndex != -1) {
            String imageType = input.substring(typePrefix.length() + 1, dataIndex);
            String base64 = input.substring(dataIndex + dataPrefix.length());
            return new Pair((Object)imageType, (Object)base64);
        }
        return null;
    }

    public static Context unwrap(Context context) {
        while (!(context instanceof Activity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context;
    }
}

