/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.utils;

import android.os.Handler;
import android.os.Looper;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import pub.doric.async.AsyncResult;

public class DoricJSDispatcher
implements AsyncResult.Callback {
    private LinkedList<Callable<AsyncResult>> blocks = new LinkedList();
    private boolean consuming = false;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public void dispatch(Callable<AsyncResult> block) {
        if (this.blocks.size() > 0) {
            this.blocks.clear();
        }
        this.blocks.push(block);
        if (!this.consuming) {
            this.consume();
        }
    }

    private void consume() {
        Callable<AsyncResult> block = this.blocks.pollLast();
        if (block != null) {
            this.consuming = true;
            try {
                AsyncResult result = block.call();
                result.setCallback(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.consume();
            }
        } else {
            this.consuming = false;
        }
    }

    public void onResult(Object result) {
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            this.consume();
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    DoricJSDispatcher.this.consume();
                }
            });
        }
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onFinish() {
    }
}

