/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.list;

import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.github.pengfeizhou.jscore.JSNumber;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.DoricScrollChangeListener;
import pub.doric.IDoricScrollable;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;
import pub.doric.shader.list.ListAdapter;
import pub.doric.utils.DoricJSDispatcher;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="List")
public class ListNode
extends SuperNode<RecyclerView>
implements IDoricScrollable {
    private final ListAdapter listAdapter;
    private String renderItemFuncId;
    String onLoadMoreFuncId;
    int itemCount = 0;
    int batchCount = 15;
    SparseArray<String> itemValues = new SparseArray();
    boolean loadMore = false;
    String loadMoreViewId;
    private final Set<DoricScrollChangeListener> listeners = new HashSet<DoricScrollChangeListener>();
    private String onScrollFuncId;
    private String onScrollEndFuncId;
    private final DoricJSDispatcher jsDispatcher = new DoricJSDispatcher();

    public ListNode(DoricContext doricContext) {
        super(doricContext);
        this.listAdapter = new ListAdapter(this);
    }

    @Override
    protected void blendSubNode(JSObject subProperties) {
        String viewId = subProperties.getProperty("id").asString().value();
        ViewNode node = this.getSubNodeById(viewId);
        if (node != null) {
            node.blend(subProperties.getProperty("props").asObject());
        } else {
            JSObject oldModel = this.getSubModel(viewId);
            if (oldModel != null) {
                this.recursiveMixin(subProperties, oldModel);
            }
            this.listAdapter.blendSubNode(subProperties);
        }
    }

    @Override
    protected RecyclerView build() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        recyclerView.setAdapter((RecyclerView.Adapter)this.listAdapter);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                final int offsetX = recyclerView.computeHorizontalScrollOffset();
                final int offsetY = recyclerView.computeVerticalScrollOffset();
                for (DoricScrollChangeListener listener : ListNode.this.listeners) {
                    listener.onScrollChange((View)recyclerView, offsetX, offsetY, offsetX - dx, offsetY - dy);
                }
                if (!TextUtils.isEmpty((CharSequence)ListNode.this.onScrollFuncId)) {
                    ListNode.this.jsDispatcher.dispatch(new Callable<AsyncResult>(){

                        @Override
                        public AsyncResult call() throws Exception {
                            return ListNode.this.callJSResponse(ListNode.this.onScrollFuncId, new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(offsetX))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(offsetY))).toJSONObject());
                        }
                    });
                }
            }

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (newState == 0 && !TextUtils.isEmpty((CharSequence)ListNode.this.onScrollEndFuncId)) {
                    int offsetX = recyclerView.computeHorizontalScrollOffset();
                    int offsetY = recyclerView.computeVerticalScrollOffset();
                    ListNode.this.callJSResponse(ListNode.this.onScrollEndFuncId, new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(offsetX))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(offsetY))).toJSONObject());
                }
            }
        });
        return recyclerView;
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        if (this.mView != null) {
            ((RecyclerView)this.mView).post(new Runnable(){

                @Override
                public void run() {
                    ListNode.this.listAdapter.setItemCount(ListNode.this.itemCount + (ListNode.this.loadMore ? 1 : 0));
                    ListNode.this.listAdapter.notifyDataSetChanged();
                }
            });
        }
    }

    @Override
    protected void blend(RecyclerView view, String name, final JSValue prop) {
        switch (name) {
            case "itemCount": {
                if (!prop.isNumber()) {
                    return;
                }
                this.itemCount = prop.asNumber().toInt();
                break;
            }
            case "renderItem": {
                if (!prop.isString()) {
                    return;
                }
                String funcId = prop.asString().value();
                if (funcId.equals(this.renderItemFuncId)) break;
                this.renderItemFuncId = funcId;
                for (int index = 0; index < this.itemValues.size(); ++index) {
                    this.removeSubModel((String)this.itemValues.valueAt(index));
                }
                this.itemValues.clear();
                break;
            }
            case "onLoadMore": {
                this.onLoadMoreFuncId = prop.asString().value();
                break;
            }
            case "loadMoreView": {
                this.loadMoreViewId = prop.asString().value();
                break;
            }
            case "batchCount": {
                this.batchCount = prop.asNumber().toInt();
                break;
            }
            case "loadMore": {
                this.loadMore = prop.asBoolean().value();
                break;
            }
            case "onScroll": {
                if (!prop.isString()) {
                    return;
                }
                this.onScrollFuncId = prop.asString().value();
                break;
            }
            case "onScrollEnd": {
                if (!prop.isString()) {
                    return;
                }
                this.onScrollEndFuncId = prop.asString().value();
                break;
            }
            case "scrolledPosition": {
                if (!prop.isNumber()) {
                    return;
                }
                view.post(new Runnable(){

                    @Override
                    public void run() {
                        ListNode.this.moveToPosition(prop.asNumber().toInt(), false);
                    }
                });
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    @Override
    protected void blendSubLayoutConfig(ViewNode viewNode, JSObject jsObject) {
        super.blendSubLayoutConfig(viewNode, jsObject);
    }

    @Override
    public ViewNode getSubNodeById(String id2) {
        RecyclerView.LayoutManager manager = ((RecyclerView)this.mView).getLayoutManager();
        if (manager == null) {
            return null;
        }
        for (int i = 0; i < manager.getChildCount(); ++i) {
            View view = manager.getChildAt(i);
            if (view == null) continue;
            ListAdapter.DoricViewHolder viewHolder = (ListAdapter.DoricViewHolder)((RecyclerView)this.mView).getChildViewHolder(view);
            if (!id2.equals(viewHolder.listItemNode.getId())) continue;
            return viewHolder.listItemNode;
        }
        return null;
    }

    @Override
    public void addScrollChangeListener(DoricScrollChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeScrollChangeListener(DoricScrollChangeListener listener) {
        this.listeners.remove(listener);
    }

    @DoricMethod
    public void scrollToItem(JSObject params) {
        boolean animated = false;
        if (params.getProperty("animated").isBoolean()) {
            animated = params.getProperty("animated").asBoolean().value();
        }
        JSNumber pos = params.getProperty("index").asNumber();
        this.moveToPosition(pos.toInt(), animated);
    }

    private void moveToPosition(int pos, boolean smooth) {
        if (((RecyclerView)this.mView).getLayoutManager() == null) {
            return;
        }
        if (!(((RecyclerView)this.getView()).getLayoutManager() instanceof LinearLayoutManager)) {
            this.defaultScrollTo(pos, smooth);
            return;
        }
        LinearLayoutManager layoutManager = (LinearLayoutManager)((RecyclerView)this.mView).getLayoutManager();
        int firstItem = layoutManager.findFirstVisibleItemPosition();
        int lastItem = layoutManager.findLastVisibleItemPosition();
        if (pos <= firstItem) {
            this.defaultScrollTo(pos, smooth);
        } else if (pos > lastItem) {
            this.defaultScrollTo(pos, smooth);
        }
    }

    private void defaultScrollTo(int pos, boolean b) {
        if (b) {
            ((RecyclerView)this.mView).smoothScrollToPosition(pos);
        } else {
            ((RecyclerView)this.mView).scrollToPosition(pos);
        }
    }
}

