/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.list;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSNull;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.async.AsyncResult;
import pub.doric.shader.ViewNode;
import pub.doric.shader.list.ListItemNode;
import pub.doric.shader.list.ListNode;

class ListAdapter
extends RecyclerView.Adapter<DoricViewHolder> {
    private final ListNode listNode;
    private int itemCount = 0;
    private int loadAnchor = 0;

    ListAdapter(ListNode listNode) {
        this.listNode = listNode;
    }

    @NonNull
    public DoricViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ListItemNode node = (ListItemNode)ViewNode.create(this.listNode.getDoricContext(), "ListItem");
        node.init(this.listNode);
        return new DoricViewHolder(node, node.getNodeView());
    }

    public void onBindViewHolder(@NonNull DoricViewHolder holder, int position) {
        JSValue jsValue = this.getItemModel(position);
        if (jsValue != null && jsValue.isObject()) {
            JSObject jsObject = jsValue.asObject();
            holder.listItemNode.setId(jsObject.getProperty("id").asString().value());
            holder.listItemNode.blend(jsObject.getProperty("props").asObject());
        }
        if (position >= this.listNode.itemCount && !TextUtils.isEmpty((CharSequence)this.listNode.onLoadMoreFuncId)) {
            this.callLoadMore();
        }
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getItemViewType(int position) {
        if (position >= this.listNode.itemCount) {
            return Integer.MAX_VALUE;
        }
        JSValue value = this.getItemModel(position);
        if (value != null && value.isObject() && value.asObject().getProperty("identifier").isString()) {
            return value.asObject().getProperty("identifier").asString().value().hashCode();
        }
        return super.getItemViewType(position);
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    private JSValue getItemModel(int position) {
        if (position >= this.listNode.itemCount) {
            return this.listNode.getSubModel(this.listNode.loadMoreViewId);
        }
        String id2 = (String)this.listNode.itemValues.get(position);
        if (TextUtils.isEmpty((CharSequence)id2)) {
            int batchCount = this.listNode.batchCount;
            int start = position;
            while (start > 0 && TextUtils.isEmpty((CharSequence)((CharSequence)this.listNode.itemValues.get(start - 1)))) {
                --start;
                ++batchCount;
            }
            AsyncResult<JSDecoder> asyncResult = this.listNode.callJSResponse("renderBunchedItems", start, batchCount);
            try {
                JSDecoder jsDecoder = asyncResult.synchronous().get();
                JSValue result = jsDecoder.decode();
                if (result.isArray()) {
                    JSArray jsArray = result.asArray();
                    for (int i = 0; i < jsArray.size(); ++i) {
                        JSObject itemModel = jsArray.get(i).asObject();
                        String itemId = itemModel.getProperty("id").asString().value();
                        this.listNode.itemValues.put(i + start, (Object)itemId);
                        this.listNode.setSubModel(itemId, itemModel);
                    }
                    return this.listNode.getSubModel((String)this.listNode.itemValues.get(position));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new JSNull();
        }
        JSObject childModel = this.listNode.getSubModel(id2);
        if (childModel == null) {
            return new JSNull();
        }
        return childModel;
    }

    void blendSubNode(JSObject subProperties) {
        for (int i = 0; i < this.listNode.itemValues.size(); ++i) {
            if (!subProperties.getProperty("id").asString().value().equals(this.listNode.itemValues.valueAt(i))) continue;
            this.notifyItemChanged(i);
        }
    }

    private void callLoadMore() {
        if (this.loadAnchor != this.itemCount) {
            this.loadAnchor = this.itemCount;
            this.listNode.callJSResponse(this.listNode.onLoadMoreFuncId, new Object[0]);
        }
    }

    static class DoricViewHolder
    extends RecyclerView.ViewHolder {
        ListItemNode listItemNode;

        DoricViewHolder(ListItemNode node, @NonNull View itemView) {
            super(itemView);
            this.listItemNode = node;
        }
    }
}

