/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.flowlayout;

import android.graphics.Rect;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.DoricScrollChangeListener;
import pub.doric.IDoricScrollable;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;
import pub.doric.shader.flowlayout.FlowAdapter;
import pub.doric.utils.DoricJSDispatcher;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="FlowLayout")
public class FlowLayoutNode
extends SuperNode<RecyclerView>
implements IDoricScrollable {
    private final FlowAdapter flowAdapter;
    private final StaggeredGridLayoutManager staggeredGridLayoutManager = new StaggeredGridLayoutManager(2, 1){

        public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
            try {
                return super.scrollVerticallyBy(dy, recycler, state);
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public void onScrollStateChanged(int state) {
            try {
                super.onScrollStateChanged(state);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private int columnSpace = 0;
    private int rowSpace = 0;
    private Rect padding = new Rect();
    private final RecyclerView.ItemDecoration spacingItemDecoration = new RecyclerView.ItemDecoration(){

        public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
            outRect.set(FlowLayoutNode.this.columnSpace / 2, FlowLayoutNode.this.rowSpace / 2, FlowLayoutNode.this.columnSpace / 2, FlowLayoutNode.this.rowSpace / 2);
        }
    };
    String onLoadMoreFuncId;
    boolean loadMore = false;
    String loadMoreViewId;
    private Set<DoricScrollChangeListener> listeners = new HashSet<DoricScrollChangeListener>();
    private String onScrollFuncId;
    private String onScrollEndFuncId;
    private DoricJSDispatcher jsDispatcher = new DoricJSDispatcher();
    private int itemCount = 0;

    public FlowLayoutNode(DoricContext doricContext) {
        super(doricContext);
        this.flowAdapter = new FlowAdapter(this);
    }

    @Override
    public ViewNode getSubNodeById(String id2) {
        RecyclerView.LayoutManager manager = ((RecyclerView)this.mView).getLayoutManager();
        if (manager == null) {
            return null;
        }
        for (int i = 0; i < manager.getChildCount(); ++i) {
            View view = manager.getChildAt(i);
            if (view == null) continue;
            FlowAdapter.DoricViewHolder viewHolder = (FlowAdapter.DoricViewHolder)((RecyclerView)this.mView).getChildViewHolder(view);
            if (!id2.equals(viewHolder.flowLayoutItemNode.getId())) continue;
            return viewHolder.flowLayoutItemNode;
        }
        return null;
    }

    @Override
    protected void blend(RecyclerView view, String name, JSValue prop) {
        switch (name) {
            case "columnSpace": {
                if (!prop.isNumber()) {
                    return;
                }
                this.columnSpace = DoricUtils.dp2px(prop.asNumber().toFloat());
                break;
            }
            case "rowSpace": {
                if (!prop.isNumber()) {
                    return;
                }
                this.rowSpace = DoricUtils.dp2px(prop.asNumber().toFloat());
                break;
            }
            case "columnCount": {
                if (!prop.isNumber()) {
                    return;
                }
                this.staggeredGridLayoutManager.setSpanCount(prop.asNumber().toInt());
                break;
            }
            case "itemCount": {
                if (!prop.isNumber()) {
                    return;
                }
                this.itemCount = prop.asNumber().toInt();
                break;
            }
            case "renderItem": {
                if (!prop.isString()) {
                    return;
                }
                String funcId = prop.asString().value();
                if (funcId.equals(this.flowAdapter.renderItemFuncId)) break;
                this.flowAdapter.renderItemFuncId = funcId;
                for (int index = 0; index < this.flowAdapter.itemValues.size(); ++index) {
                    this.removeSubModel((String)this.flowAdapter.itemValues.valueAt(index));
                }
                this.flowAdapter.itemValues.clear();
                break;
            }
            case "batchCount": {
                if (!prop.isNumber()) {
                    return;
                }
                this.flowAdapter.batchCount = prop.asNumber().toInt();
                break;
            }
            case "onLoadMore": {
                if (!prop.isString()) {
                    return;
                }
                this.onLoadMoreFuncId = prop.asString().value();
                break;
            }
            case "loadMoreView": {
                if (!prop.isString()) {
                    return;
                }
                this.loadMoreViewId = prop.asString().value();
                break;
            }
            case "loadMore": {
                if (!prop.isBoolean()) {
                    return;
                }
                this.loadMore = prop.asBoolean().value();
                break;
            }
            case "onScroll": {
                if (!prop.isString()) {
                    return;
                }
                this.onScrollFuncId = prop.asString().value();
                break;
            }
            case "onScrollEnd": {
                if (!prop.isString()) {
                    return;
                }
                this.onScrollEndFuncId = prop.asString().value();
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    @Override
    protected void setPadding(JSObject jsObject) {
        JSValue left = jsObject.getProperty("left");
        JSValue right = jsObject.getProperty("right");
        JSValue top = jsObject.getProperty("top");
        JSValue bottom = jsObject.getProperty("bottom");
        this.padding.left = left.isNumber() ? DoricUtils.dp2px(left.asNumber().toFloat()) : 0;
        this.padding.top = top.isNumber() ? DoricUtils.dp2px(top.asNumber().toFloat()) : 0;
        this.padding.right = right.isNumber() ? DoricUtils.dp2px(right.asNumber().toFloat()) : 0;
        this.padding.bottom = bottom.isNumber() ? DoricUtils.dp2px(bottom.asNumber().toFloat()) : 0;
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        ((RecyclerView)this.mView).setPadding(this.padding.left - this.columnSpace / 2, this.padding.top - this.rowSpace / 2, this.padding.right - this.columnSpace / 2, this.padding.bottom - this.rowSpace / 2);
        if (this.mView != null) {
            ((RecyclerView)this.mView).post(new Runnable(){

                @Override
                public void run() {
                    ((FlowLayoutNode)FlowLayoutNode.this).flowAdapter.itemCount = FlowLayoutNode.this.itemCount;
                    FlowLayoutNode.this.flowAdapter.notifyDataSetChanged();
                }
            });
        }
    }

    @Override
    protected void blendSubNode(JSObject subProperties) {
        String viewId = subProperties.getProperty("id").asString().value();
        ViewNode node = this.getSubNodeById(viewId);
        if (node != null) {
            node.blend(subProperties.getProperty("props").asObject());
        } else {
            JSObject oldModel = this.getSubModel(viewId);
            if (oldModel != null) {
                this.recursiveMixin(subProperties, oldModel);
            }
            this.flowAdapter.blendSubNode(subProperties);
        }
    }

    @Override
    protected RecyclerView build() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.staggeredGridLayoutManager);
        recyclerView.setAdapter((RecyclerView.Adapter)this.flowAdapter);
        recyclerView.addItemDecoration(this.spacingItemDecoration);
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                final int offsetX = recyclerView.computeHorizontalScrollOffset();
                final int offsetY = recyclerView.computeVerticalScrollOffset();
                for (DoricScrollChangeListener listener : FlowLayoutNode.this.listeners) {
                    listener.onScrollChange((View)recyclerView, offsetX, offsetY, offsetX - dx, offsetY - dy);
                }
                if (!TextUtils.isEmpty((CharSequence)FlowLayoutNode.this.onScrollFuncId)) {
                    FlowLayoutNode.this.jsDispatcher.dispatch(new Callable<AsyncResult>(){

                        @Override
                        public AsyncResult call() throws Exception {
                            return FlowLayoutNode.this.callJSResponse(FlowLayoutNode.this.onScrollFuncId, new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(offsetX))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(offsetY))).toJSONObject());
                        }
                    });
                }
            }

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (newState == 0 && !TextUtils.isEmpty((CharSequence)FlowLayoutNode.this.onScrollEndFuncId)) {
                    int offsetX = recyclerView.computeHorizontalScrollOffset();
                    int offsetY = recyclerView.computeVerticalScrollOffset();
                    FlowLayoutNode.this.callJSResponse(FlowLayoutNode.this.onScrollEndFuncId, new JSONBuilder().put("x", (Object)Float.valueOf(DoricUtils.px2dp(offsetX))).put("y", (Object)Float.valueOf(DoricUtils.px2dp(offsetY))).toJSONObject());
                }
            }
        });
        return recyclerView;
    }

    @Override
    public void addScrollChangeListener(DoricScrollChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeScrollChangeListener(DoricScrollChangeListener listener) {
        this.listeners.remove(listener);
    }
}

