/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.flowlayout;

import android.text.TextUtils;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSNull;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.async.AsyncResult;
import pub.doric.shader.ViewNode;
import pub.doric.shader.flowlayout.FlowLayoutItemNode;
import pub.doric.shader.flowlayout.FlowLayoutNode;

class FlowAdapter
extends RecyclerView.Adapter<DoricViewHolder> {
    private final FlowLayoutNode flowLayoutNode;
    String renderItemFuncId;
    int itemCount = 0;
    int batchCount = 15;
    SparseArray<String> itemValues = new SparseArray();
    private int loadAnchor = 0;

    FlowAdapter(FlowLayoutNode flowLayoutNode) {
        this.flowLayoutNode = flowLayoutNode;
    }

    @NonNull
    public DoricViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        FlowLayoutItemNode node = (FlowLayoutItemNode)ViewNode.create(this.flowLayoutNode.getDoricContext(), "FlowLayoutItem");
        node.init(this.flowLayoutNode);
        return new DoricViewHolder(node, node.getNodeView());
    }

    public void onBindViewHolder(@NonNull DoricViewHolder holder, int position) {
        JSValue jsValue = this.getItemModel(position);
        if (jsValue.isObject()) {
            JSObject jsObject = jsValue.asObject();
            holder.flowLayoutItemNode.setId(jsObject.getProperty("id").asString().value());
            holder.flowLayoutItemNode.blend(jsObject.getProperty("props").asObject());
        }
        if (position >= this.itemCount && !TextUtils.isEmpty((CharSequence)this.flowLayoutNode.onLoadMoreFuncId)) {
            this.callLoadMore();
            StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-1, holder.itemView.getLayoutParams().height);
            layoutParams.setFullSpan(true);
            holder.itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public int getItemCount() {
        return this.itemCount + (this.flowLayoutNode.loadMore ? 1 : 0);
    }

    public int getItemViewType(int position) {
        if (position >= this.itemCount) {
            return Integer.MAX_VALUE;
        }
        JSValue value = this.getItemModel(position);
        if (value.isObject() && value.asObject().getProperty("identifier").isString()) {
            return value.asObject().getProperty("identifier").asString().value().hashCode();
        }
        return super.getItemViewType(position);
    }

    private JSValue getItemModel(int position) {
        if (position >= this.itemCount) {
            return this.flowLayoutNode.getSubModel(this.flowLayoutNode.loadMoreViewId);
        }
        String id2 = (String)this.itemValues.get(position);
        if (TextUtils.isEmpty((CharSequence)id2)) {
            AsyncResult<JSDecoder> asyncResult = this.flowLayoutNode.callJSResponse("renderBunchedItems", position, this.batchCount);
            try {
                JSDecoder jsDecoder = asyncResult.synchronous().get();
                JSValue result = jsDecoder.decode();
                if (result.isArray()) {
                    JSArray jsArray = result.asArray();
                    for (int i = 0; i < jsArray.size(); ++i) {
                        JSObject itemModel = jsArray.get(i).asObject();
                        String itemId = itemModel.getProperty("id").asString().value();
                        this.itemValues.put(i + position, (Object)itemId);
                        this.flowLayoutNode.setSubModel(itemId, itemModel);
                    }
                    return this.flowLayoutNode.getSubModel((String)this.itemValues.get(position));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new JSNull();
        }
        JSObject childModel = this.flowLayoutNode.getSubModel(id2);
        if (childModel == null) {
            return new JSNull();
        }
        return childModel;
    }

    void blendSubNode(JSObject subProperties) {
        for (int i = 0; i < this.itemValues.size(); ++i) {
            if (!subProperties.getProperty("id").asString().value().equals(this.itemValues.valueAt(i))) continue;
            this.notifyItemChanged(i);
        }
    }

    private void callLoadMore() {
        if (this.loadAnchor != this.itemCount) {
            this.loadAnchor = this.itemCount;
            this.flowLayoutNode.callJSResponse(this.flowLayoutNode.onLoadMoreFuncId, new Object[0]);
        }
    }

    static class DoricViewHolder
    extends RecyclerView.ViewHolder {
        FlowLayoutItemNode flowLayoutItemNode;

        DoricViewHolder(FlowLayoutItemNode node, @NonNull View itemView) {
            super(itemView);
            this.flowLayoutItemNode = node;
        }
    }
}

