/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader.flex;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaDisplay;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaOverflow;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaWrap;
import com.facebook.yoga.android.YogaLayout;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.DoricContext;
import pub.doric.R;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.GroupNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricLog;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="FlexLayout")
public class FlexNode
extends GroupNode<YogaLayout> {
    private static final int FLEX_VALUE_TYPE_POINT = 1;
    private static final int FLEX_VALUE_TYPE_PERCENT = 2;
    private static final int FLEX_VALUE_TYPE_AUTO = 3;

    public FlexNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected YogaLayout build() {
        return new YogaLayout(this.getContext()){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    ViewNode childNode = (ViewNode)child.getTag(R.id.doric_node);
                    if (childNode == null) continue;
                    ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                    int childWidthMeasureSpec = layoutParams.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)Integer.MIN_VALUE) : (layoutParams.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredHeight(), (int)0) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000));
                    int childHeightMeasureSpec = layoutParams.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)0, (int)Integer.MIN_VALUE) : (layoutParams.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)0, (int)0) : View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000));
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    YogaNode node = this.getYogaNodeForView(child);
                    if (node == null) continue;
                    JSObject flexConfig = childNode.getFlexConfig();
                    YogaUnit widthUnit = YogaUnit.AUTO;
                    YogaUnit heightUnit = YogaUnit.AUTO;
                    if (flexConfig != null) {
                        JSValue typeValue;
                        JSValue typeValue2;
                        JSValue widthValue = flexConfig.getProperty("width");
                        if (widthValue.isNumber()) {
                            widthUnit = YogaUnit.POINT;
                        } else if (widthValue.isObject() && (typeValue2 = widthValue.asObject().getProperty("type")).isNumber()) {
                            widthUnit = YogaUnit.fromInt((int)typeValue2.asNumber().toInt());
                        }
                        JSValue heightValue = flexConfig.getProperty("height");
                        if (heightValue.isNumber()) {
                            heightUnit = YogaUnit.POINT;
                        } else if (heightValue.isObject() && (typeValue = heightValue.asObject().getProperty("type")).isNumber()) {
                            heightUnit = YogaUnit.fromInt((int)typeValue.asNumber().toInt());
                        }
                    }
                    if (widthUnit == YogaUnit.AUTO) {
                        node.setWidth((float)childNode.getView().getMeasuredWidth());
                    }
                    if (heightUnit != YogaUnit.AUTO) continue;
                    node.setHeight((float)childNode.getView().getMeasuredHeight());
                }
                YogaUnit widthUnit = YogaUnit.AUTO;
                YogaUnit heightUnit = YogaUnit.AUTO;
                JSObject flexConfig = FlexNode.this.getFlexConfig();
                if (flexConfig != null) {
                    JSValue typeValue;
                    JSValue typeValue3;
                    JSValue widthValue = flexConfig.getProperty("width");
                    if (widthValue.isNumber()) {
                        widthUnit = YogaUnit.POINT;
                    } else if (widthValue.isObject() && (typeValue3 = widthValue.asObject().getProperty("type")).isNumber()) {
                        widthUnit = YogaUnit.fromInt((int)typeValue3.asNumber().toInt());
                    }
                    JSValue heightValue = flexConfig.getProperty("height");
                    if (heightValue.isNumber()) {
                        heightUnit = YogaUnit.POINT;
                    } else if (heightValue.isObject() && (typeValue = heightValue.asObject().getProperty("type")).isNumber()) {
                        heightUnit = YogaUnit.fromInt((int)typeValue.asNumber().toInt());
                    }
                }
                if (widthUnit == YogaUnit.AUTO) {
                    this.getYogaNode().setWidthAuto();
                }
                if (heightUnit == YogaUnit.AUTO) {
                    this.getYogaNode().setHeightAuto();
                }
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        };
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new YogaLayout.LayoutParams(-1, -1);
    }

    @Override
    protected void blendSubLayoutConfig(ViewNode viewNode, JSObject jsObject) {
        super.blendSubLayoutConfig(viewNode, jsObject);
    }

    @Override
    protected void blend(YogaLayout view, String name, JSValue prop) {
        if ("flexConfig".equals(name)) {
            this.blendSubFlexConfig(((YogaLayout)this.mView).getYogaNode(), prop.asObject());
            this.mFlexConfig = prop.asObject();
        } else {
            super.blend(view, name, prop);
        }
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        for (ViewNode childNode : this.mChildNodes) {
            YogaNode yogaNode = ((YogaLayout)this.mView).getYogaNodeForView(childNode.getNodeView());
            if (yogaNode == null) continue;
            this.blendSubFlexConfig(yogaNode, childNode.getFlexConfig());
        }
    }

    private void blendSubFlexConfig(YogaNode yogaNode, JSObject jsObject) {
        if (jsObject != null) {
            for (String name : jsObject.propertySet()) {
                JSValue value = jsObject.getProperty(name);
                this.blendFlexConfig(yogaNode, name, value);
            }
        }
    }

    private void blendFlexConfig(final YogaNode yogaNode, String name, JSValue value) {
        switch (name) {
            case "direction": {
                yogaNode.setDirection(YogaDirection.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "flexDirection": {
                yogaNode.setFlexDirection(YogaFlexDirection.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "justifyContent": {
                yogaNode.setJustifyContent(YogaJustify.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "alignContent": {
                yogaNode.setAlignContent(YogaAlign.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "alignItems": {
                yogaNode.setAlignItems(YogaAlign.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "alignSelf": {
                yogaNode.setAlignSelf(YogaAlign.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "positionType": {
                yogaNode.setPositionType(YogaPositionType.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "flexWrap": {
                yogaNode.setWrap(YogaWrap.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "overFlow": {
                yogaNode.setOverflow(YogaOverflow.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "display": {
                yogaNode.setDisplay(YogaDisplay.fromInt((int)value.asNumber().toInt()));
                break;
            }
            case "flex": {
                yogaNode.setFlex(value.asNumber().toFloat());
                break;
            }
            case "flexGrow": {
                yogaNode.setFlexGrow(value.asNumber().toFloat());
                break;
            }
            case "flexShrink": {
                yogaNode.setFlexShrink(value.asNumber().toFloat());
                break;
            }
            case "flexBasis": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setFlexBasis(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setFlexBasisPercent(v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setFlexBasisAuto();
                    }
                });
                break;
            }
            case "marginLeft": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.LEFT, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.LEFT, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.LEFT);
                    }
                });
                break;
            }
            case "marginRight": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.RIGHT, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.RIGHT, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.RIGHT);
                    }
                });
                break;
            }
            case "marginTop": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.TOP, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.TOP, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.TOP);
                    }
                });
                break;
            }
            case "marginBottom": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.BOTTOM, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.BOTTOM, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.BOTTOM);
                    }
                });
                break;
            }
            case "marginStart": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.START, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.START, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.START);
                    }
                });
                break;
            }
            case "marginEnd": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.END, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.END, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.END);
                    }
                });
                break;
            }
            case "marginHorizontal": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.HORIZONTAL, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.HORIZONTAL, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.HORIZONTAL);
                    }
                });
                break;
            }
            case "marginVertical": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.VERTICAL, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.VERTICAL, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.VERTICAL);
                    }
                });
                break;
            }
            case "margin": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMargin(YogaEdge.ALL, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMarginPercent(YogaEdge.ALL, v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setMarginAuto(YogaEdge.ALL);
                    }
                });
                break;
            }
            case "paddingLeft": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.LEFT, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.LEFT, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingRight": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.RIGHT, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.RIGHT, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingTop": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.TOP, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.TOP, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingBottom": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.BOTTOM, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.BOTTOM, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingStart": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.START, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.START, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingEnd": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.END, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.END, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingHorizontal": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.HORIZONTAL, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.HORIZONTAL, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "paddingVertical": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.VERTICAL, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.VERTICAL, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "padding": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPadding(YogaEdge.ALL, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPaddingPercent(YogaEdge.ALL, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "borderLeftWidth": {
                yogaNode.setBorder(YogaEdge.LEFT, value.asNumber().toFloat());
                break;
            }
            case "borderRightWidth": {
                yogaNode.setBorder(YogaEdge.RIGHT, value.asNumber().toFloat());
                break;
            }
            case "borderTopWidth": {
                yogaNode.setBorder(YogaEdge.TOP, value.asNumber().toFloat());
                break;
            }
            case "borderBottomWidth": {
                yogaNode.setBorder(YogaEdge.BOTTOM, value.asNumber().toFloat());
                break;
            }
            case "borderStartWidth": {
                yogaNode.setBorder(YogaEdge.START, value.asNumber().toFloat());
                break;
            }
            case "borderEndWidth": {
                yogaNode.setBorder(YogaEdge.END, value.asNumber().toFloat());
                break;
            }
            case "borderWidth": {
                yogaNode.setBorder(YogaEdge.ALL, value.asNumber().toFloat());
                break;
            }
            case "left": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPosition(YogaEdge.LEFT, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPositionPercent(YogaEdge.LEFT, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "right": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPosition(YogaEdge.RIGHT, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPositionPercent(YogaEdge.RIGHT, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "top": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPosition(YogaEdge.TOP, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPositionPercent(YogaEdge.TOP, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "bottom": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPosition(YogaEdge.BOTTOM, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPositionPercent(YogaEdge.BOTTOM, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "start": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPosition(YogaEdge.START, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPositionPercent(YogaEdge.START, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "end": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setPosition(YogaEdge.END, v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setPositionPercent(YogaEdge.END, v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "width": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setWidth(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setWidthPercent(v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setWidthAuto();
                    }
                });
                break;
            }
            case "height": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setHeight(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setHeightPercent(v);
                    }

                    @Override
                    public void setAuto() {
                        yogaNode.setHeightAuto();
                    }
                });
                break;
            }
            case "minWidth": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMinWidth(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMinHeightPercent(v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "minHeight": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMinHeight(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMinHeightPercent(v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "maxWidth": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMaxWidth(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMaxWidthPercent(v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "maxHeight": {
                this.setYogaValue(value, new YogaSetting(){

                    @Override
                    public void setPoint(float v) {
                        yogaNode.setMaxHeight(v);
                    }

                    @Override
                    public void setPercent(float v) {
                        yogaNode.setMaxHeightPercent(v);
                    }

                    @Override
                    public void setAuto() {
                    }
                });
                break;
            }
            case "aspectRatio": {
                yogaNode.setAspectRatio(value.asNumber().toFloat());
                break;
            }
            default: {
                DoricLog.e("Cannot find flex config", name);
            }
        }
    }

    private void setYogaValue(JSValue value, YogaSetting setting) {
        if (value.isNumber()) {
            setting.setPoint(DoricUtils.dp2px(value.asNumber().toFloat()));
        } else if (value.isObject()) {
            JSValue jsType = value.asObject().getProperty("type");
            JSValue jsValue = value.asObject().getProperty("value");
            if (jsType.isNumber()) {
                switch (jsType.asNumber().toInt()) {
                    case 1: {
                        setting.setPoint(DoricUtils.dp2px(jsValue.asNumber().toFloat()));
                        break;
                    }
                    case 2: {
                        setting.setPercent(jsValue.asNumber().toFloat());
                        break;
                    }
                    default: {
                        setting.setAuto();
                    }
                }
            }
        }
    }

    private static interface YogaSetting {
        public void setPoint(float var1);

        public void setPercent(float var1);

        public void setAuto();
    }
}

