/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.TextUtils;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.ViewNode;
import pub.doric.shader.richtext.CustomTagHandler;
import pub.doric.shader.richtext.HtmlParser;
import pub.doric.utils.DoricLog;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="Text")
public class TextNode
extends ViewNode<TextView> {
    public TextNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected TextView build() {
        TextView tv = new TextView(this.getContext());
        tv.setGravity(17);
        tv.setMaxLines(1);
        tv.setSingleLine(true);
        tv.setEllipsize(TextUtils.TruncateAt.END);
        tv.setIncludeFontPadding(false);
        return tv;
    }

    @Override
    protected void blendLayoutConfig(JSObject jsObject) {
        JSValue maxHeight;
        super.blendLayoutConfig(jsObject);
        JSValue maxWidth = jsObject.getProperty("maxWidth");
        if (maxWidth.isNumber()) {
            ((TextView)this.mView).setMaxWidth(DoricUtils.dp2px(maxWidth.asNumber().toFloat()));
        }
        if ((maxHeight = jsObject.getProperty("maxHeight")).isNumber()) {
            ((TextView)this.mView).setMaxHeight(DoricUtils.dp2px(maxWidth.asNumber().toFloat()));
        }
    }

    @Override
    protected void blend(TextView view, String name, JSValue prop) {
        block19 : switch (name) {
            case "text": {
                if (!prop.isString()) {
                    return;
                }
                view.setText((CharSequence)prop.asString().toString());
                break;
            }
            case "textSize": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setTextSize(1, prop.asNumber().toFloat());
                break;
            }
            case "textColor": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setTextColor(prop.asNumber().toInt());
                break;
            }
            case "textAlignment": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setGravity(prop.asNumber().toInt() | 0x10);
                break;
            }
            case "maxLines": {
                int line = prop.asNumber().toInt();
                if (line <= 0) {
                    line = Integer.MAX_VALUE;
                }
                view.setSingleLine(line == 1);
                view.setMaxLines(line);
                break;
            }
            case "fontStyle": {
                if (prop.isString()) {
                    if ("bold".equals(prop.asString().value())) {
                        view.setTypeface(Typeface.defaultFromStyle((int)1));
                        break;
                    }
                    if ("italic".equals(prop.asString().value())) {
                        view.setTypeface(Typeface.defaultFromStyle((int)2));
                        break;
                    }
                    if ("bold_italic".equals(prop.asString().value())) {
                        view.setTypeface(Typeface.defaultFromStyle((int)3));
                        break;
                    }
                    view.setTypeface(Typeface.defaultFromStyle((int)0));
                    break;
                }
                view.setTypeface(Typeface.defaultFromStyle((int)0));
                break;
            }
            case "font": {
                int resId;
                if (!prop.isString()) {
                    return;
                }
                String font = prop.asString().toString();
                String fontPath = "";
                String fontName = font;
                if (font.contains("/")) {
                    int separatorIndex = font.lastIndexOf("/");
                    fontPath = font.substring(0, separatorIndex + 1);
                    fontName = font.substring(separatorIndex + 1);
                }
                if (fontName.endsWith(".ttf")) {
                    fontName = fontName.replace(".ttf", "");
                }
                if ((resId = this.getContext().getResources().getIdentifier(fontName.toLowerCase(), "font", this.getContext().getPackageName())) > 0) {
                    try {
                        Typeface iconFont = ResourcesCompat.getFont((Context)this.getContext(), (int)resId);
                        view.setTypeface(iconFont);
                    }
                    catch (Exception e) {
                        DoricLog.e("Error Font asset  " + font + " in res/font", new Object[0]);
                    }
                    break;
                }
                fontName = fontPath + fontName + ".ttf";
                try {
                    Typeface iconFont = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)fontName);
                    view.setTypeface(iconFont);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DoricLog.e(font + " not found in Assets", new Object[0]);
                }
                break;
            }
            case "maxWidth": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setMaxWidth(DoricUtils.dp2px(prop.asNumber().toFloat()));
                break;
            }
            case "maxHeight": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setMaxHeight(DoricUtils.dp2px(prop.asNumber().toFloat()));
                break;
            }
            case "lineSpacing": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setLineSpacing((float)DoricUtils.dp2px(prop.asNumber().toFloat()), 1.0f);
                break;
            }
            case "strikethrough": {
                if (!prop.isBoolean()) break;
                view.getPaint().setStrikeThruText(prop.asBoolean().value().booleanValue());
                break;
            }
            case "underline": {
                if (!prop.isBoolean()) break;
                view.getPaint().setUnderlineText(prop.asBoolean().value().booleanValue());
                break;
            }
            case "htmlText": {
                if (!prop.isString()) break;
                view.setText((CharSequence)HtmlParser.buildSpannedText(prop.asString().value(), new Html.ImageGetter(){

                    public Drawable getDrawable(String source) {
                        return null;
                    }
                }, new CustomTagHandler()));
                break;
            }
            case "truncateAt": {
                if (!prop.isNumber()) break;
                switch (prop.asNumber().toInt()) {
                    case 1: {
                        view.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                        break block19;
                    }
                    case 2: {
                        view.setEllipsize(TextUtils.TruncateAt.START);
                        break block19;
                    }
                    case 3: {
                        view.setEllipsize(null);
                        break block19;
                    }
                }
                view.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case "shadow": {
                if (!prop.isObject()) break;
                ((TextView)this.mView).setAlpha(prop.asObject().getProperty("opacity").asNumber().toFloat());
                ((TextView)this.mView).setShadowLayer(prop.asObject().getProperty("radius").asNumber().toFloat(), (float)DoricUtils.dp2px(prop.asObject().getProperty("offsetX").asNumber().toFloat()), (float)DoricUtils.dp2px(prop.asObject().getProperty("offsetY").asNumber().toFloat()), prop.asObject().getProperty("color").asNumber().toInt());
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }
}

