/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import java.util.ArrayList;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.GroupNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="Stack")
public class StackNode
extends GroupNode<FrameLayout> {
    public StackNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected void blendLayoutConfig(JSObject jsObject) {
        JSValue maxHeight;
        super.blendLayoutConfig(jsObject);
        JSValue maxWidth = jsObject.getProperty("maxWidth");
        if (maxWidth.isNumber()) {
            ((MaximumFrameLayout)this.mView).maxWidth = DoricUtils.dp2px(maxWidth.asNumber().toFloat());
        }
        if ((maxHeight = jsObject.getProperty("maxHeight")).isNumber()) {
            ((MaximumFrameLayout)this.mView).maxHeight = DoricUtils.dp2px(maxHeight.asNumber().toFloat());
        }
    }

    @Override
    protected void blendSubLayoutConfig(ViewNode viewNode, JSObject jsObject) {
        super.blendSubLayoutConfig(viewNode, jsObject);
        JSValue jsValue = jsObject.getProperty("alignment");
        if (jsValue.isNumber()) {
            ((FrameLayout.LayoutParams)viewNode.getLayoutParams()).gravity = jsValue.asNumber().toInt();
        }
    }

    @Override
    protected FrameLayout build() {
        return new MaximumFrameLayout(this.getContext());
    }

    @Override
    protected void blend(FrameLayout view, String name, JSValue prop) {
        super.blend(view, name, prop);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(0, 0);
    }

    private static class MaximumFrameLayout
    extends FrameLayout {
        private int maxWidth = Integer.MAX_VALUE;
        private int maxHeight = Integer.MAX_VALUE;
        private final ArrayList<View> mMatchParentChildren = new ArrayList(1);

        public MaximumFrameLayout(Context context) {
            super(context);
        }

        int getPaddingLeftWithForeground() {
            return this.getPaddingLeft();
        }

        int getPaddingRightWithForeground() {
            return this.getPaddingRight();
        }

        private int getPaddingTopWithForeground() {
            return this.getPaddingTop();
        }

        private int getPaddingBottomWithForeground() {
            return this.getPaddingBottom();
        }

        private void rawOnMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int count = this.getChildCount();
            boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
            this.mMatchParentChildren.clear();
            int maxHeight = 0;
            int maxWidth = 0;
            int childState = 0;
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                if (!this.getMeasureAllChildren() && child.getVisibility() == 8) continue;
                this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
                maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
                childState = MaximumFrameLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
                if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
                this.mMatchParentChildren.add(child);
            }
            maxWidth += this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground();
            maxHeight += this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground();
            maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
            maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
            Drawable drawable = this.getForeground();
            if (drawable != null) {
                maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
                maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
            }
            this.setMeasuredDimension(MaximumFrameLayout.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), MaximumFrameLayout.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
            count = this.mMatchParentChildren.size();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    int childHeightMeasureSpec;
                    int childWidthMeasureSpec;
                    View child = this.mMatchParentChildren.get(i);
                    ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                    if (lp.width == -1) {
                        int width = Math.max(0, this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - lp.leftMargin - lp.rightMargin);
                        childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                    } else {
                        childWidthMeasureSpec = MaximumFrameLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + lp.leftMargin + lp.rightMargin), (int)lp.width);
                    }
                    if (lp.height == -1) {
                        int height = Math.max(0, this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - lp.topMargin - lp.bottomMargin);
                        childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                    } else {
                        childHeightMeasureSpec = MaximumFrameLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + lp.topMargin + lp.bottomMargin), (int)lp.height);
                    }
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                }
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.rawOnMeasure(widthMeasureSpec, heightMeasureSpec);
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            if (width > this.maxWidth || height > this.maxHeight) {
                width = Math.min(width, this.maxWidth);
                height = Math.min(height, this.maxHeight);
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
                this.rawOnMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }
}

