/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import pub.doric.DoricContext;
import pub.doric.shader.GroupNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricUtils;

public class LinearNode
extends GroupNode<LinearLayout> {
    public LinearNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected void blendLayoutConfig(JSObject jsObject) {
        JSValue maxHeight;
        super.blendLayoutConfig(jsObject);
        JSValue maxWidth = jsObject.getProperty("maxWidth");
        if (maxWidth.isNumber()) {
            ((MaximumLinearLayout)this.mView).maxWidth = DoricUtils.dp2px(maxWidth.asNumber().toFloat());
        }
        if ((maxHeight = jsObject.getProperty("maxHeight")).isNumber()) {
            ((MaximumLinearLayout)this.mView).maxHeight = DoricUtils.dp2px(maxHeight.asNumber().toFloat());
        }
    }

    @Override
    protected void blendSubLayoutConfig(ViewNode viewNode, JSObject layoutConfig) {
        JSValue weight;
        super.blendSubLayoutConfig(viewNode, layoutConfig);
        JSValue jsValue = layoutConfig.getProperty("alignment");
        if (jsValue.isNumber()) {
            ((LinearLayout.LayoutParams)viewNode.getLayoutParams()).gravity = jsValue.asNumber().toInt();
        }
        if ((weight = layoutConfig.getProperty("weight")).isNumber()) {
            ((LinearLayout.LayoutParams)viewNode.getLayoutParams()).weight = weight.asNumber().toInt();
        }
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LinearLayout.LayoutParams(0, 0);
    }

    @Override
    protected LinearLayout build() {
        MaximumLinearLayout linearLayout = new MaximumLinearLayout(this.getContext());
        linearLayout.setBaselineAligned(false);
        return linearLayout;
    }

    @Override
    protected void blend(LinearLayout view, String name, JSValue prop) {
        switch (name) {
            case "space": {
                ShapeDrawable shapeDrawable;
                if (!prop.isNumber()) {
                    return;
                }
                if (view.getDividerDrawable() == null) {
                    shapeDrawable = new ShapeDrawable();
                    shapeDrawable.setAlpha(0);
                    view.setShowDividers(2);
                } else {
                    shapeDrawable = (ShapeDrawable)view.getDividerDrawable();
                    view.setDividerDrawable(null);
                }
                if (view.getOrientation() == 1) {
                    shapeDrawable.setIntrinsicHeight(DoricUtils.dp2px(prop.asNumber().toFloat()));
                } else {
                    shapeDrawable.setIntrinsicWidth(DoricUtils.dp2px(prop.asNumber().toFloat()));
                }
                view.setDividerDrawable((Drawable)shapeDrawable);
                break;
            }
            case "gravity": {
                if (!prop.isNumber()) {
                    return;
                }
                view.setGravity(prop.asNumber().toInt());
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    private static class MaximumLinearLayout
    extends LinearLayout {
        private int maxWidth = Integer.MAX_VALUE;
        private int maxHeight = Integer.MAX_VALUE;

        public MaximumLinearLayout(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int width = this.getMeasuredWidth();
            int height = this.getMeasuredHeight();
            if (width > this.maxWidth || height > this.maxHeight) {
                width = Math.min(width, this.maxWidth);
                height = Math.min(height, this.maxHeight);
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }
}

