/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.LinkedList;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.shader.ViewNode;

@DoricPlugin(name="Input")
public class InputNode
extends ViewNode<EditText>
implements TextWatcher,
View.OnFocusChangeListener {
    private final InputMethodManager mInputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
    private String onTextChangeId;
    private String onFocusChangeId;

    public InputNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected EditText build() {
        EditText editText = new EditText(this.getContext());
        editText.addTextChangedListener((TextWatcher)this);
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        editText.setBackground(null);
        editText.setGravity(0x800033);
        return editText;
    }

    @Override
    protected void blend(EditText view, String name, JSValue prop) {
        switch (name) {
            case "maxLength": {
                InputFilter[] currentFilters = view.getFilters();
                LinkedList<Object> list = new LinkedList<Object>();
                for (int i = 0; i < currentFilters.length; ++i) {
                    if (currentFilters[i] instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilters[i]);
                }
                if (prop.isNumber()) {
                    list.add(new InputFilter.LengthFilter(prop.asNumber().toInt()));
                }
                InputFilter[] newFilters = list.toArray(new InputFilter[list.size()]);
                view.setFilters(newFilters);
                break;
            }
            case "text": {
                view.setText((CharSequence)prop.asString().toString());
                break;
            }
            case "textSize": {
                view.setTextSize(1, prop.asNumber().toFloat());
                break;
            }
            case "textColor": {
                view.setTextColor(prop.asNumber().toInt());
                break;
            }
            case "textAlignment": {
                view.setGravity(prop.asNumber().toInt());
                break;
            }
            case "hintText": {
                view.setHint((CharSequence)prop.asString().toString());
                break;
            }
            case "hintTextColor": {
                view.setHintTextColor(prop.asNumber().toInt());
                break;
            }
            case "multiline": {
                if (prop.asBoolean().value().booleanValue()) {
                    view.setInputType(view.getInputType() | 0x20000);
                    break;
                }
                view.setInputType(view.getInputType() & 0xFFFDFFFF);
                break;
            }
            case "onTextChange": {
                if (prop.isString()) {
                    this.onTextChangeId = prop.asString().value();
                    break;
                }
                this.onTextChangeId = null;
                break;
            }
            case "onFocusChange": {
                if (prop.isString()) {
                    this.onFocusChangeId = prop.asString().value();
                    break;
                }
                this.onFocusChangeId = null;
                break;
            }
            case "inputType": {
                int inputType;
                if (!prop.isNumber()) break;
                int variation = ((EditText)this.mView).getInputType() & 0xFFF;
                boolean isPassword = variation == 129 || variation == 225 || variation == 18;
                switch (prop.asNumber().toInt()) {
                    case 1: {
                        inputType = 2;
                        if (!isPassword) break;
                        inputType |= 0x10;
                        break;
                    }
                    case 2: {
                        inputType = 8194;
                        if (!isPassword) break;
                        inputType |= 0x10;
                        break;
                    }
                    case 3: {
                        inputType = 33;
                        if (!isPassword) break;
                        inputType |= 0x80;
                        break;
                    }
                    case 4: {
                        inputType = 3;
                        if (!isPassword) break;
                        inputType |= 0x10;
                        break;
                    }
                    default: {
                        inputType = 1;
                        if (!isPassword) break;
                        inputType |= 0x80;
                    }
                }
                ((EditText)this.mView).setInputType(inputType);
                break;
            }
            case "password": {
                if (!prop.isBoolean()) break;
                int variation = ((EditText)this.mView).getInputType() & 0xFFF;
                if ((variation & 2) == 2) {
                    if (prop.asBoolean().value().booleanValue()) {
                        ((EditText)this.mView).setInputType(((EditText)this.mView).getInputType() | 0x10);
                        break;
                    }
                    ((EditText)this.mView).setInputType(((EditText)this.mView).getInputType() & 0xFFFFFFEF);
                    break;
                }
                if (prop.asBoolean().value().booleanValue()) {
                    ((EditText)this.mView).setInputType(((EditText)this.mView).getInputType() | 0x80);
                    break;
                }
                ((EditText)this.mView).setInputType(((EditText)this.mView).getInputType() & 0xFFFFFF7F);
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        if (!TextUtils.isEmpty((CharSequence)this.onTextChangeId)) {
            this.callJSResponse(this.onTextChangeId, s.toString());
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (!TextUtils.isEmpty((CharSequence)this.onFocusChangeId)) {
            this.callJSResponse(this.onFocusChangeId, hasFocus);
        }
    }

    @DoricMethod
    public String getText() {
        return ((EditText)this.mView).getText().toString();
    }

    @DoricMethod
    public void setSelection(JSObject jsObject, DoricPromise doricPromise) {
        int start = jsObject.getProperty("start").asNumber().toInt();
        int end = jsObject.getProperty("end").asNumber().toInt();
        ((EditText)this.mView).setSelection(start, end);
        doricPromise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public void requestFocus(DoricPromise promise) {
        ((EditText)this.mView).requestFocus();
        promise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public void releaseFocus(DoricPromise promise) {
        ((EditText)this.mView).clearFocus();
        this.mInputMethodManager.hideSoftInputFromWindow(((EditText)this.mView).getWindowToken(), 0);
        promise.resolve(new JavaValue[0]);
    }
}

