/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Pair;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.DrawableImageViewTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.android.YogaLayout;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import jp.wasabeef.glide.transformations.BlurTransformation;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.shader.ViewNode;
import pub.doric.shader.flex.FlexNode;
import pub.doric.utils.DoricLog;
import pub.doric.utils.DoricUtils;

@DoricPlugin(name="Image")
public class ImageNode
extends ViewNode<ImageView> {
    private String loadCallbackId = "";
    private boolean isBlur;
    private String placeHolderImage;
    private String placeHolderImageBase64;
    private String errorImage;
    private String errorImageBase64;
    private int placeHolderColor = 0;
    private int errorColor = 0;
    private JSObject stretchInset = null;
    private float imageScale = DoricUtils.getScreenScale();

    public ImageNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected void blendLayoutConfig(JSObject jsObject) {
        JSValue maxHeight;
        super.blendLayoutConfig(jsObject);
        JSValue maxWidth = jsObject.getProperty("maxWidth");
        if (maxWidth.isNumber()) {
            ((ImageView)this.mView).setMaxWidth(DoricUtils.dp2px(maxWidth.asNumber().toFloat()));
        }
        if ((maxHeight = jsObject.getProperty("maxHeight")).isNumber()) {
            ((ImageView)this.mView).setMaxHeight(DoricUtils.dp2px(maxWidth.asNumber().toFloat()));
        }
    }

    @Override
    protected ImageView build() {
        AppCompatImageView imageView = new AppCompatImageView(this.getContext()){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        };
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setAdjustViewBounds(true);
        return imageView;
    }

    @Override
    public void blend(JSObject jsObject) {
        if (jsObject != null) {
            JSValue imageScaleValue;
            JSValue stretchInsetValue;
            JSValue errorColor;
            JSValue placeHolderColor;
            JSValue errorBase64;
            JSValue placeHolderBase64;
            JSValue error;
            JSValue placeHolder;
            JSValue jsValue = jsObject.getProperty("isBlur");
            if (jsValue.isBoolean()) {
                this.isBlur = jsValue.asBoolean().value();
            }
            if ((placeHolder = jsObject.getProperty("placeHolderImage")).isString()) {
                this.placeHolderImage = placeHolder.asString().value();
            }
            if ((error = jsObject.getProperty("errorImage")).isString()) {
                this.errorImage = error.asString().value();
            }
            if ((placeHolderBase64 = jsObject.getProperty("placeHolderImageBase64")).isString()) {
                this.placeHolderImageBase64 = placeHolderBase64.asString().value();
            }
            if ((errorBase64 = jsObject.getProperty("errorImageBase64")).isString()) {
                this.errorImageBase64 = errorBase64.asString().value();
            }
            if ((placeHolderColor = jsObject.getProperty("placeHolderColor")).isNumber()) {
                this.placeHolderColor = placeHolderColor.asNumber().toInt();
            }
            if ((errorColor = jsObject.getProperty("errorColor")).isNumber()) {
                this.errorColor = errorColor.asNumber().toInt();
            }
            if ((stretchInsetValue = jsObject.getProperty("stretchInset")).isObject()) {
                this.stretchInset = stretchInsetValue.asObject();
            }
            if ((imageScaleValue = jsObject.getProperty("imageScale")).isNumber()) {
                this.imageScale = imageScaleValue.asNumber().toFloat();
            }
        }
        super.blend(jsObject);
    }

    private Drawable getPlaceHolderDrawable() {
        if (!TextUtils.isEmpty((CharSequence)this.placeHolderImage)) {
            int resId = this.getContext().getResources().getIdentifier(this.placeHolderImage.toLowerCase(), "drawable", this.getContext().getPackageName());
            if (resId > 0) {
                return this.getContext().getResources().getDrawable(resId);
            }
            DoricLog.e("Cannot find PlaceHolder Drawable for " + this.placeHolderImage, new Object[0]);
            return new ColorDrawable(-7829368);
        }
        if (!TextUtils.isEmpty((CharSequence)this.placeHolderImageBase64)) {
            Pair<String, String> result = DoricUtils.translateBase64(this.placeHolderImageBase64);
            if (result != null) {
                String imageType = (String)result.first;
                String base64 = (String)result.second;
                if (!TextUtils.isEmpty((CharSequence)imageType) && !TextUtils.isEmpty((CharSequence)base64)) {
                    try {
                        byte[] data = Base64.decode((String)base64, (int)0);
                        return new BitmapDrawable(this.getContext().getResources(), BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            DoricLog.e("Cannot find PlaceHolderBase64 Drawable for " + this.placeHolderImageBase64, new Object[0]);
            return this.getDoricContext().getDriver().getRegistry().getDefaultPlaceHolderDrawable();
        }
        if (this.placeHolderColor != 0) {
            return new ColorDrawable(this.placeHolderColor);
        }
        return this.getDoricContext().getDriver().getRegistry().getDefaultPlaceHolderDrawable();
    }

    private Drawable getErrorDrawable() {
        if (!TextUtils.isEmpty((CharSequence)this.errorImage)) {
            int resId = this.getContext().getResources().getIdentifier(this.errorImage.toLowerCase(), "drawable", this.getContext().getPackageName());
            if (resId > 0) {
                return this.getContext().getResources().getDrawable(resId);
            }
            DoricLog.e("Cannot find Error Drawable for " + this.errorImage, new Object[0]);
            return new ColorDrawable(-7829368);
        }
        if (!TextUtils.isEmpty((CharSequence)this.errorImageBase64)) {
            Pair<String, String> result = DoricUtils.translateBase64(this.errorImageBase64);
            if (result != null) {
                String imageType = (String)result.first;
                String base64 = (String)result.second;
                if (!TextUtils.isEmpty((CharSequence)imageType) && !TextUtils.isEmpty((CharSequence)base64)) {
                    try {
                        byte[] data = Base64.decode((String)base64, (int)0);
                        return new BitmapDrawable(this.getContext().getResources(), BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            DoricLog.e("Cannot find ErrorBase64 Drawable for " + this.errorImageBase64, new Object[0]);
            return this.getDoricContext().getDriver().getRegistry().getDefaultErrorDrawable();
        }
        if (this.errorColor != 0) {
            return new ColorDrawable(this.errorColor);
        }
        return this.getDoricContext().getDriver().getRegistry().getDefaultErrorDrawable();
    }

    private void loadImageUrl(String url) {
        Context context = DoricUtils.unwrap(this.getContext());
        if (Build.VERSION.SDK_INT >= 17 && context instanceof Activity && ((Activity)context).isDestroyed()) {
            return;
        }
        RequestBuilder requestBuilder = Glide.with((Context)context).load(url);
        this.loadIntoTarget((RequestBuilder<Drawable>)requestBuilder);
    }

    private void loadIntoTarget(RequestBuilder<Drawable> requestBuilder) {
        try {
            Drawable errorDrawable;
            Drawable placeHolderDrawable;
            requestBuilder = requestBuilder.apply(new RequestOptions().override(Integer.MIN_VALUE));
            if (this.isBlur) {
                requestBuilder = requestBuilder.apply((BaseRequestOptions)RequestOptions.bitmapTransform((Transformation)new BlurTransformation(25, 3)));
            }
            if ((placeHolderDrawable = this.getPlaceHolderDrawable()) != null) {
                requestBuilder = requestBuilder.apply((BaseRequestOptions)RequestOptions.placeholderOf((Drawable)placeHolderDrawable));
            }
            if ((errorDrawable = this.getErrorDrawable()) != null) {
                requestBuilder = requestBuilder.apply((BaseRequestOptions)RequestOptions.errorOf((Drawable)errorDrawable));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            DoricLog.e("ImageNode blend error, please check the glide version", new Object[0]);
        }
        requestBuilder.listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                if (!TextUtils.isEmpty((CharSequence)ImageNode.this.loadCallbackId)) {
                    ImageNode.this.callJSResponse(ImageNode.this.loadCallbackId, new Object[0]);
                }
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                if (!TextUtils.isEmpty((CharSequence)ImageNode.this.loadCallbackId)) {
                    if (resource instanceof BitmapDrawable) {
                        Bitmap bitmap = ((BitmapDrawable)resource).getBitmap();
                        ImageNode.this.callJSResponse(ImageNode.this.loadCallbackId, new JSONBuilder().put("width", (Object)Float.valueOf(DoricUtils.px2dp(bitmap.getWidth()))).put("height", (Object)Float.valueOf(DoricUtils.px2dp(bitmap.getHeight()))).toJSONObject());
                    } else {
                        ImageNode.this.callJSResponse(ImageNode.this.loadCallbackId, new JSONBuilder().put("width", (Object)Float.valueOf(DoricUtils.px2dp(resource.getIntrinsicWidth()))).put("height", (Object)Float.valueOf(DoricUtils.px2dp(resource.getIntrinsicHeight()))).toJSONObject());
                    }
                }
                return false;
            }
        }).into((Target)new DrawableImageViewTarget((ImageView)this.mView){

            @SuppressLint(value={"MissingSuperCall"})
            public void getSize(@NonNull SizeReadyCallback cb) {
                cb.onSizeReady(Integer.MIN_VALUE, Integer.MIN_VALUE);
            }

            protected void setResource(@Nullable Drawable resource) {
                if (resource instanceof BitmapDrawable) {
                    Bitmap bitmap = ((BitmapDrawable)resource).getBitmap();
                    float scale = DoricUtils.getScreenScale() / ImageNode.this.imageScale;
                    if (ImageNode.this.imageScale != DoricUtils.getScreenScale()) {
                        Matrix matrix = new Matrix();
                        matrix.setScale(scale, scale);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                        resource = new BitmapDrawable(ImageNode.this.getContext().getResources(), bitmap);
                    }
                    if (ImageNode.this.stretchInset != null) {
                        float left = ImageNode.this.stretchInset.getProperty("left").asNumber().toFloat() * scale;
                        float top = ImageNode.this.stretchInset.getProperty("top").asNumber().toFloat() * scale;
                        float right = ImageNode.this.stretchInset.getProperty("right").asNumber().toFloat() * scale;
                        float bottom = ImageNode.this.stretchInset.getProperty("bottom").asNumber().toFloat() * scale;
                        Rect rect = new Rect((int)left, (int)top, (int)((float)bitmap.getWidth() - right), (int)((float)bitmap.getHeight() - bottom));
                        NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(ImageNode.this.getContext().getResources(), bitmap, DoricUtils.getNinePatchChunk(rect), rect, null);
                        super.setResource((Drawable)ninePatchDrawable);
                    } else {
                        super.setResource(resource);
                    }
                } else {
                    super.setResource(resource);
                }
                if (ImageNode.this.mSuperNode instanceof FlexNode) {
                    YogaNode node = ((YogaLayout)((FlexNode)ImageNode.this.mSuperNode).mView).getYogaNodeForView(ImageNode.this.mView);
                    if (node != null) {
                        node.dirty();
                    }
                    ((ImageView)ImageNode.this.mView).requestLayout();
                }
            }
        });
    }

    @Override
    protected void blend(ImageView view, String name, JSValue prop) {
        block9 : switch (name) {
            case "imageUrl": {
                if (!prop.isString()) {
                    return;
                }
                this.loadImageUrl(prop.asString().value());
                break;
            }
            case "scaleType": {
                if (!prop.isNumber()) {
                    return;
                }
                int scaleType = prop.asNumber().toInt();
                switch (scaleType) {
                    case 1: {
                        view.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        break block9;
                    }
                    case 2: {
                        view.setScaleType(ImageView.ScaleType.CENTER_CROP);
                        break block9;
                    }
                }
                view.setScaleType(ImageView.ScaleType.FIT_XY);
                break;
            }
            case "loadCallback": {
                this.loadCallbackId = prop.asString().value();
                break;
            }
            case "imageBase64": {
                if (!prop.isString()) {
                    return;
                }
                String input = prop.asString().value();
                Pair<String, String> result = DoricUtils.translateBase64(input);
                if (result == null) break;
                String imageType = (String)result.first;
                String base64 = (String)result.second;
                if (TextUtils.isEmpty((CharSequence)imageType) || TextUtils.isEmpty((CharSequence)base64)) break;
                try {
                    byte[] data = Base64.decode((String)base64, (int)0);
                    this.loadIntoTarget((RequestBuilder<Drawable>)Glide.with((Context)this.getContext()).load(data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "imagePath": {
                if (!prop.isString()) {
                    return;
                }
                String localName = prop.asString().value();
                this.loadImageUrl("file:///android_asset/" + localName);
                break;
            }
            case "imageRes": {
                if (!prop.isString()) {
                    return;
                }
                int resId = this.getContext().getResources().getIdentifier(prop.asString().value().toLowerCase(), "drawable", this.getDoricContext().getContext().getPackageName());
                if (resId > 0) {
                    this.loadIntoTarget((RequestBuilder<Drawable>)Glide.with((Context)this.getContext()).load(Integer.valueOf(resId)));
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)this.loadCallbackId)) break;
                this.callJSResponse(this.loadCallbackId, new Object[0]);
                break;
            }
            default: {
                super.blend(view, name, prop);
            }
        }
    }
}

