/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.view.ViewGroup;
import com.github.pengfeizhou.jscore.JSArray;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import java.util.ArrayList;
import pub.doric.DoricContext;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;

public abstract class GroupNode<F extends ViewGroup>
extends SuperNode<F> {
    protected ArrayList<ViewNode> mChildNodes = new ArrayList();
    protected ArrayList<String> mChildViewIds = new ArrayList();

    public GroupNode(DoricContext doricContext) {
        super(doricContext);
    }

    @Override
    protected void blend(F view, String name, JSValue prop) {
        if ("children".equals(name)) {
            this.mChildViewIds.clear();
            if (prop.isArray()) {
                JSArray ids = prop.asArray();
                for (int i = 0; i < ids.size(); ++i) {
                    JSValue value = ids.get(i);
                    if (!value.isString()) continue;
                    this.mChildViewIds.add(value.asString().value());
                }
            }
        } else {
            super.blend(view, name, prop);
        }
    }

    @Override
    public void blend(JSObject jsObject) {
        super.blend(jsObject);
        this.configChildNode();
    }

    protected void configChildNode() {
        for (int idx = 0; idx < this.mChildViewIds.size(); ++idx) {
            String id2 = this.mChildViewIds.get(idx);
            JSObject model = this.getSubModel(id2);
            if (model == null) {
                this.getDoricContext().getDriver().getRegistry().onLog(6, String.format("configChildNode error when Group is %s and  child is %s", this.getId(), id2));
                continue;
            }
            String type = model.getProperty("type").asString().value();
            if (idx < this.mChildNodes.size()) {
                ViewNode oldNode = this.mChildNodes.get(idx);
                if (id2.equals(oldNode.getId())) continue;
                if (this.mReusable) {
                    if (oldNode.getType().equals(type)) {
                        oldNode.setId(id2);
                        oldNode.blend(model.getProperty("props").asObject());
                        continue;
                    }
                    this.mChildNodes.remove(idx);
                    ((ViewGroup)this.mView).removeView(oldNode.getNodeView());
                    ViewNode newNode = ViewNode.create(this.getDoricContext(), type);
                    newNode.setId(id2);
                    newNode.init(this);
                    newNode.blend(model.getProperty("props").asObject());
                    this.mChildNodes.add(idx, newNode);
                    ((ViewGroup)this.mView).addView(newNode.getNodeView(), Math.min(idx, ((ViewGroup)this.mView).getChildCount()), newNode.getLayoutParams());
                    continue;
                }
                int position = -1;
                for (int start = idx + 1; start < this.mChildNodes.size(); ++start) {
                    ViewNode node = this.mChildNodes.get(start);
                    if (!id2.equals(node.getId())) continue;
                    position = start;
                    break;
                }
                if (position >= 0) {
                    ViewNode reused = this.mChildNodes.remove(position);
                    ViewNode abandoned = this.mChildNodes.remove(idx);
                    this.mChildNodes.set(idx, reused);
                    this.mChildNodes.set(position, abandoned);
                    ((ViewGroup)this.mView).removeView(reused.getNodeView());
                    ((ViewGroup)this.mView).addView(reused.getNodeView(), Math.min(idx, ((ViewGroup)this.mView).getChildCount()));
                    ((ViewGroup)this.mView).removeView(abandoned.getNodeView());
                    ((ViewGroup)this.mView).addView(abandoned.getNodeView(), position);
                    continue;
                }
                ViewNode newNode = ViewNode.create(this.getDoricContext(), type);
                newNode.setId(id2);
                newNode.init(this);
                newNode.blend(model.getProperty("props").asObject());
                this.mChildNodes.add(idx, newNode);
                ((ViewGroup)this.mView).addView(newNode.getNodeView(), Math.min(idx, ((ViewGroup)this.mView).getChildCount()), newNode.getLayoutParams());
                continue;
            }
            ViewNode newNode = ViewNode.create(this.getDoricContext(), type);
            newNode.setId(id2);
            newNode.init(this);
            newNode.blend(model.getProperty("props").asObject());
            this.mChildNodes.add(newNode);
            ((ViewGroup)this.mView).addView(newNode.getNodeView(), Math.min(idx, ((ViewGroup)this.mView).getChildCount()), newNode.getLayoutParams());
        }
        int size = this.mChildNodes.size();
        for (int idx = this.mChildViewIds.size(); idx < size; ++idx) {
            ViewNode viewNode = this.mChildNodes.remove(this.mChildViewIds.size());
            ((ViewGroup)this.mView).removeView(viewNode.getNodeView());
        }
    }

    @Override
    protected void blendSubNode(JSObject subProp) {
        String subNodeId = subProp.getProperty("id").asString().value();
        for (ViewNode node : this.mChildNodes) {
            if (!subNodeId.equals(node.getId())) continue;
            node.blend(subProp.getProperty("props").asObject());
            break;
        }
    }

    @Override
    public ViewNode getSubNodeById(String id2) {
        for (ViewNode node : this.mChildNodes) {
            if (!id2.equals(node.getId())) continue;
            return node;
        }
        return null;
    }
}

