/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.shader;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public class DoricLayer
extends FrameLayout {
    private Path mCornerPath = new Path();
    private Paint mShadowPaint;
    private Paint mBorderPaint;
    private RectF mRect = new RectF();
    private float[] mCornerRadii;

    public DoricLayer(@NonNull Context context) {
        super(context);
    }

    public DoricLayer(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DoricLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(api=21)
    public DoricLayer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mRect.left = 0.0f;
        this.mRect.right = this.getWidth();
        this.mRect.top = 0.0f;
        this.mRect.bottom = this.getHeight();
        canvas.save();
        if (this.mCornerRadii != null) {
            this.mCornerPath.reset();
            this.mCornerPath.addRoundRect(this.mRect, this.mCornerRadii, Path.Direction.CW);
            canvas.clipPath(this.mCornerPath);
        }
        super.dispatchDraw(canvas);
        canvas.restore();
        if (this.mBorderPaint != null) {
            ((ViewGroup)this.getParent()).setClipChildren(false);
            if (this.mCornerRadii != null) {
                canvas.drawRoundRect(this.mRect, this.mCornerRadii[0], this.mCornerRadii[1], this.mBorderPaint);
            } else {
                canvas.drawRect(this.mRect, this.mBorderPaint);
            }
        }
        if (this.mShadowPaint != null) {
            ((ViewGroup)this.getParent()).setClipChildren(false);
            canvas.save();
            if (this.mCornerRadii != null) {
                canvas.clipPath(this.mCornerPath, Region.Op.DIFFERENCE);
                canvas.drawRoundRect(this.mRect, this.mCornerRadii[0], this.mCornerRadii[1], this.mShadowPaint);
            } else {
                canvas.clipRect(this.mRect, Region.Op.DIFFERENCE);
                canvas.drawRect(this.mRect, this.mShadowPaint);
            }
            canvas.restore();
        }
    }

    public void setShadow(int sdColor, int sdOpacity, int sdRadius, int offsetX, int offsetY) {
        if (this.mShadowPaint == null) {
            this.mShadowPaint = new Paint();
            this.mShadowPaint.setAntiAlias(false);
            this.mShadowPaint.setStyle(Paint.Style.FILL);
        }
        this.mShadowPaint.setColor(sdColor);
        this.mShadowPaint.setAlpha(sdOpacity);
        this.mShadowPaint.setShadowLayer((float)sdRadius, (float)offsetX, (float)offsetY, sdColor);
    }

    public void setBorder(int borderWidth, int borderColor) {
        if (borderWidth == 0) {
            this.mBorderPaint = null;
        }
        if (this.mBorderPaint == null) {
            this.mBorderPaint = new Paint();
            this.mBorderPaint.setAntiAlias(true);
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
        }
        this.mBorderPaint.setStrokeWidth((float)borderWidth);
        this.mBorderPaint.setColor(borderColor);
    }

    public void setCornerRadius(int corner) {
        this.setCornerRadius(corner, corner, corner, corner);
    }

    public void setCornerRadius(int leftTop, int rightTop, int rightBottom, int leftBottom) {
        this.mCornerRadii = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
    }

    public float getCornerRadius() {
        if (this.mCornerRadii != null) {
            return this.mCornerRadii[0];
        }
        return 0.0f;
    }
}

