/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.refresh;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import pub.doric.refresh.PullingListener;

public class DoricRefreshView
extends FrameLayout
implements PullingListener {
    private View content;
    private Animation.AnimationListener mListener;
    private PullingListener mPullingListener;

    public DoricRefreshView(@NonNull Context context) {
        super(context);
    }

    public DoricRefreshView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public DoricRefreshView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setContent(View v) {
        this.removeAllViews();
        this.content = v;
        ViewGroup.LayoutParams params = v.getLayoutParams();
        if (params instanceof FrameLayout.LayoutParams) {
            ((FrameLayout.LayoutParams)params).gravity = 80;
        } else {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(params == null ? -2 : params.width, params == null ? -2 : params.height);
            layoutParams.gravity = 17;
            v.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.addView(v);
    }

    public View getContent() {
        return this.content;
    }

    public void setPullingListener(PullingListener listener) {
        this.mPullingListener = listener;
    }

    @Override
    public void startAnimation() {
        if (this.mPullingListener != null) {
            this.mPullingListener.startAnimation();
        }
    }

    @Override
    public void stopAnimation() {
        if (this.mPullingListener != null) {
            this.mPullingListener.stopAnimation();
        }
    }

    @Override
    public void setPullingDistance(float distance) {
        if (this.mPullingListener != null) {
            this.mPullingListener.setPullingDistance(distance);
        }
    }

    public void setAnimationListener(Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    protected void onAnimationStart() {
        super.onAnimationStart();
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.getAnimation());
        }
    }

    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.getAnimation());
        }
    }
}

