/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;

@DoricPlugin(name="storage")
public class StoragePlugin
extends DoricJavaPlugin {
    private static final String PREF_NAME = "pref_doric";

    public StoragePlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void setItem(JSObject jsObject, DoricPromise promise) {
        try {
            JSValue zone = jsObject.getProperty("zone");
            String key = jsObject.getProperty("key").asString().value();
            String value = jsObject.getProperty("value").asString().value();
            String prefName = zone.isString() ? "pref_doric_" + zone.asString() : PREF_NAME;
            this.getDoricContext().getContext().getSharedPreferences(prefName, 0).edit().putString(key, value).apply();
            promise.resolve(new JavaValue[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod
    public void getItem(JSObject jsObject, DoricPromise promise) {
        try {
            JSValue zone = jsObject.getProperty("zone");
            String key = jsObject.getProperty("key").asString().value();
            String prefName = zone.isString() ? "pref_doric_" + zone.asString() : PREF_NAME;
            String ret = this.getDoricContext().getContext().getSharedPreferences(prefName, 0).getString(key, "");
            promise.resolve(new JavaValue(ret));
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod
    public void remove(JSObject jsObject, DoricPromise promise) {
        try {
            JSValue zone = jsObject.getProperty("zone");
            String key = jsObject.getProperty("key").asString().value();
            String prefName = zone.isString() ? "pref_doric_" + zone.asString() : PREF_NAME;
            this.getDoricContext().getContext().getSharedPreferences(prefName, 0).edit().remove(key).apply();
            promise.resolve(new JavaValue[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod
    public void clear(JSObject jsObject, DoricPromise promise) {
        try {
            JSValue zone = jsObject.getProperty("zone");
            if (zone.isString()) {
                String prefName = "pref_doric_" + zone.asString();
                this.getDoricContext().getContext().getSharedPreferences(prefName, 0).edit().clear().apply();
                promise.resolve(new JavaValue[0]);
            } else {
                promise.reject(new JavaValue("Zone is empty"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }
}

