/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.app.Activity;
import android.os.Build;
import android.text.TextUtils;
import android.view.Choreographer;
import android.view.View;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.shader.RootNode;
import pub.doric.shader.SuperNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricMetaInfo;
import pub.doric.utils.DoricUtils;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="shader")
public class ShaderPlugin
extends DoricJavaPlugin {
    public ShaderPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void render(final JSObject jsObject, final DoricPromise promise) {
        this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                RootNode rootNode;
                if (ShaderPlugin.this.getDoricContext().getContext() instanceof Activity && Build.VERSION.SDK_INT >= 17 && ((Activity)ShaderPlugin.this.getDoricContext().getContext()).isDestroyed()) {
                    return null;
                }
                String viewId = jsObject.getProperty("id").asString().value();
                ViewNode targetNode = rootNode = ShaderPlugin.this.getDoricContext().getRootNode();
                if (TextUtils.isEmpty((CharSequence)rootNode.getId()) && "Root".equals(jsObject.getProperty("type").asString().value())) {
                    rootNode.setId(viewId);
                    rootNode.blend(jsObject.getProperty("props").asObject());
                } else {
                    ViewNode viewNode = ShaderPlugin.this.getDoricContext().targetViewNode(viewId);
                    if (viewNode != null) {
                        targetNode = viewNode;
                        viewNode.blend(jsObject.getProperty("props").asObject());
                    }
                }
                final View targetView = ((ViewNode)targetNode).getNodeView();
                Choreographer.getInstance().postFrameCallback(new Choreographer.FrameCallback(){

                    public void doFrame(long frameTimeNanos) {
                        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
                        targetView.post(new Runnable(){

                            @Override
                            public void run() {
                                promise.resolve(new JavaValue[0]);
                            }
                        });
                    }
                });
                return null;
            }
        }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

            @Override
            public void onResult(Object result) {
            }

            @Override
            public void onError(Throwable t) {
                ShaderPlugin.this.getDoricContext().getDriver().getRegistry().onException(ShaderPlugin.this.getDoricContext(), t instanceof Exception ? (Exception)t : new RuntimeException(t));
                ShaderPlugin.this.getDoricContext().getDriver().getRegistry().onLog(6, String.format("Shader.render:error%s", t.getLocalizedMessage()));
            }

            @Override
            public void onFinish() {
            }
        });
    }

    @DoricMethod
    public void command(final JSObject jsObject, final DoricPromise doricPromise) {
        this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JSValue[] viewIds = jsObject.getProperty("viewIds").asArray().toArray();
                String name = jsObject.getProperty("name").asString().value();
                final JSValue args = jsObject.getProperty("args");
                ViewNode viewNode = null;
                for (JSValue value : viewIds) {
                    if (viewNode == null) {
                        viewNode = ShaderPlugin.this.getDoricContext().targetViewNode(value.asString().value());
                        continue;
                    }
                    if (!value.isString() || !(viewNode instanceof SuperNode)) continue;
                    String viewId = value.asString().value();
                    viewNode = ((SuperNode)viewNode).getSubNodeById(viewId);
                }
                if (viewNode == null) {
                    doricPromise.reject(new JavaValue("Cannot find opposite view"));
                } else {
                    final ViewNode targetViewNode = viewNode;
                    DoricMetaInfo<ViewNode> pluginInfo = ShaderPlugin.this.getDoricContext().getDriver().getRegistry().acquireViewNodeInfo(viewNode.getType());
                    final Method method = pluginInfo.getMethod(name);
                    if (method == null) {
                        String errMsg = String.format("Cannot find plugin method in class:%s,method:%s", viewNode.getClass(), name);
                        doricPromise.reject(new JavaValue(errMsg));
                    } else {
                        Callable<JavaValue> callable = new Callable<JavaValue>(){

                            @Override
                            public JavaValue call() throws Exception {
                                Class<?>[] classes = method.getParameterTypes();
                                Object ret = classes.length == 0 ? method.invoke((Object)targetViewNode, new Object[0]) : (classes.length == 1 ? method.invoke((Object)targetViewNode, ShaderPlugin.this.createParam(classes[0], doricPromise, args)) : method.invoke((Object)targetViewNode, ShaderPlugin.this.createParam(classes[0], doricPromise, args), ShaderPlugin.this.createParam(classes[1], doricPromise, args)));
                                return DoricUtils.toJavaValue(ret);
                            }
                        };
                        AsyncResult<JavaValue> asyncResult = ShaderPlugin.this.getDoricContext().getDriver().asyncCall(callable, ThreadMode.UI);
                        if (!method.getReturnType().equals(Void.TYPE)) {
                            asyncResult.setCallback(new AsyncResult.Callback<JavaValue>(){

                                @Override
                                public void onResult(JavaValue result) {
                                    doricPromise.resolve(result);
                                }

                                @Override
                                public void onError(Throwable t) {
                                    doricPromise.resolve(new JavaValue(t.getLocalizedMessage()));
                                    ShaderPlugin.this.getDoricContext().getDriver().getRegistry().onException(ShaderPlugin.this.getDoricContext(), t instanceof Exception ? (Exception)t : new RuntimeException(t));
                                }

                                @Override
                                public void onFinish() {
                                }
                            });
                        }
                    }
                }
                return null;
            }
        }, ThreadMode.UI);
    }

    private Object createParam(Class clz, DoricPromise doricPromise, JSValue jsValue) {
        if (clz == DoricPromise.class) {
            return doricPromise;
        }
        try {
            return DoricUtils.toJavaObject(clz, jsValue);
        }
        catch (Exception e) {
            return jsValue;
        }
    }
}

