/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.HashMap;
import org.json.JSONObject;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;

@DoricPlugin(name="notification")
public class NotificationPlugin
extends DoricJavaPlugin {
    private final HashMap<String, BroadcastReceiver> systemReceivers = new HashMap();
    private final HashMap<String, BroadcastReceiver> localReceivers = new HashMap();

    public NotificationPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void publish(JSObject args, DoricPromise promise) {
        String name = args.getProperty("name").asString().value();
        JSValue bizValue = args.getProperty("biz");
        if (bizValue.isString()) {
            String biz = bizValue.asString().value();
            name = "__doric__" + biz + "#" + name;
        }
        String data = null;
        JSValue value = args.getProperty("data");
        if (value.isString()) {
            data = value.asString().value();
        }
        value = args.getProperty("androidSystem");
        boolean androidSystem = false;
        if (value.isBoolean()) {
            androidSystem = value.asBoolean().value();
        }
        Intent intent = new Intent(name);
        intent.putExtra("__doric_data__", data);
        if (androidSystem) {
            String permission = null;
            JSValue jsValue = args.getProperty("permission");
            if (jsValue.isString()) {
                permission = jsValue.asString().value();
            }
            this.getDoricContext().getContext().sendBroadcast(intent, permission);
        } else {
            LocalBroadcastManager.getInstance((Context)this.getDoricContext().getContext()).sendBroadcast(intent);
        }
        promise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public void subscribe(JSObject args, DoricPromise promise) {
        String name = args.getProperty("name").asString().value();
        JSValue bizValue = args.getProperty("biz");
        if (bizValue.isString()) {
            String biz = bizValue.asString().value();
            name = "__doric__" + biz + "#" + name;
        }
        final String callbackId = args.getProperty("callback").asString().value();
        JSValue value = args.getProperty("androidSystem");
        boolean androidSystem = false;
        if (value.isBoolean()) {
            androidSystem = value.asBoolean().value();
        }
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String data = intent.getStringExtra("__doric_data__");
                DoricPromise callback = new DoricPromise(NotificationPlugin.this.getDoricContext(), callbackId);
                if (!TextUtils.isEmpty((CharSequence)data)) {
                    try {
                        callback.resolve(new JavaValue(new JSONObject(data)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Bundle extras = intent.getExtras();
                    if (extras != null) {
                        JSONBuilder builder = new JSONBuilder();
                        for (String key : extras.keySet()) {
                            builder.put(key, extras.get(key));
                        }
                        callback.resolve(new JavaValue(builder.toJSONObject()));
                    } else {
                        callback.resolve(new JavaValue[0]);
                    }
                }
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(name);
        if (androidSystem) {
            String permission = null;
            JSValue jsValue = args.getProperty("permission");
            if (jsValue.isString()) {
                permission = jsValue.asString().value();
            }
            this.getDoricContext().getContext().registerReceiver(receiver, intentFilter, permission, null);
            this.systemReceivers.put(callbackId, receiver);
        } else {
            LocalBroadcastManager.getInstance((Context)this.getDoricContext().getContext()).registerReceiver(receiver, intentFilter);
            this.localReceivers.put(callbackId, receiver);
        }
        promise.resolve(new JavaValue(callbackId));
    }

    @DoricMethod
    public void unsubscribe(String subscribeId, DoricPromise promise) {
        BroadcastReceiver receiver = this.localReceivers.get(subscribeId);
        if (receiver != null) {
            LocalBroadcastManager.getInstance((Context)this.getDoricContext().getContext()).unregisterReceiver(receiver);
            promise.resolve(new JavaValue[0]);
        } else {
            receiver = this.systemReceivers.get(subscribeId);
            if (receiver != null) {
                this.getDoricContext().getContext().unregisterReceiver(receiver);
            }
            promise.resolve(new JavaValue[0]);
        }
    }

    @Override
    public void onTearDown() {
        super.onTearDown();
        for (BroadcastReceiver receiver : this.localReceivers.values()) {
            LocalBroadcastManager.getInstance((Context)this.getDoricContext().getContext()).unregisterReceiver(receiver);
        }
        for (BroadcastReceiver receiver : this.systemReceivers.values()) {
            this.getDoricContext().getContext().unregisterReceiver(receiver);
        }
    }
}

