/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.github.pengfeizhou.jscore.JSONBuilder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JSValue;
import com.github.pengfeizhou.jscore.JavaValue;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import org.json.JSONObject;
import pub.doric.DoricContext;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;

@DoricPlugin(name="network")
public class NetworkPlugin
extends DoricJavaPlugin {
    private OkHttpClient okHttpClient = new OkHttpClient.Builder().build();

    public NetworkPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void request(JSObject requestVal, final DoricPromise promise) {
        try {
            Headers headers;
            String contentType;
            String url = requestVal.getProperty("url").asString().value();
            String method = requestVal.getProperty("method").asString().value().toUpperCase();
            JSValue headerVal = requestVal.getProperty("headers");
            JSValue dataVal = requestVal.getProperty("data");
            JSValue timeoutVal = requestVal.getProperty("timeout");
            Headers.Builder headersBuilder = new Headers.Builder();
            if (headerVal.isObject()) {
                JSObject headerObject = headerVal.asObject();
                Set headerKeys = headerObject.propertySet();
                for (String key : headerKeys) {
                    headersBuilder.add(key, headerObject.getProperty(key).asString().value());
                }
            }
            MediaType mediaType = MediaType.parse((String)(TextUtils.isEmpty((CharSequence)(contentType = (headers = headersBuilder.build()).get("Content-Type"))) ? "application/json; charset=utf-8" : contentType));
            RequestBody requestBody = HttpMethod.permitsRequestBody((String)method) ? RequestBody.create((MediaType)mediaType, (String)(dataVal.isString() ? dataVal.asString().value() : "")) : null;
            Request.Builder requestBuilder = new Request.Builder();
            requestBuilder = requestBuilder.url(url).headers(headers);
            if (HttpMethod.permitsRequestBody((String)method)) {
                requestBuilder = requestBuilder.method(method, requestBody);
            }
            if (timeoutVal.isNumber() && (long)this.okHttpClient.connectTimeoutMillis() != timeoutVal.asNumber().toLong()) {
                this.okHttpClient = this.okHttpClient.newBuilder().connectTimeout(timeoutVal.asNumber().toLong(), TimeUnit.MILLISECONDS).build();
            }
            this.okHttpClient.newCall(requestBuilder.build()).enqueue(new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    promise.reject(new JavaValue(e.getLocalizedMessage()));
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                    JSONBuilder header = new JSONBuilder();
                    for (String key : response.headers().names()) {
                        header.put(key, (Object)response.headers().get(key));
                    }
                    JSONObject jsonObject = new JSONBuilder().put("status", (Object)response.code()).put("headers", (Object)header.toJSONObject()).put("data", (Object)(response.body() == null ? "" : response.body().string())).toJSONObject();
                    promise.resolve(new JavaValue(jsonObject));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }
}

