/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.pengfeizhou.jscore.ArchiveException;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.navbar.IDoricNavBar;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.shader.ViewNode;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="navbar")
public class NavBarPlugin
extends DoricJavaPlugin {
    private static final String TYPE_LEFT = "navbar_left";
    private static final String TYPE_RIGHT = "navbar_right";
    private static final String TYPE_CENTER = "navbar_center";

    public NavBarPlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void isHidden(DoricPromise promise) {
        IDoricNavBar navBar = this.getDoricContext().getDoricNavBar();
        if (navBar == null) {
            promise.reject(new JavaValue("Not implement NavBar"));
        } else {
            promise.resolve(new JavaValue(navBar.isHidden()));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void setHidden(JSDecoder jsDecoder, DoricPromise promise) {
        IDoricNavBar navBar = this.getDoricContext().getDoricNavBar();
        if (navBar == null) {
            promise.reject(new JavaValue("Not implement NavBar"));
        } else {
            try {
                JSObject jsObject = jsDecoder.decode().asObject();
                boolean hidden = jsObject.getProperty("hidden").asBoolean().value();
                navBar.setHidden(hidden);
                promise.resolve(new JavaValue[0]);
            }
            catch (ArchiveException e) {
                e.printStackTrace();
                promise.reject(new JavaValue(e.getLocalizedMessage()));
            }
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void setTitle(JSDecoder jsDecoder, DoricPromise promise) {
        IDoricNavBar navBar = this.getDoricContext().getDoricNavBar();
        if (navBar == null) {
            promise.reject(new JavaValue("Not implement NavBar"));
        } else {
            try {
                JSObject jsObject = jsDecoder.decode().asObject();
                String title = jsObject.getProperty("title").asString().value();
                navBar.setTitle(title);
                promise.resolve(new JavaValue[0]);
            }
            catch (ArchiveException e) {
                e.printStackTrace();
                promise.reject(new JavaValue(e.getLocalizedMessage()));
            }
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void setBgColor(JSDecoder jsDecoder, DoricPromise promise) {
        IDoricNavBar navBar = this.getDoricContext().getDoricNavBar();
        if (navBar == null) {
            promise.reject(new JavaValue("Not implement NavBar"));
        } else {
            try {
                JSObject jsObject = jsDecoder.decode().asObject();
                int color = jsObject.getProperty("color").asNumber().toInt();
                navBar.setBackgroundColor(color);
                promise.resolve(new JavaValue[0]);
            }
            catch (ArchiveException e) {
                e.printStackTrace();
                promise.reject(new JavaValue(e.getLocalizedMessage()));
            }
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void setLeft(JSDecoder decoder, final DoricPromise promise) {
        try {
            final JSObject jsObject = decoder.decode().asObject();
            this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String viewId = jsObject.getProperty("id").asString().value();
                    String type = jsObject.getProperty("type").asString().value();
                    ViewNode node = ViewNode.create(NavBarPlugin.this.getDoricContext(), type);
                    node.setId(viewId);
                    node.init((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                    node.blend(jsObject.getProperty("props").asObject());
                    NavBarPlugin.this.getDoricContext().getDoricNavBar().setLeft(node.getNodeView());
                    NavBarPlugin.this.getDoricContext().clearHeadNodes(NavBarPlugin.TYPE_LEFT);
                    NavBarPlugin.this.getDoricContext().addHeadNode(NavBarPlugin.TYPE_LEFT, node);
                    return null;
                }
            }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

                @Override
                public void onResult(Object result) {
                    promise.resolve(new JavaValue[0]);
                }

                @Override
                public void onError(Throwable t) {
                    t.printStackTrace();
                    promise.reject(new JavaValue(t.getLocalizedMessage()));
                }

                @Override
                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void setRight(JSDecoder decoder, final DoricPromise promise) {
        try {
            final JSObject jsObject = decoder.decode().asObject();
            this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String viewId = jsObject.getProperty("id").asString().value();
                    String type = jsObject.getProperty("type").asString().value();
                    ViewNode node = ViewNode.create(NavBarPlugin.this.getDoricContext(), type);
                    node.setId(viewId);
                    node.init((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                    node.blend(jsObject.getProperty("props").asObject());
                    NavBarPlugin.this.getDoricContext().getDoricNavBar().setRight(node.getNodeView());
                    NavBarPlugin.this.getDoricContext().clearHeadNodes(NavBarPlugin.TYPE_RIGHT);
                    NavBarPlugin.this.getDoricContext().addHeadNode(NavBarPlugin.TYPE_RIGHT, node);
                    return null;
                }
            }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

                @Override
                public void onResult(Object result) {
                    promise.resolve(new JavaValue[0]);
                }

                @Override
                public void onError(Throwable t) {
                    t.printStackTrace();
                    promise.reject(new JavaValue(t.getLocalizedMessage()));
                }

                @Override
                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }

    @DoricMethod(thread=ThreadMode.UI)
    public void setCenter(JSDecoder decoder, final DoricPromise promise) {
        try {
            final JSObject jsObject = decoder.decode().asObject();
            this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String viewId = jsObject.getProperty("id").asString().value();
                    String type = jsObject.getProperty("type").asString().value();
                    ViewNode node = ViewNode.create(NavBarPlugin.this.getDoricContext(), type);
                    node.setId(viewId);
                    node.init((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                    node.blend(jsObject.getProperty("props").asObject());
                    NavBarPlugin.this.getDoricContext().getDoricNavBar().setCenter(node.getNodeView());
                    NavBarPlugin.this.getDoricContext().clearHeadNodes(NavBarPlugin.TYPE_CENTER);
                    NavBarPlugin.this.getDoricContext().addHeadNode(NavBarPlugin.TYPE_CENTER, node);
                    return null;
                }
            }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

                @Override
                public void onResult(Object result) {
                    promise.resolve(new JavaValue[0]);
                }

                @Override
                public void onError(Throwable t) {
                    t.printStackTrace();
                    promise.reject(new JavaValue(t.getLocalizedMessage()));
                }

                @Override
                public void onFinish() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject(new JavaValue(e.getLocalizedMessage()));
        }
    }
}

