/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.plugin;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.text.TextUtils;
import com.github.pengfeizhou.jscore.JSObject;
import com.github.pengfeizhou.jscore.JavaValue;
import java.util.concurrent.Callable;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;
import pub.doric.extension.bridge.DoricMethod;
import pub.doric.extension.bridge.DoricPlugin;
import pub.doric.extension.bridge.DoricPromise;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.shader.RootNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricLog;
import pub.doric.utils.ThreadMode;

@DoricPlugin(name="animate")
public class AnimatePlugin
extends DoricJavaPlugin {
    public AnimatePlugin(DoricContext doricContext) {
        super(doricContext);
    }

    @DoricMethod
    public void submit(DoricPromise promise) {
        promise.resolve(new JavaValue[0]);
    }

    @DoricMethod
    public void animateRender(final JSObject jsObject, final DoricPromise promise) {
        this.getDoricContext().getDriver().asyncCall(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                long duration = jsObject.getProperty("duration").asNumber().toLong();
                AnimatorSet animatorSet = new AnimatorSet();
                AnimatePlugin.this.getDoricContext().setAnimatorSet(animatorSet);
                String viewId = jsObject.getProperty("id").asString().value();
                RootNode rootNode = AnimatePlugin.this.getDoricContext().getRootNode();
                if (TextUtils.isEmpty((CharSequence)rootNode.getId())) {
                    rootNode.setId(viewId);
                    rootNode.blend(jsObject.getProperty("props").asObject());
                } else {
                    ViewNode viewNode = AnimatePlugin.this.getDoricContext().targetViewNode(viewId);
                    if (viewNode != null) {
                        viewNode.blend(jsObject.getProperty("props").asObject());
                    }
                }
                AnimatePlugin.this.getDoricContext().setAnimatorSet(null);
                animatorSet.setDuration(duration);
                animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        promise.resolve(new JavaValue[0]);
                    }
                });
                animatorSet.start();
                return null;
            }
        }, ThreadMode.UI).setCallback(new AsyncResult.Callback<Object>(){

            @Override
            public void onResult(Object result) {
            }

            @Override
            public void onError(Throwable t) {
                t.printStackTrace();
                DoricLog.e("Shader.render:error%s", t.getLocalizedMessage());
                promise.reject(new JavaValue(t.getLocalizedMessage()));
            }

            @Override
            public void onFinish() {
            }
        });
    }
}

