/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.loader;

import android.net.Uri;
import android.text.TextUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pub.doric.async.AsyncResult;
import pub.doric.loader.DoricAssetJSLoader;
import pub.doric.loader.DoricHttpJSLoader;
import pub.doric.loader.IDoricJSLoader;

public class DoricJSLoaderManager {
    private Set<IDoricJSLoader> jsLoaders = new HashSet<IDoricJSLoader>();

    private DoricJSLoaderManager() {
        this.addJSLoader(new DoricAssetJSLoader());
        this.addJSLoader(new DoricHttpJSLoader());
    }

    public void addJSLoader(IDoricJSLoader jsLoader) {
        this.jsLoaders.add(jsLoader);
    }

    private Collection<IDoricJSLoader> getJSLoaders() {
        return this.jsLoaders;
    }

    public static DoricJSLoaderManager getInstance() {
        return Inner.sInstance;
    }

    public AsyncResult<String> loadJSBundle(String source) {
        if (!TextUtils.isEmpty((CharSequence)source)) {
            if (source.startsWith("_internal_://")) {
                Uri uri = Uri.parse((String)source);
                String srcContextId = uri.getQueryParameter("context");
                String className = uri.getQueryParameter("class");
                source = String.format("Entry('%s','%s')", srcContextId, className);
                return new AsyncResult<String>(source);
            }
            Collection<IDoricJSLoader> jsLoaders = this.getJSLoaders();
            for (IDoricJSLoader jsLoader : jsLoaders) {
                if (!jsLoader.filter(source)) continue;
                return jsLoader.request(source);
            }
        }
        AsyncResult<String> ret = new AsyncResult<String>();
        ret.setError(new RuntimeException("Cannot find JS Loader for " + source));
        return ret;
    }

    private static class Inner {
        private static final DoricJSLoaderManager sInstance = new DoricJSLoaderManager();

        private Inner() {
        }
    }
}

