/*
 * Decompiled with CFR 0.152.
 */
package pub.doric.extension.bridge;

import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JavaValue;
import pub.doric.DoricContext;
import pub.doric.async.AsyncResult;

public class DoricPromise {
    private final DoricContext context;
    private final String callbackId;

    public DoricPromise(DoricContext context, String callbackId) {
        this.context = context;
        this.callbackId = callbackId;
    }

    public void resolve(JavaValue ... javaValue) {
        Object[] params = new Object[javaValue.length + 2];
        params[0] = this.context.getContextId();
        params[1] = this.callbackId;
        System.arraycopy(javaValue, 0, params, 2, javaValue.length);
        this.context.getDriver().invokeDoricMethod("jsCallResolve", params).setCallback(new AsyncResult.Callback<JSDecoder>(){

            @Override
            public void onResult(JSDecoder result) {
            }

            @Override
            public void onError(Throwable t) {
                DoricPromise.this.context.getDriver().getRegistry().onException(DoricPromise.this.context, t instanceof Exception ? (Exception)t : new RuntimeException(t));
            }

            @Override
            public void onFinish() {
            }
        });
    }

    public void reject(JavaValue ... javaValue) {
        Object[] params = new Object[javaValue.length + 2];
        params[0] = this.context.getContextId();
        params[1] = this.callbackId;
        System.arraycopy(javaValue, 0, params, 2, javaValue.length);
        this.context.getDriver().invokeDoricMethod("jsCallReject", params).setCallback(new AsyncResult.Callback<JSDecoder>(){

            @Override
            public void onResult(JSDecoder result) {
            }

            @Override
            public void onError(Throwable t) {
                DoricPromise.this.context.getDriver().getRegistry().onException(DoricPromise.this.context, t instanceof Exception ? (Exception)t : new RuntimeException(t));
            }

            @Override
            public void onFinish() {
            }
        });
    }
}

